/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.annotate.LineNumberListener;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.UpToDateLineNumberProviderImpl;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitUtil;
import git4idea.repo.GitRepository;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.GithubShowCommitInBrowserAction;
import org.jetbrains.plugins.github.util.GithubUtil;

public class GithubShowCommitInBrowserFromAnnotateAction
extends GithubShowCommitInBrowserAction
implements LineNumberListener {
    private final FileAnnotation myAnnotation;
    private int myLineNumber = -1;

    public GithubShowCommitInBrowserFromAnnotateAction(FileAnnotation annotation) {
        this.myAnnotation = annotation;
    }

    public void update(AnActionEvent e) {
        EventData eventData = GithubShowCommitInBrowserFromAnnotateAction.calcData(e, this.myLineNumber);
        if (eventData == null) {
            e.getPresentation().setEnabled(false);
            e.getPresentation().setVisible(false);
            return;
        }
        int corrected = eventData.getCorrectedLineNumber();
        e.getPresentation().setEnabled(corrected >= 0 && this.myAnnotation.getLineRevisionNumber(corrected) != null);
        e.getPresentation().setVisible(GithubUtil.isRepositoryOnGitHub(eventData.getRepository()));
    }

    public void actionPerformed(AnActionEvent e) {
        EventData eventData = GithubShowCommitInBrowserFromAnnotateAction.calcData(e, this.myLineNumber);
        if (eventData == null) {
            return;
        }
        VcsRevisionNumber revisionNumber = this.myAnnotation.getLineRevisionNumber(eventData.getCorrectedLineNumber());
        if (revisionNumber != null) {
            GithubShowCommitInBrowserFromAnnotateAction.openInBrowser(eventData.getProject(), eventData.getRepository(), revisionNumber.asString());
        }
    }

    @Nullable
    private static EventData calcData(AnActionEvent e, int lineNumber) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        VirtualFile virtualFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (project == null || virtualFile == null) {
            return null;
        }
        Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
        if (document == null) {
            return null;
        }
        UpToDateLineNumberProviderImpl myGetUpToDateLineNumber = new UpToDateLineNumberProviderImpl(document, project);
        int corrected = myGetUpToDateLineNumber.getLineNumber(lineNumber);
        GitRepository repository = (GitRepository)GitUtil.getRepositoryManager((Project)project).getRepositoryForFile(virtualFile);
        if (repository == null) {
            return null;
        }
        return new EventData(project, repository, corrected);
    }

    public void consume(Integer integer) {
        this.myLineNumber = integer;
    }

    private static class EventData {
        @NotNull
        private final Project myProject;
        @NotNull
        private final GitRepository myRepository;
        private final int myCorrectedLineNumber;

        private EventData(@NotNull Project project, @NotNull GitRepository repository, int correctedLineNumber) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/github/GithubShowCommitInBrowserFromAnnotateAction$EventData", "<init>"));
            }
            if (repository == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "org/jetbrains/plugins/github/GithubShowCommitInBrowserFromAnnotateAction$EventData", "<init>"));
            }
            this.myProject = project;
            this.myRepository = repository;
            this.myCorrectedLineNumber = correctedLineNumber;
        }

        @NotNull
        public Project getProject() {
            Project project = this.myProject;
            if (project == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/GithubShowCommitInBrowserFromAnnotateAction$EventData", "getProject"));
            }
            return project;
        }

        @NotNull
        public GitRepository getRepository() {
            GitRepository gitRepository = this.myRepository;
            if (gitRepository == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/GithubShowCommitInBrowserFromAnnotateAction$EventData", "getRepository"));
            }
            return gitRepository;
        }

        private int getCorrectedLineNumber() {
            return this.myCorrectedLineNumber;
        }
    }
}

