/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils;

import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.codehaus.plexus.archiver.jar.Manifest;
import org.codehaus.plexus.archiver.jar.ManifestException;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.importing.ManifestImporter;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.utils.MavenJDOMUtil;

public class ManifestBuilder {
    private static final Map<String, String> PACKAGING_PLUGINS = ContainerUtil.newHashMap((Pair)Pair.create((Object)"jar", (Object)"maven-jar-plugin"), (Pair[])new Pair[]{Pair.create((Object)"ejb", (Object)"maven-ejb-plugin"), Pair.create((Object)"ejb-client", (Object)"maven-ejb-plugin"), Pair.create((Object)"war", (Object)"maven-war-plugin"), Pair.create((Object)"ear", (Object)"maven-ear-plugin")});
    @NotNull
    private final MavenProject myMavenProject;
    @Nullable
    private String myJdkVersion;

    public ManifestBuilder(@NotNull MavenProject mavenProject) {
        if (mavenProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mavenProject", "org/jetbrains/idea/maven/utils/ManifestBuilder", "<init>"));
        }
        this.myMavenProject = mavenProject;
    }

    public ManifestBuilder withJdkVersion(String jdkVersion) {
        this.myJdkVersion = jdkVersion;
        return this;
    }

    @NotNull
    public Manifest build() throws ManifestBuilderException {
        Element mavenArchiveConfiguration;
        block9: {
            org.codehaus.plexus.archiver.jar.Manifest manifest;
            try {
                Element mavenPackagingPluginConfiguration = null;
                String packaging = this.myMavenProject.getPackaging();
                if (StringUtil.isEmpty((String)packaging)) {
                    mavenPackagingPluginConfiguration = this.myMavenProject.getPluginConfiguration("org.apache.maven.plugins", "maven-jar-plugin");
                } else {
                    String pluginArtifactId = PACKAGING_PLUGINS.get(StringUtil.toLowerCase((String)packaging));
                    if (pluginArtifactId != null) {
                        mavenPackagingPluginConfiguration = this.myMavenProject.getPluginConfiguration("org.apache.maven.plugins", pluginArtifactId);
                    }
                }
                Element element = mavenArchiveConfiguration = mavenPackagingPluginConfiguration != null ? mavenPackagingPluginConfiguration.getChild("archive") : null;
                if (mavenArchiveConfiguration != null) break block9;
                manifest = this.getDefaultManifest(Collections.<String, String>emptyMap());
            }
            catch (ManifestException e) {
                throw new ManifestBuilderException(e);
            }
            if (manifest == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/utils/ManifestBuilder", "build"));
            }
            return manifest;
        }
        Element manifestEntries = mavenArchiveConfiguration.getChild("manifestEntries");
        Map<String, String> entries = ManifestBuilder.getManifestEntries(manifestEntries);
        Element manifestConfiguration = mavenArchiveConfiguration.getChild("manifest");
        org.codehaus.plexus.archiver.jar.Manifest configuredManifest = ManifestBuilder.getConfiguredManifest(this.myMavenProject, manifestConfiguration, entries);
        if (!entries.isEmpty()) {
            ManifestBuilder.addManifestEntries(configuredManifest, entries);
        }
        ManifestBuilder.addCustomManifestSections(configuredManifest, mavenArchiveConfiguration);
        org.codehaus.plexus.archiver.jar.Manifest finalManifest = this.getDefaultManifest(entries);
        ManifestBuilder.merge((Manifest)finalManifest, (Manifest)configuredManifest);
        org.codehaus.plexus.archiver.jar.Manifest userSuppliedManifest = this.getUserSuppliedManifest(mavenArchiveConfiguration);
        ManifestBuilder.merge((Manifest)finalManifest, (Manifest)userSuppliedManifest);
        org.codehaus.plexus.archiver.jar.Manifest manifest = finalManifest;
        if (manifest == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/utils/ManifestBuilder", "build"));
        }
        return manifest;
    }

    @NotNull
    public static String getClasspathPrefix(@Nullable Element manifestConfiguration) {
        String classpathPrefix = MavenJDOMUtil.findChildValueByPath(manifestConfiguration, "classpathPrefix", "").replaceAll("\\\\", "/");
        if (classpathPrefix.length() != 0 && !classpathPrefix.endsWith("/")) {
            classpathPrefix = classpathPrefix + "/";
        }
        String string = classpathPrefix;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/utils/ManifestBuilder", "getClasspathPrefix"));
        }
        return string;
    }

    private static Map<String, String> getManifestEntries(Element manifestEntries) {
        LinkedHashMap<String, String> entries;
        boolean hasManifestEntries = manifestEntries != null && manifestEntries.getContentSize() > 0;
        LinkedHashMap<String, String> linkedHashMap = entries = hasManifestEntries ? new LinkedHashMap<String, String>(manifestEntries.getContentSize()) : Collections.emptyMap();
        if (hasManifestEntries) {
            for (Element element : manifestEntries.getChildren()) {
                entries.put(element.getName(), element.getTextTrim());
            }
        }
        return entries;
    }

    private static void addCustomManifestSections(@NotNull org.codehaus.plexus.archiver.jar.Manifest manifest, @NotNull Element mavenArchiveConfiguration) throws ManifestException {
        if (manifest == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manifest", "org/jetbrains/idea/maven/utils/ManifestBuilder", "addCustomManifestSections"));
        }
        if (mavenArchiveConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mavenArchiveConfiguration", "org/jetbrains/idea/maven/utils/ManifestBuilder", "addCustomManifestSections"));
        }
        for (Element section : MavenJDOMUtil.findChildrenByPath(mavenArchiveConfiguration, "manifestSections", "manifestSection")) {
            Manifest.Section theSection = new Manifest.Section();
            String sectionName = MavenJDOMUtil.findChildValueByPath(section, "name");
            theSection.setName(sectionName);
            Element manifestEntries = section.getChild("manifestEntries");
            Map<String, String> entries = ManifestBuilder.getManifestEntries(manifestEntries);
            if (!entries.isEmpty()) {
                for (Map.Entry<String, String> entry : entries.entrySet()) {
                    Manifest.Attribute attr = new Manifest.Attribute(entry.getKey(), entry.getValue());
                    theSection.addConfiguredAttribute(attr);
                }
            }
            manifest.addConfiguredSection(theSection);
        }
    }

    @NotNull
    private org.codehaus.plexus.archiver.jar.Manifest getDefaultManifest(@NotNull Map<String, String> entries) throws ManifestException {
        if (entries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entries", "org/jetbrains/idea/maven/utils/ManifestBuilder", "getDefaultManifest"));
        }
        org.codehaus.plexus.archiver.jar.Manifest finalManifest = new org.codehaus.plexus.archiver.jar.Manifest();
        ManifestBuilder.addManifestAttribute(finalManifest, entries, "Created-By", ApplicationNamesInfo.getInstance().getFullProductName());
        ManifestBuilder.addManifestAttribute(finalManifest, entries, "Built-By", System.getProperty("user.name"));
        if (!StringUtil.isEmpty((String)this.myJdkVersion)) {
            ManifestBuilder.addManifestAttribute(finalManifest, entries, "Build-Jdk", this.myJdkVersion);
        }
        org.codehaus.plexus.archiver.jar.Manifest manifest = finalManifest;
        if (manifest == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/utils/ManifestBuilder", "getDefaultManifest"));
        }
        return manifest;
    }

    private static void addManifestEntries(@NotNull org.codehaus.plexus.archiver.jar.Manifest manifest, @NotNull Map<String, String> entries) throws ManifestException {
        if (manifest == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manifest", "org/jetbrains/idea/maven/utils/ManifestBuilder", "addManifestEntries"));
        }
        if (entries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entries", "org/jetbrains/idea/maven/utils/ManifestBuilder", "addManifestEntries"));
        }
        if (!entries.isEmpty()) {
            for (Map.Entry<String, String> entry : entries.entrySet()) {
                Manifest.ExistingAttribute attr = manifest.getMainSection().getAttribute(entry.getKey());
                if ("Class-Path".equals(entry.getKey()) && attr != null) {
                    attr.setValue(entry.getValue() + " " + attr.getValue());
                    continue;
                }
                ManifestBuilder.addManifestAttribute(manifest, entry.getKey(), entry.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Nullable
    private org.codehaus.plexus.archiver.jar.Manifest getUserSuppliedManifest(@Nullable Element mavenArchiveConfiguration) {
        org.codehaus.plexus.archiver.jar.Manifest manifest = null;
        String manifestPath = MavenJDOMUtil.findChildValueByPath(mavenArchiveConfiguration, "manifestFile");
        if (manifestPath != null) {
            File manifestFile = new File(manifestPath);
            if (!manifestFile.isAbsolute()) {
                manifestFile = new File(this.myMavenProject.getDirectory(), manifestPath);
            }
            if (manifestFile.isFile()) {
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(manifestFile);
                    manifest = new org.codehaus.plexus.archiver.jar.Manifest((InputStream)fis);
                }
                catch (IOException ignore) {
                    StreamUtil.closeStream((Closeable)fis);
                    catch (Throwable throwable) {
                        StreamUtil.closeStream(fis);
                        throw throwable;
                    }
                }
                StreamUtil.closeStream((Closeable)fis);
            }
        }
        return manifest;
    }

    @NotNull
    private static org.codehaus.plexus.archiver.jar.Manifest getConfiguredManifest(@NotNull MavenProject mavenProject, @Nullable Element manifestConfiguration, @NotNull Map<String, String> entries) throws ManifestException {
        ManifestImporter manifestImporter;
        String classpath;
        boolean isAddClasspath;
        String mainClass;
        String packageName;
        boolean isAddDefaultImplementationEntries;
        if (mavenProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mavenProject", "org/jetbrains/idea/maven/utils/ManifestBuilder", "getConfiguredManifest"));
        }
        if (entries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entries", "org/jetbrains/idea/maven/utils/ManifestBuilder", "getConfiguredManifest"));
        }
        org.codehaus.plexus.archiver.jar.Manifest manifest = new org.codehaus.plexus.archiver.jar.Manifest();
        boolean isAddDefaultSpecificationEntries = Boolean.valueOf(MavenJDOMUtil.findChildValueByPath(manifestConfiguration, "addDefaultSpecificationEntries", "false"));
        if (isAddDefaultSpecificationEntries) {
            ManifestBuilder.addManifestAttribute(manifest, entries, "Specification-Title", mavenProject.getName());
            ManifestBuilder.addManifestAttribute(manifest, entries, "Specification-Version", mavenProject.getMavenId().getVersion());
        }
        if (isAddDefaultImplementationEntries = Boolean.valueOf(MavenJDOMUtil.findChildValueByPath(manifestConfiguration, "addDefaultImplementationEntries", "false")).booleanValue()) {
            ManifestBuilder.addManifestAttribute(manifest, entries, "Implementation-Title", mavenProject.getName());
            ManifestBuilder.addManifestAttribute(manifest, entries, "Implementation-Version", mavenProject.getMavenId().getVersion());
            ManifestBuilder.addManifestAttribute(manifest, entries, "Implementation-Vendor-Id", mavenProject.getMavenId().getGroupId());
        }
        if ((packageName = MavenJDOMUtil.findChildValueByPath(manifestConfiguration, "packageName")) != null) {
            ManifestBuilder.addManifestAttribute(manifest, entries, "Package", packageName);
        }
        if (!StringUtil.isEmpty((String)(mainClass = MavenJDOMUtil.findChildValueByPath(manifestConfiguration, "mainClass")))) {
            ManifestBuilder.addManifestAttribute(manifest, entries, "Main-Class", mainClass);
        }
        if ((isAddClasspath = Boolean.valueOf(MavenJDOMUtil.findChildValueByPath(manifestConfiguration, "addClasspath", "false")).booleanValue()) && !(classpath = (manifestImporter = ManifestImporter.getManifestImporter(mavenProject.getPackaging())).getClasspath(mavenProject, manifestConfiguration)).isEmpty()) {
            ManifestBuilder.addManifestAttribute(manifest, "Class-Path", classpath);
        }
        org.codehaus.plexus.archiver.jar.Manifest manifest2 = manifest;
        if (manifest2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/utils/ManifestBuilder", "getConfiguredManifest"));
        }
        return manifest2;
    }

    private static void addManifestAttribute(@NotNull org.codehaus.plexus.archiver.jar.Manifest manifest, @NotNull Map<String, String> map, String key, String value) throws ManifestException {
        if (manifest == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manifest", "org/jetbrains/idea/maven/utils/ManifestBuilder", "addManifestAttribute"));
        }
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "org/jetbrains/idea/maven/utils/ManifestBuilder", "addManifestAttribute"));
        }
        if (map.containsKey(key)) {
            return;
        }
        ManifestBuilder.addManifestAttribute(manifest, key, value);
    }

    private static void addManifestAttribute(@NotNull org.codehaus.plexus.archiver.jar.Manifest manifest, String key, String value) throws ManifestException {
        if (manifest == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manifest", "org/jetbrains/idea/maven/utils/ManifestBuilder", "addManifestAttribute"));
        }
        if (!StringUtil.isEmpty((String)value)) {
            Manifest.Attribute attr = new Manifest.Attribute(key, value);
            manifest.addConfiguredAttribute(attr);
        }
    }

    private static void merge(@NotNull Manifest target, @Nullable Manifest other) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/idea/maven/utils/ManifestBuilder", "merge"));
        }
        if (other != null) {
            ManifestBuilder.mergeAttributes(target.getMainAttributes(), other.getMainAttributes());
            for (Map.Entry<String, Attributes> o : other.getEntries().entrySet()) {
                Attributes ourSection = target.getAttributes(o.getKey());
                Attributes otherSection = o.getValue();
                if (ourSection == null) {
                    if (otherSection == null) continue;
                    target.getEntries().put(o.getKey(), (Attributes)otherSection.clone());
                    continue;
                }
                ManifestBuilder.mergeAttributes(ourSection, otherSection);
            }
        }
    }

    private static void mergeAttributes(@NotNull Attributes target, @NotNull Attributes section) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/idea/maven/utils/ManifestBuilder", "mergeAttributes"));
        }
        if (section == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "section", "org/jetbrains/idea/maven/utils/ManifestBuilder", "mergeAttributes"));
        }
        for (Object o : section.keySet()) {
            Attributes.Name key = (Attributes.Name)o;
            Object value = section.get(o);
            target.put(key, value);
        }
    }

    public static class ManifestBuilderException
    extends Exception {
        public ManifestBuilderException(Throwable cause) {
            super(cause);
        }
    }
}

