/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.assignment;

import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.assignment.CallInfo;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;

public abstract class CallInfoBase<T extends GrCall>
implements CallInfo<T> {
    private final T myCall;
    private final PsiType[] myArgTypes;

    protected CallInfoBase(T call) {
        this.myCall = call;
        this.myArgTypes = this.inferArgTypes();
    }

    @Nullable
    protected abstract PsiType[] inferArgTypes();

    @Override
    @Nullable
    public GrArgumentList getArgumentList() {
        return this.myCall.getArgumentList();
    }

    @Override
    @Nullable
    public PsiType[] getArgumentTypes() {
        return this.myArgTypes;
    }

    @Override
    @NotNull
    public GroovyResolveResult advancedResolve() {
        GroovyResolveResult groovyResolveResult = this.myCall.advancedResolve();
        if (groovyResolveResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/assignment/CallInfoBase", "advancedResolve"));
        }
        return groovyResolveResult;
    }

    @Override
    @NotNull
    public GroovyResolveResult[] multiResolve() {
        GroovyResolveResult[] groovyResolveResultArray = this.myCall.multiResolve(false);
        if (groovyResolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/assignment/CallInfoBase", "multiResolve"));
        }
        return groovyResolveResultArray;
    }

    @Override
    @NotNull
    public T getCall() {
        T t = this.myCall;
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/assignment/CallInfoBase", "getCall"));
        }
        return t;
    }

    @Override
    @NotNull
    public GrExpression[] getExpressionArguments() {
        GrExpression[] grExpressionArray = this.myCall.getExpressionArguments();
        if (grExpressionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/assignment/CallInfoBase", "getExpressionArguments"));
        }
        return grExpressionArray;
    }

    @Override
    @NotNull
    public GrClosableBlock[] getClosureArguments() {
        GrClosableBlock[] grClosableBlockArray = this.myCall.getClosureArguments();
        if (grClosableBlockArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/assignment/CallInfoBase", "getClosureArguments"));
        }
        return grClosableBlockArray;
    }

    @Override
    @NotNull
    public GrNamedArgument[] getNamedArguments() {
        GrNamedArgument[] grNamedArgumentArray = this.myCall.getNamedArguments();
        if (grNamedArgumentArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/assignment/CallInfoBase", "getNamedArguments"));
        }
        return grNamedArgumentArray;
    }
}

