/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.dsl;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.codehaus.groovy.runtime.GroovyCategorySupport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.dsl.Factor;

public class GroovyClassDescriptor {
    private final PsiType myPsiType;
    private final PsiElement myPlace;
    private final PsiFile myFile;
    private final String myTypeText;
    final Set<Factor> affectingFactors;

    public GroovyClassDescriptor(@NotNull PsiType psiType, PsiElement place, PsiFile placeFile) {
        if (psiType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiType", "org/jetbrains/plugins/groovy/dsl/GroovyClassDescriptor", "<init>"));
        }
        this.affectingFactors = new LinkedHashSet<Factor>();
        this.myPsiType = psiType;
        this.myPlace = place;
        this.myFile = placeFile;
        this.myTypeText = this.myPsiType.getCanonicalText();
    }

    public Project getProject() {
        return this.myFile.getProject();
    }

    public GlobalSearchScope getResolveScope() {
        return this.myPlace.getResolveScope();
    }

    @Nullable
    public String getTypeText() {
        this.affectingFactors.add(Factor.qualifierType);
        return this.myTypeText;
    }

    public boolean isInheritor(String qname) {
        return InheritanceUtil.isInheritor((PsiType)this.getPsiType(), (String)qname);
    }

    public PsiElement getPlace() {
        this.affectingFactors.add(Factor.placeElement);
        return this.myPlace;
    }

    @NotNull
    public PsiType getPsiType() {
        this.affectingFactors.add(Factor.qualifierType);
        PsiType psiType = this.myPsiType;
        if (psiType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/dsl/GroovyClassDescriptor", "getPsiType"));
        }
        return psiType;
    }

    public PsiFile getPlaceFile() {
        this.affectingFactors.add(Factor.placeFile);
        return this.myFile;
    }

    public PsiFile justGetPlaceFile() {
        return this.myFile;
    }

    static {
        try {
            AtomicInteger integer = GroovyCategorySupport.getCategoryNameUsage((String)"aaa");
        }
        catch (NoSuchMethodError e) {
            throw new RuntimeException("Incompatible Groovy JAR in classpath: " + GroovyCategorySupport.class.getResource("/") + ", please remove it");
        }
    }
}

