/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.log;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.text.SyncDateFormat;
import java.io.File;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.netbeans.lib.cvsclient.JavaCvsSrcBundle;
import org.netbeans.lib.cvsclient.command.AbstractMessageParser;
import org.netbeans.lib.cvsclient.command.KeywordSubstitution;
import org.netbeans.lib.cvsclient.command.log.LogInformation;
import org.netbeans.lib.cvsclient.command.log.Revision;
import org.netbeans.lib.cvsclient.event.IEventSender;
import org.netbeans.lib.cvsclient.file.ICvsFileSystem;
import org.netbeans.lib.cvsclient.util.BugLog;

public final class LogMessageParser
extends AbstractMessageParser {
    @NonNls
    private static final String RCS_FILE = "RCS file: ";
    @NonNls
    private static final String WORKING_FILE = "Working file: ";
    @NonNls
    private static final String HEAD = "head: ";
    @NonNls
    private static final String BRANCH = "branch:";
    @NonNls
    private static final String LOCKS = "locks: ";
    @NonNls
    private static final String ACCESS_LIST = "access list:";
    @NonNls
    private static final String SYMBOLIC_NAMES = "symbolic names:";
    @NonNls
    private static final String KEYWORD_SUBST = "keyword substitution: ";
    @NonNls
    private static final String TOTAL_REVISIONS = "total revisions: ";
    @NonNls
    private static final String SELECTED_REVISIONS = ";\tselected revisions: ";
    @NonNls
    private static final String DESCRIPTION = "description:";
    @NonNls
    private static final String REVISION = "revision ";
    @NonNls
    private static final String DATE = "date: ";
    @NonNls
    private static final String BRANCHES = "branches: ";
    @NonNls
    private static final String AUTHOR = "  author: ";
    @NonNls
    private static final String STATE = "  state: ";
    @NonNls
    private static final String LINES = "  lines: ";
    @NonNls
    private static final String SPLITTER = "----------------------------";
    @NonNls
    private static final String FINAL_SPLIT = "=============";
    @NonNls
    private static final String FINAL_SPLIT_WITH_TAB = "\t=============";
    private static final SyncDateFormat[] EXPECTED_DATE_FORMATS = new SyncDateFormat[2];
    @NonNls
    private static final String NO_FILE_MESSAGE = "no file";
    private final IEventSender eventSender;
    private final ICvsFileSystem cvsFileSystem;
    private LogInformation logInfo;
    private Revision revision;
    private boolean addingSymNames;
    private boolean addingDescription;
    private boolean processingRevision;
    private List<String> logMessageBuffer;
    private final Pattern myRevisionPattern;

    private static void initDateFormats() {
        LogMessageParser.EXPECTED_DATE_FORMATS[0] = new SyncDateFormat((DateFormat)new SimpleDateFormat("yyyy/MM/dd HH:mm:ss", Locale.US));
        EXPECTED_DATE_FORMATS[0].setTimeZone(TimeZone.getTimeZone("GMT"));
        LogMessageParser.EXPECTED_DATE_FORMATS[1] = new SyncDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.US));
        EXPECTED_DATE_FORMATS[1].setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public LogMessageParser(IEventSender eventSender, ICvsFileSystem cvsFileSystem) {
        BugLog.getInstance().assertNotNull(eventSender);
        BugLog.getInstance().assertNotNull(cvsFileSystem);
        this.cvsFileSystem = cvsFileSystem;
        this.eventSender = eventSender;
        this.myRevisionPattern = Pattern.compile("revision \\d+(\\.\\d+){1,3}.*");
    }

    @Override
    protected void outputDone() {
        if (this.addingDescription) {
            this.addingDescription = false;
        }
        if (this.processingRevision) {
            this.revision.setMessage(this.getMessageFromBuffer());
            this.logInfo.addRevision(this.revision);
            this.revision = null;
            this.processingRevision = false;
        }
        if (this.logInfo != null) {
            this.eventSender.notifyFileInfoListeners(this.logInfo);
            this.logInfo = null;
        }
        this.logMessageBuffer = null;
    }

    private String getMessageFromBuffer() {
        if (this.logMessageBuffer.size() > 0 && LogMessageParser.lastLogMessageIsFinalSeparator(this.logMessageBuffer.get(this.logMessageBuffer.size() - 1))) {
            this.logMessageBuffer.remove(this.logMessageBuffer.size() - 1);
        } else if (this.logMessageBuffer.size() > 1 && LogMessageParser.lastLogMessageIsFinalSeparator(this.logMessageBuffer.get(this.logMessageBuffer.size() - 2)) && this.logMessageBuffer.get(this.logMessageBuffer.size() - 1).length() == 0) {
            this.logMessageBuffer.remove(this.logMessageBuffer.size() - 2);
            this.logMessageBuffer.remove(this.logMessageBuffer.size() - 1);
        }
        if (this.logMessageBuffer.size() > 0) {
            return StringUtil.join(this.logMessageBuffer, (String)"\n") + "\n";
        }
        return "";
    }

    private static boolean lastLogMessageIsFinalSeparator(String logMessageString) {
        return logMessageString.startsWith(FINAL_SPLIT) || logMessageString.startsWith(FINAL_SPLIT_WITH_TAB);
    }

    @Override
    public void parseLine(String line, boolean isErrorMessage) {
        if (isErrorMessage) {
            return;
        }
        if (this.processingRevision) {
            if (line.startsWith(RCS_FILE)) {
                this.processRcsFile(line.substring(RCS_FILE.length()));
                return;
            }
            if (this.myRevisionPattern.matcher(line).matches()) {
                this.processRevisionStart(line);
                return;
            }
            if (line.startsWith(DATE)) {
                this.processRevisionDate(line);
                return;
            }
            if (line.startsWith(BRANCHES)) {
                this.processBranches(line.substring(BRANCHES.length()));
            } else {
                this.logMessageBuffer.add(line);
            }
            return;
        }
        if (this.addingSymNames && line.startsWith("\t")) {
            this.processSymbolicNames(line.substring(1));
            return;
        }
        if (line.startsWith(REVISION)) {
            this.processRevisionStart(line);
            return;
        }
        if (line.startsWith(KEYWORD_SUBST)) {
            String keywordSubstitution = line.substring(KEYWORD_SUBST.length()).trim();
            this.logInfo.setKeywordSubstitution(KeywordSubstitution.getValue(keywordSubstitution));
            this.addingSymNames = false;
            return;
        }
        if (line.startsWith(RCS_FILE)) {
            this.processRcsFile(line.substring(RCS_FILE.length()));
            return;
        }
        if (line.startsWith(WORKING_FILE)) {
            this.processWorkingFile(line.substring(WORKING_FILE.length()));
            return;
        }
        if (line.startsWith(HEAD)) {
            this.logInfo.setHeadRevision(line.substring(HEAD.length()).trim());
            return;
        }
        if (line.startsWith(BRANCH)) {
            this.logInfo.setBranch(line.substring(BRANCH.length()).trim());
            return;
        }
        if (line.startsWith(LOCKS)) {
            this.logInfo.setLocks(line.substring(LOCKS.length()).trim());
            return;
        }
        if (line.startsWith(ACCESS_LIST)) {
            this.logInfo.setAccessList(line.substring(ACCESS_LIST.length()).trim());
            return;
        }
        if (line.startsWith(SYMBOLIC_NAMES)) {
            this.addingSymNames = true;
            return;
        }
        if (line.startsWith(TOTAL_REVISIONS)) {
            String separator = SELECTED_REVISIONS;
            int semicolonIndex = line.indexOf(SELECTED_REVISIONS);
            if (semicolonIndex < 0) {
                this.logInfo.setTotalRevisions(line.substring(TOTAL_REVISIONS.length()).trim());
                this.logInfo.setSelectedRevisions("0");
            } else {
                String totalRevisions = line.substring(0, semicolonIndex);
                String selectedRevisions = line.substring(semicolonIndex);
                this.logInfo.setTotalRevisions(totalRevisions.substring(TOTAL_REVISIONS.length()).trim());
                this.logInfo.setSelectedRevisions(selectedRevisions.substring(SELECTED_REVISIONS.length()).trim());
            }
            return;
        }
        if (this.addingDescription) {
            if (!this.processingRevision && line.startsWith(SPLITTER)) {
                return;
            }
            this.logMessageBuffer.add(line);
            return;
        }
        if (line.startsWith(DESCRIPTION)) {
            this.logMessageBuffer = new ArrayList<String>();
            this.logMessageBuffer.add(line.substring(DESCRIPTION.length()));
            this.addingDescription = true;
        }
    }

    private void processRcsFile(String line) {
        if (this.logInfo != null) {
            this.outputDone();
        }
        this.logInfo = new LogInformation();
        this.logInfo.setRcsFileName(line.trim());
    }

    private void processWorkingFile(String line) {
        String fileName = line.trim();
        if (fileName.startsWith(NO_FILE_MESSAGE)) {
            fileName = fileName.substring(8);
        }
        this.logInfo.setFile(this.createFile(fileName));
    }

    private void processBranches(String line) {
        int ind = line.lastIndexOf(59);
        if (ind > 0) {
            line = line.substring(0, ind);
        }
        this.revision.setBranches(line.trim());
    }

    private void processSymbolicNames(String line) {
        int index = line.lastIndexOf(58);
        if (index < 0) {
            return;
        }
        String symName = line.substring(0, index).trim();
        String revName = line.substring(index + 1, line.length()).trim();
        this.logInfo.addSymbolicName(symName, revName);
    }

    private void processRevisionStart(String line) {
        this.revisionProcessingFinished();
        int tabIndex = line.indexOf(9, REVISION.length());
        if (tabIndex < 0) {
            tabIndex = line.length();
        }
        String revisionNumber = line.substring(REVISION.length(), tabIndex);
        this.revision = new Revision(revisionNumber);
        this.processingRevision = true;
    }

    private void revisionProcessingFinished() {
        if (this.revision != null) {
            if (this.logMessageBuffer.size() > 0 && this.logMessageBuffer.get(this.logMessageBuffer.size() - 1).startsWith(SPLITTER)) {
                this.logMessageBuffer.remove(this.logMessageBuffer.size() - 1);
            }
            this.processingRevision = false;
            this.revision.setMessage(this.getMessageFromBuffer());
            this.logInfo.addRevision(this.revision);
        }
    }

    private void processRevisionDate(String line) {
        String linesModified;
        String state;
        String author;
        StringTokenizer token = new StringTokenizer(line, ";", false);
        if (token.hasMoreTokens()) {
            String date = token.nextToken();
            String dateString = date.substring(DATE.length());
            Date parsedDate = null;
            for (SyncDateFormat expectedDateFormat : EXPECTED_DATE_FORMATS) {
                try {
                    parsedDate = expectedDateFormat.parse(dateString);
                }
                catch (ParseException e) {
                    // empty catch block
                }
                if (parsedDate != null) break;
            }
            if (parsedDate != null) {
                this.revision.setDate(parsedDate);
            } else {
                BugLog.getInstance().showException(new Exception(JavaCvsSrcBundle.message("line.could.not.be.parsed.error.message", line)));
            }
        }
        if (token.hasMoreTokens() && (author = token.nextToken()).startsWith(AUTHOR)) {
            this.revision.setAuthor(author.substring(AUTHOR.length()));
        }
        if (token.hasMoreTokens() && (state = token.nextToken()).startsWith(STATE)) {
            this.revision.setState(state.substring(STATE.length()));
        }
        if (token.hasMoreTokens() && (linesModified = token.nextToken()).startsWith(LINES)) {
            this.revision.setLines(linesModified.substring(LINES.length()));
        }
        this.processingRevision = true;
        this.logMessageBuffer = new ArrayList<String>();
    }

    private File createFile(String fileName) {
        return this.cvsFileSystem.getLocalFileSystem().getFile(fileName);
    }

    @Override
    public void binaryMessageSent(byte[] bytes) {
    }

    static {
        LogMessageParser.initDateFormats();
    }
}

