/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.scope.packageSet;

import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.scope.packageSet.AbstractPackageSet;
import com.intellij.psi.search.scope.packageSet.CustomScopesProvider;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CustomScopesProviderEx
implements CustomScopesProvider {
    @Nullable
    public NamedScope getCustomScope(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/search/scope/packageSet/CustomScopesProviderEx", "getCustomScope"));
        }
        List<NamedScope> predefinedScopes = this.getCustomScopes();
        return CustomScopesProviderEx.findPredefinedScope(name, predefinedScopes);
    }

    @Nullable
    public static NamedScope findPredefinedScope(@NotNull String name, @NotNull List<NamedScope> predefinedScopes) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/search/scope/packageSet/CustomScopesProviderEx", "findPredefinedScope"));
        }
        if (predefinedScopes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "predefinedScopes", "com/intellij/psi/search/scope/packageSet/CustomScopesProviderEx", "findPredefinedScope"));
        }
        for (NamedScope scope : predefinedScopes) {
            if (!name.equals(scope.getName())) continue;
            return scope;
        }
        return null;
    }

    public boolean isVetoed(NamedScope scope, ScopePlace place) {
        return false;
    }

    public static void filterNoSettingsScopes(Project project, List<NamedScope> scopes) {
        Iterator<NamedScope> iterator = scopes.iterator();
        block0: while (iterator.hasNext()) {
            NamedScope scope = iterator.next();
            for (CustomScopesProvider provider : (CustomScopesProvider[])Extensions.getExtensions((ExtensionPointName)CUSTOM_SCOPES_PROVIDER, (AreaInstance)project)) {
                if (!(provider instanceof CustomScopesProviderEx) || !((CustomScopesProviderEx)provider).isVetoed(scope, ScopePlace.SETTING)) continue;
                iterator.remove();
                continue block0;
            }
        }
    }

    @NotNull
    public static NamedScope getAllScope() {
        NamedScope namedScope = AllScopeHolder.ALL;
        if (namedScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/scope/packageSet/CustomScopesProviderEx", "getAllScope"));
        }
        return namedScope;
    }

    private static class AllScopeHolder {
        @NotNull
        private static final String TEXT = "file:*//*";
        @NotNull
        private static final NamedScope ALL = new NamedScope("All", new AbstractPackageSet("file:*//*", 0){

            @Override
            public boolean contains(VirtualFile file, NamedScopesHolder scopesHolder) {
                return true;
            }
        });

        private AllScopeHolder() {
        }
    }

    public static enum ScopePlace {
        SETTING,
        ACTION;

    }
}

