/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.agent.util.log;

import com.intellij.remoteServer.agent.util.log.LogPipe;
import com.intellij.remoteServer.agent.util.log.LogPipeProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LogAgentManager {
    private Map<String, List<LogPipe>> myDeploymentName2ActiveLogPipes = new HashMap<String, List<LogPipe>>();

    public void startListeningLog(String deploymentName, LogPipeProvider provider) {
        this.stopListeningLog(deploymentName);
        this.doStartListeningLog(deploymentName, provider);
    }

    public void startOrContinueListeningLog(String deploymentName, LogPipeProvider provider) {
        if (!this.myDeploymentName2ActiveLogPipes.containsKey(deploymentName)) {
            this.doStartListeningLog(deploymentName, provider);
        }
    }

    private void doStartListeningLog(String deploymentName, LogPipeProvider provider) {
        ArrayList<? extends LogPipe> pipes = new ArrayList<LogPipe>(provider.createLogPipes(deploymentName));
        this.myDeploymentName2ActiveLogPipes.put(deploymentName, pipes);
        for (LogPipe logPipe : pipes) {
            logPipe.open();
        }
    }

    public void stopListeningAllLogs() {
        for (String deploymentName : new ArrayList<String>(this.myDeploymentName2ActiveLogPipes.keySet())) {
            this.stopListeningLog(deploymentName);
        }
    }

    public void stopListeningLog(String deploymentName) {
        List<LogPipe> pipes = this.myDeploymentName2ActiveLogPipes.remove(deploymentName);
        if (pipes != null) {
            for (LogPipe pipe : pipes) {
                pipe.close();
            }
        }
    }
}

