/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components.labels;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.UI;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.util.ui.JBRectangle;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LinkLabel<T>
extends JLabel {
    protected boolean myUnderline;
    private LinkListener<T> myLinkListener;
    private T myLinkData;
    private static final Set<String> ourVisitedLinks = new HashSet<String>();
    private boolean myIsLinkActive;
    private String myVisitedLinksKey;
    private Icon myHoveringIcon;
    private Icon myInactiveIcon;
    private boolean myClickIsBeingProcessed;
    protected boolean myPaintUnderline = true;
    private final JBRectangle iconR = new JBRectangle();
    private final JBRectangle textR = new JBRectangle();
    private final JBRectangle viewR = new JBRectangle();

    public LinkLabel() {
        this("", AllIcons.Ide.Link);
    }

    public LinkLabel(String text, @Nullable Icon icon) {
        this(text, icon, null, null, null);
    }

    public LinkLabel(String text, @Nullable Icon icon, @Nullable LinkListener<T> aListener) {
        this(text, icon, aListener, null, null);
    }

    public LinkLabel(String text, @Nullable Icon icon, @Nullable LinkListener<T> aListener, @Nullable T aLinkData) {
        this(text, icon, aListener, aLinkData, null);
    }

    public LinkLabel(String text, @Nullable Icon icon, @Nullable LinkListener<T> aListener, @Nullable T aLinkData, @Nullable String aVisitedLinksKey) {
        super(text, icon, 2);
        this.setOpaque(false);
        this.setListener(aListener, aLinkData);
        this.myInactiveIcon = this.getIcon();
        MyMouseHandler mouseHandler = new MyMouseHandler();
        this.addMouseListener(mouseHandler);
        this.addMouseMotionListener(mouseHandler);
        this.myVisitedLinksKey = aVisitedLinksKey;
    }

    public void setHoveringIcon(Icon iconForHovering) {
        this.myHoveringIcon = iconForHovering;
    }

    public void setListener(LinkListener<T> listener, @Nullable T linkData) {
        this.myLinkListener = listener;
        this.myLinkData = linkData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doClick() {
        if (this.myClickIsBeingProcessed) {
            return;
        }
        try {
            this.myClickIsBeingProcessed = true;
            if (this.myLinkListener != null) {
                this.myLinkListener.linkSelected(this, this.myLinkData);
            }
            ourVisitedLinks.add(this.myVisitedLinksKey);
            this.repaint();
        }
        finally {
            this.myClickIsBeingProcessed = false;
        }
    }

    public boolean isVisited() {
        return this.myVisitedLinksKey != null && ourVisitedLinks.contains(this.myVisitedLinksKey);
    }

    @Override
    protected void paintComponent(Graphics g) {
        this.setForeground(this.getTextColor());
        super.paintComponent(g);
        if (this.getText() != null) {
            g.setColor(this.getTextColor());
            if (this.myUnderline && this.myPaintUnderline) {
                Rectangle bounds = this.getTextBounds();
                int lineY = this.getUI().getBaseline(this, this.getWidth(), this.getHeight()) + 1;
                g.drawLine(bounds.x, lineY, bounds.x + bounds.width, lineY);
            }
        }
    }

    @NotNull
    protected Rectangle getTextBounds() {
        Dimension size = this.getPreferredSize();
        Icon icon = this.getIcon();
        Point point = new Point(0, 0);
        Insets insets = this.getInsets();
        if (icon != null) {
            point.x += this.getIconTextGap();
            point.x += icon.getIconWidth();
            point.x += insets.left;
            point.y += insets.top;
        }
        size.width -= point.x;
        size.width -= insets.right;
        size.height -= insets.bottom;
        Rectangle rectangle = new Rectangle(point, size);
        if (rectangle == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/components/labels/LinkLabel", "getTextBounds"));
        }
        return rectangle;
    }

    protected Color getTextColor() {
        return this.myIsLinkActive ? this.getActive() : (this.isVisited() ? this.getVisited() : this.getNormal());
    }

    public void setPaintUnderline(boolean paintUnderline) {
        this.myPaintUnderline = paintUnderline;
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (ScreenUtil.isStandardAddRemoveNotify(this)) {
            this.disableUnderline();
        }
    }

    private void setActive(boolean isActive) {
        this.myIsLinkActive = isActive;
        this.onSetActive(this.myIsLinkActive);
        this.repaint();
    }

    protected void onSetActive(boolean active) {
    }

    private boolean isInClickableArea(Point pt) {
        this.iconR.clear();
        this.textR.clear();
        Insets insets = this.getInsets(null);
        this.viewR.x = insets.left;
        this.viewR.y = insets.top;
        this.viewR.width = this.getWidth() - (insets.left + insets.right);
        this.viewR.height = this.getHeight() - (insets.top + insets.bottom);
        SwingUtilities.layoutCompoundLabel(this, this.getFontMetrics(this.getFont()), this.getText(), this.isEnabled() ? this.getIcon() : this.getDisabledIcon(), this.getVerticalAlignment(), this.getHorizontalAlignment(), this.getVerticalTextPosition(), this.getHorizontalTextPosition(), (Rectangle)this.viewR, (Rectangle)this.iconR, (Rectangle)this.textR, this.getIconTextGap());
        if (this.getIcon() != null) {
            this.iconR.width += this.getIconTextGap();
            if (this.iconR.contains(pt)) {
                return true;
            }
        }
        return this.textR.contains(pt);
    }

    private void enableUnderline() {
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.myUnderline = true;
        if (this.myHoveringIcon != null) {
            this.setIcon(this.myHoveringIcon);
        }
        LinkLabel.setStatusBarText(this.getStatusBarText());
        this.repaint();
    }

    protected String getStatusBarText() {
        return this.getToolTipText();
    }

    private void disableUnderline() {
        this.setCursor(Cursor.getDefaultCursor());
        this.myUnderline = false;
        this.setIcon(this.myInactiveIcon);
        LinkLabel.setStatusBarText(null);
        this.setActive(false);
    }

    private static void setStatusBarText(String statusBarText) {
        Project[] projects;
        if (ApplicationManager.getApplication() == null) {
            return;
        }
        for (Project project : projects = ProjectManager.getInstance().getOpenProjects()) {
            StatusBar.Info.set(statusBarText, project);
        }
    }

    public static void clearVisitedHistory() {
        ourVisitedLinks.clear();
    }

    protected Color getVisited() {
        return UI.getColor("link.visited.foreground");
    }

    protected Color getActive() {
        return UI.getColor("link.pressed.foreground");
    }

    protected Color getNormal() {
        return UI.getColor("link.foreground");
    }

    public void entered(MouseEvent e) {
        this.enableUnderline();
    }

    public void exited(MouseEvent e) {
        this.disableUnderline();
    }

    public void pressed(MouseEvent e) {
        this.doClick(e);
    }

    public void doClick(InputEvent e) {
        this.doClick();
    }

    private class MyMouseHandler
    extends MouseAdapter
    implements MouseMotionListener {
        private MyMouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (LinkLabel.this.isInClickableArea(e.getPoint())) {
                LinkLabel.this.setActive(true);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (LinkLabel.this.myIsLinkActive && LinkLabel.this.isInClickableArea(e.getPoint())) {
                LinkLabel.this.doClick(e);
            }
            LinkLabel.this.setActive(false);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (LinkLabel.this.isInClickableArea(e.getPoint())) {
                LinkLabel.this.enableUnderline();
            } else {
                LinkLabel.this.disableUnderline();
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            LinkLabel.this.disableUnderline();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }
    }
}

