/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.sdklib.repository.FullRevision;
import com.android.tools.idea.gradle.messages.Message;
import com.android.tools.idea.gradle.messages.ProjectSyncMessages;
import com.android.tools.idea.gradle.project.ChooseGradleHomeDialog;
import com.android.tools.idea.gradle.service.notification.hyperlink.FixGradleVersionInWrapperHyperlink;
import com.android.tools.idea.gradle.service.notification.hyperlink.NotificationHyperlink;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;

final class PreSyncChecks {
    private static final Logger LOG = Logger.getInstance(PreSyncChecks.class);
    private static final String GRADLE_SYNC_MSG_TITLE = "Gradle Sync";
    private static final String PROJECT_SYNCING_ERROR_GROUP = "Project syncing error";

    private PreSyncChecks() {
    }

    @NotNull
    static PreSyncCheckResult canSync(@NotNull Project project) {
        boolean usingWrapper;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/PreSyncChecks", "canSync"));
        }
        VirtualFile baseDir = project.getBaseDir();
        if (baseDir == null) {
            PreSyncCheckResult preSyncCheckResult = PreSyncCheckResult.success();
            if (preSyncCheckResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/PreSyncChecks", "canSync"));
            }
            return preSyncCheckResult;
        }
        ProjectSyncMessages syncMessages = ProjectSyncMessages.getInstance(project);
        syncMessages.removeMessages(PROJECT_SYNCING_ERROR_GROUP);
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            GradleUtil.attemptToUseEmbeddedGradle(project);
        }
        GradleProjectSettings gradleSettings = GradleUtil.getGradleProjectSettings(project);
        File wrapperPropertiesFile = GradleUtil.findWrapperPropertiesFile(project);
        DistributionType distributionType = gradleSettings != null ? gradleSettings.getDistributionType() : null;
        boolean bl = usingWrapper = (distributionType == null || distributionType == DistributionType.DEFAULT_WRAPPED) && wrapperPropertiesFile != null;
        if (usingWrapper && gradleSettings != null) {
            gradleSettings.setDistributionType(DistributionType.DEFAULT_WRAPPED);
        } else if (wrapperPropertiesFile == null && gradleSettings != null) {
            PreSyncChecks.createWrapperIfNecessary(project, gradleSettings, distributionType);
        }
        PreSyncCheckResult preSyncCheckResult = PreSyncCheckResult.success();
        if (preSyncCheckResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/PreSyncChecks", "canSync"));
        }
        return preSyncCheckResult;
    }

    @NotNull
    private static PreSyncCheckResult ensureCorrectGradleSettings(@NotNull Project project, @Nullable FullRevision modelVersion) {
        boolean usingWrapper;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/PreSyncChecks", "ensureCorrectGradleSettings"));
        }
        if (modelVersion == null || PreSyncChecks.createWrapperIfNecessary(project)) {
            PreSyncCheckResult preSyncCheckResult = PreSyncCheckResult.success();
            if (preSyncCheckResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/PreSyncChecks", "ensureCorrectGradleSettings"));
            }
            return preSyncCheckResult;
        }
        GradleProjectSettings gradleSettings = GradleUtil.getGradleProjectSettings(project);
        File wrapperPropertiesFile = GradleUtil.findWrapperPropertiesFile(project);
        DistributionType distributionType = gradleSettings != null ? gradleSettings.getDistributionType() : null;
        boolean bl = usingWrapper = (distributionType == null || distributionType == DistributionType.DEFAULT_WRAPPED) && wrapperPropertiesFile != null;
        if (usingWrapper) {
            PreSyncCheckResult result = PreSyncChecks.attemptToUpdateGradleVersionInWrapper(wrapperPropertiesFile, modelVersion, project);
            if (!result.isSuccess()) {
                PreSyncCheckResult preSyncCheckResult = result;
                if (preSyncCheckResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/PreSyncChecks", "ensureCorrectGradleSettings"));
                }
                return preSyncCheckResult;
            }
            if (gradleSettings != null) {
                gradleSettings.setDistributionType(DistributionType.DEFAULT_WRAPPED);
            }
        } else if (distributionType == DistributionType.LOCAL) {
            PreSyncChecks.attemptToUseSupportedLocalGradle(modelVersion, gradleSettings, project);
        }
        PreSyncCheckResult preSyncCheckResult = PreSyncCheckResult.success();
        if (preSyncCheckResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/PreSyncChecks", "ensureCorrectGradleSettings"));
        }
        return preSyncCheckResult;
    }

    private static boolean createWrapperIfNecessary(@NotNull Project project) {
        DistributionType distributionType;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/PreSyncChecks", "createWrapperIfNecessary"));
        }
        GradleProjectSettings gradleSettings = GradleUtil.getGradleProjectSettings(project);
        if (gradleSettings == null) {
            return true;
        }
        File wrapperPropertiesFile = GradleUtil.findWrapperPropertiesFile(project);
        return wrapperPropertiesFile == null && PreSyncChecks.createWrapperIfNecessary(project, gradleSettings, distributionType = gradleSettings.getDistributionType());
    }

    private static boolean createWrapperIfNecessary(@NotNull Project project, @NotNull GradleProjectSettings gradleSettings, @Nullable DistributionType distributionType) {
        ChooseGradleHomeDialog dialog;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/PreSyncChecks", "createWrapperIfNecessary"));
        }
        if (gradleSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleSettings", "com/android/tools/idea/gradle/project/PreSyncChecks", "createWrapperIfNecessary"));
        }
        boolean createWrapper = false;
        if (distributionType == null) {
            String msg = "Gradle settings for this project are not configured yet.\n\nWould you like the project to use the Gradle wrapper?\n(The wrapper will automatically download the latest supported Gradle version).\n\nClick 'OK' to use the Gradle wrapper, or 'Cancel' to manually set the path of a local Gradle distribution.";
            int answer = Messages.showOkCancelDialog((Project)project, (String)msg, (String)GRADLE_SYNC_MSG_TITLE, (Icon)Messages.getQuestionIcon());
            createWrapper = answer == 0;
        } else if (distributionType == DistributionType.DEFAULT_WRAPPED) {
            createWrapper = true;
        }
        if (createWrapper) {
            File projectDirPath = new File(project.getBasePath());
            File gradleDirPath = new File(projectDirPath, "gradle");
            if (!FileUtil.delete((File)gradleDirPath)) {
                return true;
            }
            try {
                GradleUtil.createGradleWrapper(projectDirPath);
                if (distributionType == null) {
                    gradleSettings.setDistributionType(DistributionType.DEFAULT_WRAPPED);
                }
                return true;
            }
            catch (IOException e) {
                LOG.info("Failed to create Gradle wrapper for project '" + project.getName() + "'", (Throwable)e);
            }
        } else if (distributionType == null && (dialog = new ChooseGradleHomeDialog()).showAndGet()) {
            String enteredGradleHomePath = dialog.getEnteredGradleHomePath();
            gradleSettings.setGradleHome(enteredGradleHomePath);
            gradleSettings.setDistributionType(DistributionType.LOCAL);
            return true;
        }
        return false;
    }

    @NotNull
    private static PreSyncCheckResult attemptToUpdateGradleVersionInWrapper(@NotNull File wrapperPropertiesFile, @NotNull FullRevision modelVersion, @NotNull Project project) {
        if (wrapperPropertiesFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrapperPropertiesFile", "com/android/tools/idea/gradle/project/PreSyncChecks", "attemptToUpdateGradleVersionInWrapper"));
        }
        if (modelVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelVersion", "com/android/tools/idea/gradle/project/PreSyncChecks", "attemptToUpdateGradleVersionInWrapper"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/PreSyncChecks", "attemptToUpdateGradleVersionInWrapper"));
        }
        FullRevision minimumPluginVersion = FullRevision.parseRevision((String)"1.0.0");
        if (modelVersion.compareTo(minimumPluginVersion) < 0) {
            PreSyncCheckResult preSyncCheckResult = PreSyncCheckResult.success();
            if (preSyncCheckResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/PreSyncChecks", "attemptToUpdateGradleVersionInWrapper"));
            }
            return preSyncCheckResult;
        }
        String gradleVersion = null;
        try {
            gradleVersion = GradleUtil.getGradleWrapperVersion(wrapperPropertiesFile);
        }
        catch (IOException e) {
            LOG.warn("Failed to read file " + wrapperPropertiesFile.getPath());
        }
        if (gradleVersion == null) {
            PreSyncCheckResult preSyncCheckResult = PreSyncCheckResult.success();
            if (preSyncCheckResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/PreSyncChecks", "attemptToUpdateGradleVersionInWrapper"));
            }
            return preSyncCheckResult;
        }
        FullRevision gradleRevision = null;
        try {
            gradleRevision = FullRevision.parseRevision((String)gradleVersion);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        if (gradleRevision != null && !GradleUtil.isSupportedGradleVersion(gradleRevision)) {
            String cause = PreSyncChecks.getMinimumGradleVersionErrorPrefix(modelVersion);
            NotificationHyperlink hyperlink = FixGradleVersionInWrapperHyperlink.createIfProjectUsesGradleWrapper(project);
            ProjectSyncMessages syncMessages = ProjectSyncMessages.getInstance(project);
            syncMessages.add(new Message(PROJECT_SYNCING_ERROR_GROUP, Message.Type.ERROR, cause), hyperlink);
            PreSyncCheckResult preSyncCheckResult = PreSyncCheckResult.failure(cause);
            if (preSyncCheckResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/PreSyncChecks", "attemptToUpdateGradleVersionInWrapper"));
            }
            return preSyncCheckResult;
        }
        PreSyncCheckResult preSyncCheckResult = PreSyncCheckResult.success();
        if (preSyncCheckResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/PreSyncChecks", "attemptToUpdateGradleVersionInWrapper"));
        }
        return preSyncCheckResult;
    }

    private static void attemptToUseSupportedLocalGradle(@NotNull FullRevision modelVersion, @NotNull GradleProjectSettings gradleSettings, @NotNull Project project) {
        if (modelVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelVersion", "com/android/tools/idea/gradle/project/PreSyncChecks", "attemptToUseSupportedLocalGradle"));
        }
        if (gradleSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleSettings", "com/android/tools/idea/gradle/project/PreSyncChecks", "attemptToUseSupportedLocalGradle"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/PreSyncChecks", "attemptToUseSupportedLocalGradle"));
        }
        String gradleHome = gradleSettings.getGradleHome();
        FullRevision gradleVersion = null;
        boolean askToSwitchToWrapper = false;
        if (StringUtil.isEmpty((String)gradleHome)) {
            askToSwitchToWrapper = true;
        } else {
            File gradleHomePath = new File(gradleHome);
            gradleVersion = GradleUtil.getGradleVersion(gradleHomePath);
            if (gradleVersion == null) {
                askToSwitchToWrapper = true;
            }
        }
        if (!askToSwitchToWrapper) {
            boolean bl = askToSwitchToWrapper = !GradleUtil.isSupportedGradleVersion(gradleVersion);
        }
        if (askToSwitchToWrapper) {
            String msg = PreSyncChecks.getMinimumGradleVersionErrorPrefix(modelVersion) + "A local Gradle distribution was not found, or was not properly set in the IDE.\n\n" + "Would you like your project to use the Gradle wrapper instead?\n" + "(The wrapper will automatically download the latest supported Gradle version).\n\n" + "Click 'OK' to use the Gradle wrapper, or 'Cancel' to manually set the path of a local Gradle distribution.";
            int answer = Messages.showOkCancelDialog((Project)project, (String)msg, (String)GRADLE_SYNC_MSG_TITLE, (Icon)Messages.getQuestionIcon());
            if (answer == 0) {
                try {
                    File projectDirPath = new File(project.getBasePath());
                    GradleUtil.createGradleWrapper(projectDirPath);
                    gradleSettings.setDistributionType(DistributionType.DEFAULT_WRAPPED);
                }
                catch (IOException e) {
                    LOG.warn("Failed to update Gradle wrapper file to Gradle version 2.2.1", (Throwable)e);
                }
                return;
            }
            ChooseGradleHomeDialog dialog = new ChooseGradleHomeDialog();
            dialog.setTitle(String.format("Please select the location of a Gradle distribution version %1$s or newer", "2.2.1"));
            if (dialog.showAndGet()) {
                String enteredGradleHomePath = dialog.getEnteredGradleHomePath();
                gradleSettings.setGradleHome(enteredGradleHomePath);
            }
        }
    }

    @NotNull
    private static String getMinimumGradleVersionErrorPrefix(@NotNull FullRevision modelVersion) {
        if (modelVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelVersion", "com/android/tools/idea/gradle/project/PreSyncChecks", "getMinimumGradleVersionErrorPrefix"));
        }
        String string = "Version " + modelVersion + " of the Android Gradle plug-in requires Gradle " + "2.2.1" + " or newer.\n";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/PreSyncChecks", "getMinimumGradleVersionErrorPrefix"));
        }
        return string;
    }

    static class PreSyncCheckResult {
        private final boolean mySuccess;
        @Nullable
        private final String myFailureCause;

        @NotNull
        private static PreSyncCheckResult success() {
            PreSyncCheckResult preSyncCheckResult = new PreSyncCheckResult(true, null);
            if (preSyncCheckResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/PreSyncChecks$PreSyncCheckResult", "success"));
            }
            return preSyncCheckResult;
        }

        @NotNull
        private static PreSyncCheckResult failure(@NotNull String cause) {
            if (cause == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cause", "com/android/tools/idea/gradle/project/PreSyncChecks$PreSyncCheckResult", "failure"));
            }
            PreSyncCheckResult preSyncCheckResult = new PreSyncCheckResult(false, cause);
            if (preSyncCheckResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/PreSyncChecks$PreSyncCheckResult", "failure"));
            }
            return preSyncCheckResult;
        }

        private PreSyncCheckResult(boolean success, @Nullable String failureCause) {
            this.mySuccess = success;
            this.myFailureCause = failureCause;
        }

        public boolean isSuccess() {
            return this.mySuccess;
        }

        @Nullable
        public String getFailureCause() {
            return this.myFailureCause;
        }
    }
}

