/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.builder.model.AndroidLibrary;
import com.android.ide.common.resources.IntArrayWrapper;
import com.android.resources.ResourceType;
import com.android.tools.idea.gradle.IdeaAndroidProject;
import com.android.tools.idea.gradle.project.GradleSyncListener;
import com.android.tools.idea.gradle.util.ProjectBuilder;
import com.android.tools.idea.rendering.FileResourceRepository;
import com.android.tools.idea.rendering.LocalResourceRepository;
import com.android.tools.idea.rendering.MultiResourceRepository;
import com.android.tools.idea.rendering.ProjectResourceRepository;
import com.android.util.Pair;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TObjectIntHashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppResourceRepository
extends MultiResourceRepository {
    private final AndroidFacet myFacet;
    private List<LocalResourceRepository> myLibraries;
    private static final int DYNAMIC_ID_SEED_START = 0x7FFF0000;
    private Map<ResourceType, TObjectIntHashMap<String>> myResourceValueMap;
    private TIntObjectHashMap<Pair<ResourceType, String>> myResIdValueToNameMap;
    private Map<IntArrayWrapper, String> myStyleableValueToNameMap;
    private final TObjectIntHashMap<String> myName2DynamicIdMap;
    private final TIntObjectHashMap<Pair<ResourceType, String>> myDynamicId2ResourceMap;
    private int myDynamicSeed;
    private final IntArrayWrapper myWrapper;

    protected AppResourceRepository(@NotNull AndroidFacet facet, @NotNull List<? extends LocalResourceRepository> delegates, @NotNull List<LocalResourceRepository> libraries) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/rendering/AppResourceRepository", "<init>"));
        }
        if (delegates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegates", "com/android/tools/idea/rendering/AppResourceRepository", "<init>"));
        }
        if (libraries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraries", "com/android/tools/idea/rendering/AppResourceRepository", "<init>"));
        }
        super(facet.getModule().getName() + " with modules and libraries", delegates);
        this.myName2DynamicIdMap = new TObjectIntHashMap();
        this.myDynamicId2ResourceMap = new TIntObjectHashMap();
        this.myDynamicSeed = 0x7FFF0000;
        this.myWrapper = new IntArrayWrapper(null);
        this.myFacet = facet;
        this.myLibraries = libraries;
    }

    @Nullable
    public static AppResourceRepository getAppResources(@NotNull Module module, boolean createIfNecessary) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/rendering/AppResourceRepository", "getAppResources"));
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet != null) {
            return facet.getAppResources(createIfNecessary);
        }
        return null;
    }

    @Contract(value="!null, true -> !null")
    @Nullable
    public static AppResourceRepository getAppResources(@NotNull AndroidFacet facet, boolean createIfNecessary) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/rendering/AppResourceRepository", "getAppResources"));
        }
        return facet.getAppResources(createIfNecessary);
    }

    @NotNull
    public static AppResourceRepository create(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/rendering/AppResourceRepository", "create"));
        }
        List<LocalResourceRepository> libraries = AppResourceRepository.computeLibraries(facet);
        List<LocalResourceRepository> delegates = AppResourceRepository.computeRepositories(facet, libraries);
        final AppResourceRepository repository = new AppResourceRepository(facet, delegates, libraries);
        facet.addListener(new GradleSyncListener.Adapter(){

            @Override
            public void syncSucceeded(@NotNull Project project) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/rendering/AppResourceRepository$1", "syncSucceeded"));
                }
                repository.updateRoots();
            }
        });
        ProjectBuilder.getInstance(facet.getModule().getProject()).addAfterProjectBuildTask(new ProjectBuilder.AfterProjectBuildListener(){

            @Override
            protected void buildFinished() {
                repository.updateRoots();
            }
        });
        AppResourceRepository appResourceRepository = repository;
        if (appResourceRepository == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/AppResourceRepository", "create"));
        }
        return appResourceRepository;
    }

    private static List<LocalResourceRepository> computeRepositories(@NotNull AndroidFacet facet, List<LocalResourceRepository> libraries) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/rendering/AppResourceRepository", "computeRepositories"));
        }
        ArrayList repositories = Lists.newArrayListWithExpectedSize((int)10);
        ProjectResourceRepository resources = ProjectResourceRepository.getProjectResources(facet, true);
        repositories.addAll(libraries);
        repositories.add(resources);
        return repositories;
    }

    private static List<LocalResourceRepository> computeLibraries(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/rendering/AppResourceRepository", "computeLibraries"));
        }
        List<AndroidFacet> dependentFacets = AndroidUtils.getAllAndroidDependencies(facet.getModule(), true);
        List<File> aarDirs = AppResourceRepository.findAarLibraries(facet, dependentFacets);
        if (aarDirs.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList resources = Lists.newArrayListWithExpectedSize((int)aarDirs.size());
        for (File root : aarDirs) {
            resources.add(FileResourceRepository.get(root));
        }
        return resources;
    }

    @NotNull
    private static List<File> findAarLibraries(AndroidFacet facet, List<AndroidFacet> dependentFacets) {
        if (facet.isGradleProject() && facet.getIdeaAndroidProject() != null) {
            ArrayList libraries = Lists.newArrayList();
            AppResourceRepository.addGradleLibraries(libraries, facet);
            for (AndroidFacet f : dependentFacets) {
                AppResourceRepository.addGradleLibraries(libraries, f);
            }
            List<File> list = AppResourceRepository.findAarLibrariesFromGradle(dependentFacets, libraries);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/AppResourceRepository", "findAarLibraries"));
            }
            return list;
        }
        List<File> list = AppResourceRepository.findAarLibrariesFromIntelliJ(facet, dependentFacets);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/AppResourceRepository", "findAarLibraries"));
        }
        return list;
    }

    @NotNull
    public static Collection<AndroidLibrary> findAarLibraries(@NotNull AndroidFacet facet) {
        IdeaAndroidProject project;
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/rendering/AppResourceRepository", "findAarLibraries"));
        }
        ArrayList libraries = Lists.newArrayList();
        if (facet.isGradleProject() && (project = facet.getIdeaAndroidProject()) != null) {
            List<AndroidFacet> dependentFacets = AndroidUtils.getAllAndroidDependencies(facet.getModule(), true);
            AppResourceRepository.addGradleLibraries(libraries, facet);
            for (AndroidFacet dependentFacet : dependentFacets) {
                AppResourceRepository.addGradleLibraries(libraries, dependentFacet);
            }
        }
        ArrayList arrayList = libraries;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/AppResourceRepository", "findAarLibraries"));
        }
        return arrayList;
    }

    private static List<File> findAarLibrariesFromIntelliJ(AndroidFacet facet, List<AndroidFacet> dependentFacets) {
        HashSet dirs = Sets.newHashSet();
        ResourceFolderManager.addAarsFromModuleLibraries(facet, dirs);
        for (AndroidFacet f : dependentFacets) {
            ResourceFolderManager.addAarsFromModuleLibraries(f, dirs);
        }
        ArrayList<File> sorted = new ArrayList<File>(dirs);
        Collections.sort(sorted);
        return sorted;
    }

    @NotNull
    private static List<File> findAarLibrariesFromGradle(List<AndroidFacet> dependentFacets, List<AndroidLibrary> libraries) {
        HashSet files = Sets.newHashSetWithExpectedSize((int)dependentFacets.size());
        HashSet moduleNames = Sets.newHashSet();
        for (AndroidFacet f : dependentFacets) {
            moduleNames.add(f.getModule().getName());
        }
        for (AndroidLibrary library : libraries) {
            File resFolder;
            String libraryName = null;
            String projectName = library.getProject();
            if (projectName != null && !projectName.isEmpty()) {
                libraryName = projectName.substring(projectName.lastIndexOf(58) + 1);
                moduleNames.add(libraryName);
                continue;
            }
            File folder = library.getFolder();
            String name = folder.getName();
            if (name.endsWith(".aar")) {
                libraryName = name.substring(0, name.length() - ".aar".length());
            } else if (folder.getPath().contains("exploded-aar")) {
                libraryName = folder.getParentFile().getName();
            }
            if (libraryName == null || moduleNames.contains(libraryName) || !(resFolder = library.getResFolder()).exists()) continue;
            files.add(resFolder);
            moduleNames.add(libraryName);
        }
        ArrayList dirs = Lists.newArrayList();
        for (File resFolder : files) {
            dirs.add(resFolder);
        }
        Collections.sort(dirs);
        ArrayList arrayList = dirs;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/AppResourceRepository", "findAarLibrariesFromGradle"));
        }
        return arrayList;
    }

    private static void addGradleLibraries(List<AndroidLibrary> list, AndroidFacet facet) {
        IdeaAndroidProject gradleProject = facet.getIdeaAndroidProject();
        if (gradleProject != null) {
            Collection libraries = gradleProject.getSelectedVariant().getMainArtifact().getDependencies().getLibraries();
            HashSet unique = Sets.newHashSet();
            for (AndroidLibrary library : libraries) {
                AppResourceRepository.addGradleLibrary(list, library, unique);
            }
        }
    }

    private static void addGradleLibrary(List<AndroidLibrary> list, AndroidLibrary library, Set<File> unique) {
        File folder = library.getFolder();
        if (!unique.add(folder)) {
            return;
        }
        list.add(library);
        for (AndroidLibrary dependency : library.getLibraryDependencies()) {
            AppResourceRepository.addGradleLibrary(list, dependency, unique);
        }
    }

    @NotNull
    public List<LocalResourceRepository> getLibraries() {
        List<LocalResourceRepository> list = this.myLibraries;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/AppResourceRepository", "getLibraries"));
        }
        return list;
    }

    void updateRoots() {
        List<LocalResourceRepository> libraries = AppResourceRepository.computeLibraries(this.myFacet);
        List<LocalResourceRepository> repositories = AppResourceRepository.computeRepositories(this.myFacet, libraries);
        this.updateRoots(repositories, libraries);
    }

    void updateRoots(List<LocalResourceRepository> resources, List<LocalResourceRepository> libraries) {
        if (((Object)resources).equals(this.myChildren)) {
            return;
        }
        this.myLibraries = libraries;
        this.setChildren(resources);
    }

    @NotNull
    static AppResourceRepository createForTest(AndroidFacet facet, List<LocalResourceRepository> modules, List<LocalResourceRepository> libraries) {
        assert (modules.containsAll(libraries));
        assert (modules.size() == libraries.size() + 1);
        AppResourceRepository appResourceRepository = new AppResourceRepository(facet, modules, libraries);
        if (appResourceRepository == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/AppResourceRepository", "createForTest"));
        }
        return appResourceRepository;
    }

    @Nullable
    public FileResourceRepository findRepositoryFor(@NotNull File aarDirectory) {
        if (aarDirectory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aarDirectory", "com/android/tools/idea/rendering/AppResourceRepository", "findRepositoryFor"));
        }
        String aarPath = aarDirectory.getPath();
        assert (aarPath.endsWith(".aar") || aarPath.contains("exploded-aar")) : aarPath;
        for (LocalResourceRepository r : this.myLibraries) {
            if (r instanceof FileResourceRepository) {
                FileResourceRepository repository = (FileResourceRepository)r;
                if (!repository.getResourceDirectory().getPath().startsWith(aarPath)) continue;
                return repository;
            }
            assert (false) : ((Object)((Object)r)).getClass();
        }
        return null;
    }

    @Nullable
    public Pair<ResourceType, String> resolveResourceId(int id) {
        Pair pair;
        Pair result = null;
        if (this.myResIdValueToNameMap != null) {
            result = (Pair)this.myResIdValueToNameMap.get(id);
        }
        if (result == null && (pair = (Pair)this.myDynamicId2ResourceMap.get(id)) != null) {
            result = pair;
        }
        return result;
    }

    @Nullable
    public String resolveStyleable(int[] id) {
        if (this.myStyleableValueToNameMap != null) {
            this.myWrapper.set(id);
            return this.myStyleableValueToNameMap.get(this.myWrapper);
        }
        return null;
    }

    @Nullable
    public Integer getResourceId(ResourceType type, String name) {
        TObjectIntHashMap<String> map;
        TObjectIntHashMap<String> tObjectIntHashMap = map = this.myResourceValueMap != null ? this.myResourceValueMap.get(type) : null;
        if (map == null || !map.containsKey((Object)name)) {
            return this.getDynamicId(type, name);
        }
        return map.get((Object)name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getDynamicId(ResourceType type, String name) {
        TObjectIntHashMap<String> tObjectIntHashMap = this.myName2DynamicIdMap;
        synchronized (tObjectIntHashMap) {
            if (this.myName2DynamicIdMap.containsKey((Object)name)) {
                return this.myName2DynamicIdMap.get((Object)name);
            }
            int value = ++this.myDynamicSeed;
            this.myName2DynamicIdMap.put((Object)name, value);
            this.myDynamicId2ResourceMap.put(value, (Object)Pair.of((Object)type, (Object)name));
            return value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCompiledResources(TIntObjectHashMap<Pair<ResourceType, String>> id2res, Map<IntArrayWrapper, String> styleableId2name, Map<ResourceType, TObjectIntHashMap<String>> res2id) {
        TObjectIntHashMap<String> tObjectIntHashMap = this.myName2DynamicIdMap;
        synchronized (tObjectIntHashMap) {
            this.myDynamicSeed = 0x7FFF0000;
            this.myName2DynamicIdMap.clear();
            this.myDynamicId2ResourceMap.clear();
        }
        this.myResourceValueMap = res2id;
        this.myResIdValueToNameMap = id2res;
        this.myStyleableValueToNameMap = styleableId2name;
    }
}

