/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.stats;

import com.android.tools.idea.stats.KeyString;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;
import org.jetbrains.annotations.NotNull;

public class BuildRecord {
    private final long myUtcTimestampMs;
    @NotNull
    private final KeyString[] myData;

    public BuildRecord(String ... keyValuePairs) {
        assert (keyValuePairs.length % 2 == 0);
        if (keyValuePairs.length % 2 != 0) {
            throw new IllegalArgumentException("BuildRecord keyValuePairs should have an even length.");
        }
        KeyString[] ks = new KeyString[keyValuePairs.length / 2];
        int i = 0;
        int j = 0;
        while (i < ks.length) {
            ks[i] = new KeyString(keyValuePairs[j], keyValuePairs[j + 1]);
            ++i;
            j += 2;
        }
        this.myUtcTimestampMs = BuildRecord.utcNow();
        this.myData = ks;
    }

    /*
     * WARNING - void declaration
     */
    public BuildRecord(long utcTimestampMs, @NotNull KeyString[] keyStringArray) {
        void data;
        if (keyStringArray == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/stats/BuildRecord", "<init>"));
        }
        this.myUtcTimestampMs = utcTimestampMs;
        this.myData = data;
    }

    /*
     * WARNING - void declaration
     */
    public BuildRecord(long utcTimestampMs, @NotNull List<KeyString> list) {
        void data;
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/android/tools/idea/stats/BuildRecord", "<init>"));
        }
        this.myUtcTimestampMs = utcTimestampMs;
        this.myData = data.toArray(new KeyString[data.size()]);
    }

    public static long utcNow() {
        Calendar c = Calendar.getInstance();
        c.setTimeZone(TimeZone.getTimeZone("GMT"));
        return c.getTimeInMillis();
    }

    public long getUtcTimestampMs() {
        return this.myUtcTimestampMs;
    }

    @NotNull
    public KeyString[] getData() {
        if (this.myData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/stats/BuildRecord", "getData"));
        }
        return this.myData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuildRecord that = (BuildRecord)o;
        if (this.myUtcTimestampMs != that.myUtcTimestampMs) {
            return false;
        }
        return Arrays.equals(this.myData, that.myData);
    }

    public int hashCode() {
        int result = (int)(this.myUtcTimestampMs ^ this.myUtcTimestampMs >>> 32);
        result = 31 * result + Arrays.hashCode(this.myData);
        return result;
    }

    public String toString() {
        return "BuildRecord{myUtcTimestampMs=" + this.myUtcTimestampMs + ", myData=" + Arrays.toString(this.myData) + '}';
    }
}

