/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.typeEnhancers;

import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.ConversionResult;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.GrTypeConverter;

public class GrCharConverter
extends GrTypeConverter {
    @Override
    public boolean isApplicableTo(@NotNull GrTypeConverter.ApplicableTo position) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "org/jetbrains/plugins/groovy/lang/psi/typeEnhancers/GrCharConverter", "isApplicableTo"));
        }
        return position == GrTypeConverter.ApplicableTo.EXPLICIT_CAST || position == GrTypeConverter.ApplicableTo.ASSIGNMENT || position == GrTypeConverter.ApplicableTo.RETURN_VALUE;
    }

    @Override
    @Nullable
    public ConversionResult isConvertibleEx(@NotNull PsiType lType, @NotNull PsiType rType, @NotNull GroovyPsiElement context, @NotNull GrTypeConverter.ApplicableTo currentPosition) {
        Object value;
        GrExpression rValue;
        GroovyPsiElement assignmentExpression;
        if (lType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lType", "org/jetbrains/plugins/groovy/lang/psi/typeEnhancers/GrCharConverter", "isConvertibleEx"));
        }
        if (rType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rType", "org/jetbrains/plugins/groovy/lang/psi/typeEnhancers/GrCharConverter", "isConvertibleEx"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/groovy/lang/psi/typeEnhancers/GrCharConverter", "isConvertibleEx"));
        }
        if (currentPosition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentPosition", "org/jetbrains/plugins/groovy/lang/psi/typeEnhancers/GrCharConverter", "isConvertibleEx"));
        }
        if (PsiType.CHAR != TypesUtil.unboxPrimitiveTypeWrapper(lType)) {
            return null;
        }
        if (PsiType.CHAR == TypesUtil.unboxPrimitiveTypeWrapper(rType)) {
            return ConversionResult.OK;
        }
        if (TypesUtil.isNumericType(rType)) {
            if (rType instanceof PsiPrimitiveType || currentPosition != GrTypeConverter.ApplicableTo.EXPLICIT_CAST && TypesUtil.unboxPrimitiveTypeWrapper(rType) instanceof PsiPrimitiveType) {
                return PsiType.CHAR == lType ? ConversionResult.OK : ConversionResult.ERROR;
            }
            return ConversionResult.ERROR;
        }
        if (context instanceof GrAssignmentExpression) {
            assignmentExpression = (GrAssignmentExpression)context;
            rValue = assignmentExpression.getRValue();
        } else if (context instanceof GrVariable) {
            assignmentExpression = (GrVariable)context;
            rValue = assignmentExpression.getInitializerGroovy();
        } else {
            rValue = null;
        }
        if (rValue instanceof GrListOrMap && ((GrListOrMap)rValue).isEmpty()) {
            return ConversionResult.WARNING;
        }
        if (PsiType.BOOLEAN == TypesUtil.unboxPrimitiveTypeWrapper(rType)) {
            switch (currentPosition) {
                case EXPLICIT_CAST: {
                    return ConversionResult.ERROR;
                }
                case ASSIGNMENT: 
                case RETURN_VALUE: {
                    return ConversionResult.WARNING;
                }
            }
            return null;
        }
        if (currentPosition == GrTypeConverter.ApplicableTo.RETURN_VALUE) {
            return null;
        }
        if (!TypesUtil.isClassType(rType, "java.lang.String")) {
            return null;
        }
        GrLiteral literal = GrCharConverter.getLiteral(context);
        Object object = value = literal == null ? null : literal.getValue();
        return value == null ? null : (value.toString().length() == 1 ? ConversionResult.OK : ConversionResult.ERROR);
    }
}

