/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.ide.FrameStateListener;
import com.intellij.ide.FrameStateManager;
import com.intellij.idea.RareLogger;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CheckoutProvider;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.EditFileProvider;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ObjectsConvertor;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.VcsListener;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.VcsShowSettingOption;
import com.intellij.openapi.vcs.annotate.AnnotationProvider;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ChangeProvider;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.LocalChangeListsLoadedListener;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.merge.MergeProvider;
import com.intellij.openapi.vcs.rollback.RollbackEnvironment;
import com.intellij.openapi.vcs.update.UpdateEnvironment;
import com.intellij.openapi.vcs.versionBrowser.ChangeBrowserSettings;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.Consumer;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.SoftHashMap;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.RootUrlInfo;
import org.jetbrains.idea.svn.RootUrlPair;
import org.jetbrains.idea.svn.RootsToWorkingCopies;
import org.jetbrains.idea.svn.SvnApplicationSettings;
import org.jetbrains.idea.svn.SvnChangeProvider;
import org.jetbrains.idea.svn.SvnChangelistListener;
import org.jetbrains.idea.svn.SvnConfigurable;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.SvnCopiesRefreshManager;
import org.jetbrains.idea.svn.SvnDiffProvider;
import org.jetbrains.idea.svn.SvnEditFileProvider;
import org.jetbrains.idea.svn.SvnEntriesFileListener;
import org.jetbrains.idea.svn.SvnExceptionLogFilter;
import org.jetbrains.idea.svn.SvnFileStatus;
import org.jetbrains.idea.svn.SvnFileUrlMapping;
import org.jetbrains.idea.svn.SvnFileUrlMappingImpl;
import org.jetbrains.idea.svn.SvnFormatSelector;
import org.jetbrains.idea.svn.SvnRevisionNumber;
import org.jetbrains.idea.svn.SvnStatusUtil;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.UniqueRootsFilter;
import org.jetbrains.idea.svn.WorkingCopiesContent;
import org.jetbrains.idea.svn.WorkingCopy;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.actions.CleanupWorker;
import org.jetbrains.idea.svn.actions.ShowPropertiesDiffWithLocalAction;
import org.jetbrains.idea.svn.actions.SvnMergeProvider;
import org.jetbrains.idea.svn.annotate.SvnAnnotationProvider;
import org.jetbrains.idea.svn.api.ClientFactory;
import org.jetbrains.idea.svn.api.CmdClientFactory;
import org.jetbrains.idea.svn.api.CmdVersionClient;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.SvnKitClientFactory;
import org.jetbrains.idea.svn.auth.SvnAuthenticationNotifier;
import org.jetbrains.idea.svn.branchConfig.SvnLoadedBranchesStorage;
import org.jetbrains.idea.svn.checkin.SvnCheckinEnvironment;
import org.jetbrains.idea.svn.checkout.SvnCheckoutProvider;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.commandLine.SvnExecutableChecker;
import org.jetbrains.idea.svn.dialogs.WCInfo;
import org.jetbrains.idea.svn.history.LoadedRevisionsCache;
import org.jetbrains.idea.svn.history.SvnChangeList;
import org.jetbrains.idea.svn.history.SvnCommittedChangesProvider;
import org.jetbrains.idea.svn.history.SvnHistoryProvider;
import org.jetbrains.idea.svn.info.Info;
import org.jetbrains.idea.svn.info.InfoConsumer;
import org.jetbrains.idea.svn.integrate.SvnBranchPointsCalculator;
import org.jetbrains.idea.svn.properties.PropertyClient;
import org.jetbrains.idea.svn.properties.PropertyValue;
import org.jetbrains.idea.svn.rollback.SvnRollbackEnvironment;
import org.jetbrains.idea.svn.status.Status;
import org.jetbrains.idea.svn.status.StatusType;
import org.jetbrains.idea.svn.svnkit.SvnKitManager;
import org.jetbrains.idea.svn.update.SvnIntegrateEnvironment;
import org.jetbrains.idea.svn.update.SvnUpdateEnvironment;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.wc.SVNAdminUtil;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class SvnVcs
extends AbstractVcs<CommittedChangeList> {
    private static final String DO_NOT_LISTEN_TO_WC_DB = "svn.do.not.listen.to.wc.db";
    private static final Logger REFRESH_LOG = Logger.getInstance((String)"#svn_refresh");
    public static boolean ourListenToWcDb = !Boolean.getBoolean("svn.do.not.listen.to.wc.db");
    private static final Logger LOG = SvnVcs.wrapLogger(Logger.getInstance((String)"org.jetbrains.idea.svn.SvnVcs"));
    @NonNls
    public static final String VCS_NAME = "svn";
    public static final String VCS_DISPLAY_NAME = "Subversion";
    private static final VcsKey ourKey = SvnVcs.createKey((String)"svn");
    public static final Topic<Runnable> WC_CONVERTED = new Topic("WC_CONVERTED", Runnable.class);
    private final Map<String, Map<String, Pair<PropertyValue, Trinity<Long, Long, Long>>>> myPropertyCache;
    private final SvnConfiguration myConfiguration;
    private final SvnEntriesFileListener myEntriesFileListener;
    private CheckinEnvironment myCheckinEnvironment;
    private RollbackEnvironment myRollbackEnvironment;
    private UpdateEnvironment mySvnUpdateEnvironment;
    private UpdateEnvironment mySvnIntegrateEnvironment;
    private AnnotationProvider myAnnotationProvider;
    private DiffProvider mySvnDiffProvider;
    private final VcsShowConfirmationOption myAddConfirmation;
    private final VcsShowConfirmationOption myDeleteConfirmation;
    private EditFileProvider myEditFilesProvider;
    private SvnCommittedChangesProvider myCommittedChangesProvider;
    private final VcsShowSettingOption myCheckoutOptions;
    private ChangeProvider myChangeProvider;
    private MergeProvider myMergeProvider;
    private final WorkingCopiesContent myWorkingCopiesContent;
    private final SvnChangelistListener myChangeListListener;
    private SvnCopiesRefreshManager myCopiesRefreshManager;
    private SvnFileUrlMappingImpl myMapping;
    private final MyFrameStateListener myFrameStateListener;
    public static final Topic<Consumer> ROOTS_RELOADED = new Topic("ROOTS_RELOADED", Consumer.class);
    private VcsListener myVcsListener;
    private SvnBranchPointsCalculator mySvnBranchPointsCalculator;
    private final RootsToWorkingCopies myRootsToWorkingCopies;
    private final SvnAuthenticationNotifier myAuthNotifier;
    private final SvnLoadedBranchesStorage myLoadedBranchesStorage;
    private final SvnExecutableChecker myChecker;
    private SvnCheckoutProvider myCheckoutProvider;
    @NotNull
    private final ClientFactory cmdClientFactory;
    @NotNull
    private final ClientFactory svnKitClientFactory;
    @NotNull
    private final SvnKitManager svnKitManager;
    private final boolean myLogExceptions;

    public SvnVcs(@NotNull Project project, MessageBus bus, SvnConfiguration svnConfiguration, SvnLoadedBranchesStorage storage) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/svn/SvnVcs", "<init>"));
        }
        super(project, VCS_NAME);
        this.myPropertyCache = new SoftHashMap();
        this.myLoadedBranchesStorage = storage;
        this.myRootsToWorkingCopies = new RootsToWorkingCopies(this);
        this.myConfiguration = svnConfiguration;
        this.myAuthNotifier = new SvnAuthenticationNotifier(this);
        this.cmdClientFactory = new CmdClientFactory(this);
        this.svnKitClientFactory = new SvnKitClientFactory(this);
        this.svnKitManager = new SvnKitManager(this);
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        this.myAddConfirmation = vcsManager.getStandardConfirmation(VcsConfiguration.StandardConfirmation.ADD, (AbstractVcs)this);
        this.myDeleteConfirmation = vcsManager.getStandardConfirmation(VcsConfiguration.StandardConfirmation.REMOVE, (AbstractVcs)this);
        this.myCheckoutOptions = vcsManager.getStandardOption(VcsConfiguration.StandardOption.CHECKOUT, (AbstractVcs)this);
        if (this.myProject.isDefault()) {
            this.myChangeListListener = null;
            this.myEntriesFileListener = null;
        } else {
            this.myEntriesFileListener = new SvnEntriesFileListener(project);
            this.upgradeIfNeeded(bus);
            this.myChangeListListener = new SvnChangelistListener(this.myProject, this);
            this.myVcsListener = new VcsListener(){

                public void directoryMappingChanged() {
                    SvnVcs.this.invokeRefreshSvnRoots();
                }
            };
        }
        this.myFrameStateListener = project.isDefault() ? null : new MyFrameStateListener(ChangeListManager.getInstance((Project)project), VcsDirtyScopeManager.getInstance((Project)project));
        this.myWorkingCopiesContent = new WorkingCopiesContent(this);
        this.myChecker = new SvnExecutableChecker(this);
        Application app = ApplicationManager.getApplication();
        this.myLogExceptions = app != null && (app.isInternal() || app.isUnitTestMode());
    }

    public void postStartup() {
        if (this.myProject.isDefault()) {
            return;
        }
        this.myCopiesRefreshManager = new SvnCopiesRefreshManager((SvnFileUrlMappingImpl)this.getSvnFileUrlMapping());
        if (!this.myConfiguration.isCleanupRun()) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    SvnVcs.this.cleanup17copies();
                    SvnVcs.this.myConfiguration.setCleanupRun(true);
                }
            }, ModalityState.NON_MODAL, this.myProject.getDisposed());
        } else {
            this.invokeRefreshSvnRoots();
        }
        this.myWorkingCopiesContent.activate();
    }

    private void cleanup17copies() {
        final Runnable callCleanupWorker = new Runnable(){

            @Override
            public void run() {
                if (SvnVcs.this.myProject.isDisposed()) {
                    return;
                }
                new CleanupWorker(new VirtualFile[0], SvnVcs.this.myProject, "action.Subversion.cleanup.progress.title"){

                    @Override
                    protected void chanceToFillRoots() {
                        List<WCInfo> infos = SvnVcs.this.getAllWcInfos();
                        LocalFileSystem lfs = LocalFileSystem.getInstance();
                        ArrayList<VirtualFile> roots = new ArrayList<VirtualFile>(infos.size());
                        for (WCInfo info : infos) {
                            if (!WorkingCopyFormat.ONE_DOT_SEVEN.equals((Object)info.getFormat())) continue;
                            VirtualFile file = lfs.refreshAndFindFileByIoFile(new File(info.getPath()));
                            if (file == null) {
                                LOG.info("Wasn't able to find virtual file for wc root: " + info.getPath());
                                continue;
                            }
                            roots.add(file);
                        }
                        this.myRoots = roots.toArray(new VirtualFile[roots.size()]);
                    }
                }.execute();
            }
        };
        this.myCopiesRefreshManager.waitRefresh(new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().invokeLater(callCleanupWorker, ModalityState.any());
            }
        });
    }

    public boolean checkCommandLineVersion() {
        return this.getFactory() != this.cmdClientFactory || this.myChecker.checkExecutableAndNotifyIfNeeded();
    }

    public void invokeRefreshSvnRoots() {
        if (REFRESH_LOG.isDebugEnabled()) {
            REFRESH_LOG.debug("refresh: ", new Throwable());
        }
        if (this.myCopiesRefreshManager != null) {
            this.myCopiesRefreshManager.asynchRequest();
        }
    }

    public boolean checkImmediateParentsBeforeCommit() {
        return true;
    }

    private void upgradeIfNeeded(MessageBus bus) {
        final MessageBusConnection connection = bus.connect();
        connection.subscribe(ChangeListManagerImpl.LISTS_LOADED, (Object)new LocalChangeListsLoadedListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void processLoadedLists(List<LocalChangeList> lists) {
                if (lists.isEmpty()) {
                    return;
                }
                try {
                    ChangeListManager.getInstance((Project)SvnVcs.this.myProject).setReadOnly(SvnChangeProvider.ourDefaultListName, true);
                    if (!SvnVcs.this.myConfiguration.changeListsSynchronized()) {
                        SvnVcs.this.processChangeLists(lists);
                    }
                }
                catch (ProcessCanceledException processCanceledException) {
                }
                finally {
                    SvnVcs.this.myConfiguration.upgrade();
                }
                connection.disconnect();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processChangeLists(List<LocalChangeList> lists) {
        ProjectLevelVcsManager plVcsManager = ProjectLevelVcsManager.getInstanceChecked((Project)this.myProject);
        plVcsManager.startBackgroundVcsOperation();
        try {
            for (LocalChangeList list : lists) {
                if (list.isDefault()) continue;
                Collection changes = list.getChanges();
                for (Change change : changes) {
                    this.correctListForRevision(plVcsManager, change.getBeforeRevision(), list.getName());
                    this.correctListForRevision(plVcsManager, change.getAfterRevision(), list.getName());
                }
            }
        }
        catch (Throwable throwable) {
            Application appManager = ApplicationManager.getApplication();
            if (appManager.isDispatchThread()) {
                appManager.executeOnPooledThread(new Runnable(plVcsManager){
                    final /* synthetic */ ProjectLevelVcsManager val$plVcsManager;
                    {
                        this.val$plVcsManager = projectLevelVcsManager;
                    }

                    @Override
                    public void run() {
                        this.val$plVcsManager.stopBackgroundVcsOperation();
                    }
                });
            } else {
                plVcsManager.stopBackgroundVcsOperation();
            }
            throw throwable;
        }
        Application appManager = ApplicationManager.getApplication();
        if (appManager.isDispatchThread()) {
            appManager.executeOnPooledThread(new /* invalid duplicate definition of identical inner class */);
        } else {
            plVcsManager.stopBackgroundVcsOperation();
        }
    }

    private void correctListForRevision(@NotNull ProjectLevelVcsManager plVcsManager, @Nullable ContentRevision revision, @NotNull String name) {
        FilePath path;
        AbstractVcs vcs;
        if (plVcsManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "plVcsManager", "org/jetbrains/idea/svn/SvnVcs", "correctListForRevision"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/idea/svn/SvnVcs", "correctListForRevision"));
        }
        if (revision != null && (vcs = plVcsManager.getVcsFor(path = revision.getFile())) != null && VCS_NAME.equals(vcs.getName())) {
            try {
                this.getFactory(path.getIOFile()).createChangeListClient().add(name, path.getIOFile(), null);
            }
            catch (VcsException e) {
                // empty catch block
            }
        }
    }

    public void activate() {
        if (!this.myProject.isDefault()) {
            ChangeListManager.getInstance((Project)this.myProject).addChangeListListener((ChangeListListener)this.myChangeListListener);
            this.myProject.getMessageBus().connect().subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, (Object)this.myVcsListener);
        }
        SvnApplicationSettings.getInstance().svnActivated();
        if (this.myEntriesFileListener != null) {
            VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)this.myEntriesFileListener);
        }
        LoadedRevisionsCache.getInstance(this.myProject);
        FrameStateManager.getInstance().addListener((FrameStateListener)this.myFrameStateListener);
        this.myAuthNotifier.init();
        this.mySvnBranchPointsCalculator = new SvnBranchPointsCalculator(this.myProject);
        this.mySvnBranchPointsCalculator.activate();
        this.svnKitManager.activate();
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            this.checkCommandLineVersion();
        }
        StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized((Runnable)new DumbAwareRunnable(){

            public void run() {
                SvnVcs.this.postStartup();
            }
        });
        this.myProject.getMessageBus().connect().subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, (Object)this.myRootsToWorkingCopies);
        this.myLoadedBranchesStorage.activate();
    }

    public static Logger wrapLogger(Logger logger) {
        return RareLogger.wrap((Logger)logger, (boolean)Boolean.getBoolean("svn.logger.fairsynch"), (RareLogger.LogFilter[])new RareLogger.LogFilter[]{new SvnExceptionLogFilter()});
    }

    public RootsToWorkingCopies getRootsToWorkingCopies() {
        return this.myRootsToWorkingCopies;
    }

    public SvnAuthenticationNotifier getAuthNotifier() {
        return this.myAuthNotifier;
    }

    public void deactivate() {
        FrameStateManager.getInstance().removeListener((FrameStateListener)this.myFrameStateListener);
        if (this.myEntriesFileListener != null) {
            VirtualFileManager.getInstance().removeVirtualFileListener((VirtualFileListener)this.myEntriesFileListener);
        }
        SvnApplicationSettings.getInstance().svnDeactivated();
        if (this.myCommittedChangesProvider != null) {
            this.myCommittedChangesProvider.deactivate();
        }
        if (this.myChangeListListener != null && !this.myProject.isDefault()) {
            ChangeListManager.getInstance((Project)this.myProject).removeChangeListListener((ChangeListListener)this.myChangeListListener);
        }
        this.myRootsToWorkingCopies.clear();
        this.myAuthNotifier.stop();
        this.myAuthNotifier.clear();
        this.mySvnBranchPointsCalculator.deactivate();
        this.mySvnBranchPointsCalculator = null;
        this.myWorkingCopiesContent.deactivate();
        this.myLoadedBranchesStorage.deactivate();
    }

    public VcsShowConfirmationOption getAddConfirmation() {
        return this.myAddConfirmation;
    }

    public VcsShowConfirmationOption getDeleteConfirmation() {
        return this.myDeleteConfirmation;
    }

    public VcsShowSettingOption getCheckoutOptions() {
        return this.myCheckoutOptions;
    }

    public EditFileProvider getEditFileProvider() {
        if (this.myEditFilesProvider == null) {
            this.myEditFilesProvider = new SvnEditFileProvider(this);
        }
        return this.myEditFilesProvider;
    }

    @NotNull
    public ChangeProvider getChangeProvider() {
        if (this.myChangeProvider == null) {
            this.myChangeProvider = new SvnChangeProvider(this);
        }
        ChangeProvider changeProvider = this.myChangeProvider;
        if (changeProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnVcs", "getChangeProvider"));
        }
        return changeProvider;
    }

    public UpdateEnvironment getIntegrateEnvironment() {
        if (this.mySvnIntegrateEnvironment == null) {
            this.mySvnIntegrateEnvironment = new SvnIntegrateEnvironment(this);
        }
        return this.mySvnIntegrateEnvironment;
    }

    public UpdateEnvironment createUpdateEnvironment() {
        if (this.mySvnUpdateEnvironment == null) {
            this.mySvnUpdateEnvironment = new SvnUpdateEnvironment(this);
        }
        return this.mySvnUpdateEnvironment;
    }

    public String getDisplayName() {
        return VCS_DISPLAY_NAME;
    }

    public Configurable getConfigurable() {
        return new SvnConfigurable(this.myProject);
    }

    public SvnConfiguration getSvnConfiguration() {
        return this.myConfiguration;
    }

    public static SvnVcs getInstance(Project project) {
        return (SvnVcs)ProjectLevelVcsManager.getInstance((Project)project).findVcsByName(VCS_NAME);
    }

    @NotNull
    public CheckinEnvironment createCheckinEnvironment() {
        if (this.myCheckinEnvironment == null) {
            this.myCheckinEnvironment = new SvnCheckinEnvironment(this);
        }
        CheckinEnvironment checkinEnvironment = this.myCheckinEnvironment;
        if (checkinEnvironment == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnVcs", "createCheckinEnvironment"));
        }
        return checkinEnvironment;
    }

    @NotNull
    public RollbackEnvironment createRollbackEnvironment() {
        if (this.myRollbackEnvironment == null) {
            this.myRollbackEnvironment = new SvnRollbackEnvironment(this);
        }
        RollbackEnvironment rollbackEnvironment = this.myRollbackEnvironment;
        if (rollbackEnvironment == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnVcs", "createRollbackEnvironment"));
        }
        return rollbackEnvironment;
    }

    public VcsHistoryProvider getVcsHistoryProvider() {
        return new SvnHistoryProvider(this);
    }

    public VcsHistoryProvider getVcsBlockHistoryProvider() {
        return this.getVcsHistoryProvider();
    }

    public AnnotationProvider getAnnotationProvider() {
        if (this.myAnnotationProvider == null) {
            this.myAnnotationProvider = new SvnAnnotationProvider(this);
        }
        return this.myAnnotationProvider;
    }

    public DiffProvider getDiffProvider() {
        if (this.mySvnDiffProvider == null) {
            this.mySvnDiffProvider = new SvnDiffProvider(this);
        }
        return this.mySvnDiffProvider;
    }

    private static Trinity<Long, Long, Long> getTimestampForPropertiesChange(File ioFile, boolean isDir) {
        File dir = isDir ? ioFile : ioFile.getParentFile();
        String relPath = SVNAdminUtil.getPropPath((String)ioFile.getName(), (SVNNodeKind)(isDir ? SVNNodeKind.DIR : SVNNodeKind.FILE), (boolean)false);
        String relPathBase = SVNAdminUtil.getPropBasePath((String)ioFile.getName(), (SVNNodeKind)(isDir ? SVNNodeKind.DIR : SVNNodeKind.FILE), (boolean)false);
        String relPathRevert = SVNAdminUtil.getPropRevertPath((String)ioFile.getName(), (SVNNodeKind)(isDir ? SVNNodeKind.DIR : SVNNodeKind.FILE), (boolean)false);
        return new Trinity((Object)new File(dir, relPath).lastModified(), (Object)new File(dir, relPathBase).lastModified(), (Object)new File(dir, relPathRevert).lastModified());
    }

    private static boolean trinitiesEqual(Trinity<Long, Long, Long> t1, Trinity<Long, Long, Long> t2) {
        if ((Long)t2.first == 0L && (Long)t2.second == 0L && (Long)t2.third == 0L) {
            return false;
        }
        return t1.equals(t2);
    }

    @Nullable
    public PropertyValue getPropertyWithCaching(VirtualFile file, String propName) throws VcsException {
        Map<String, Pair<PropertyValue, Trinity<Long, Long, Long>>> cachedMap = this.myPropertyCache.get(SvnVcs.keyForVf(file));
        Pair<PropertyValue, Trinity<Long, Long, Long>> cachedValue = cachedMap == null ? null : cachedMap.get(propName);
        File ioFile = new File(file.getPath());
        Trinity<Long, Long, Long> tsTrinity = SvnVcs.getTimestampForPropertiesChange(ioFile, file.isDirectory());
        if (cachedValue != null && SvnVcs.trinitiesEqual((Trinity<Long, Long, Long>)((Trinity)cachedValue.getSecond()), tsTrinity)) {
            return (PropertyValue)cachedValue.getFirst();
        }
        PropertyClient client = this.getFactory(ioFile).createPropertyClient();
        PropertyValue value = client.getProperty(SvnTarget.fromFile((File)ioFile, (SVNRevision)SVNRevision.WORKING), propName, false, SVNRevision.WORKING);
        if (cachedMap == null) {
            cachedMap = new HashMap<String, Pair<PropertyValue, Trinity<Long, Long, Long>>>();
            this.myPropertyCache.put(SvnVcs.keyForVf(file), cachedMap);
        }
        cachedMap.put(propName, (Pair<PropertyValue, Trinity<Long, Long, Long>>)Pair.create((Object)value, tsTrinity));
        return value;
    }

    public boolean fileExistsInVcs(FilePath path) {
        File file = path.getIOFile();
        try {
            Status status = this.getFactory(file).createStatusClient().doStatus(file, false);
            if (status != null) {
                return status.is(StatusType.STATUS_ADDED) ? status.isCopied() : !status.is(StatusType.STATUS_UNVERSIONED, StatusType.STATUS_IGNORED, StatusType.STATUS_OBSTRUCTED);
            }
        }
        catch (SvnBindException e) {
            LOG.info((Throwable)((Object)e));
        }
        return false;
    }

    public boolean fileIsUnderVcs(FilePath path) {
        ChangeListManager clManager = ChangeListManager.getInstance((Project)this.myProject);
        VirtualFile file = path.getVirtualFile();
        if (file == null) {
            return false;
        }
        return !SvnStatusUtil.isIgnoredInAnySense(clManager, file) && !clManager.isUnversioned(file);
    }

    @Nullable
    public Info getInfo(@NotNull SVNURL url, SVNRevision pegRevision, SVNRevision revision) throws SvnBindException {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/idea/svn/SvnVcs", "getInfo"));
        }
        return this.getFactory().createInfoClient().doInfo(url, pegRevision, revision);
    }

    @Nullable
    public Info getInfo(@NotNull SVNURL url, SVNRevision revision) throws SvnBindException {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/idea/svn/SvnVcs", "getInfo"));
        }
        return this.getInfo(url, SVNRevision.UNDEFINED, revision);
    }

    @Nullable
    public Info getInfo(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/svn/SvnVcs", "getInfo"));
        }
        return this.getInfo(new File(file.getPath()));
    }

    @Nullable
    public Info getInfo(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/idea/svn/SvnVcs", "getInfo"));
        }
        return this.getInfo(new File(path));
    }

    @Nullable
    public Info getInfo(@NotNull File ioFile) {
        if (ioFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ioFile", "org/jetbrains/idea/svn/SvnVcs", "getInfo"));
        }
        return this.getInfo(ioFile, SVNRevision.UNDEFINED);
    }

    public void collectInfo(@NotNull Collection<File> files, @Nullable InfoConsumer handler) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/idea/svn/SvnVcs", "collectInfo"));
        }
        File first = (File)ContainerUtil.getFirstItem(files);
        if (first != null) {
            ClientFactory factory = this.getFactory(first);
            try {
                if (factory instanceof CmdClientFactory) {
                    factory.createInfoClient().doInfo(files, handler);
                } else {
                    for (File file : files) {
                        Info info = this.getInfo(file);
                        if (handler == null) continue;
                        handler.consume(info);
                    }
                }
            }
            catch (SVNException e) {
                this.handleInfoException(new SvnBindException(e));
            }
            catch (SvnBindException e) {
                this.handleInfoException(e);
            }
        }
    }

    @Nullable
    public Info getInfo(@NotNull File ioFile, @NotNull SVNRevision revision) {
        if (ioFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ioFile", "org/jetbrains/idea/svn/SvnVcs", "getInfo"));
        }
        if (revision == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revision", "org/jetbrains/idea/svn/SvnVcs", "getInfo"));
        }
        Info result = null;
        try {
            result = this.getFactory(ioFile).createInfoClient().doInfo(ioFile, revision);
        }
        catch (SvnBindException e) {
            this.handleInfoException(e);
        }
        return result;
    }

    private void handleInfoException(@NotNull SvnBindException e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/idea/svn/SvnVcs", "handleInfoException"));
        }
        if (!this.myLogExceptions || SvnUtil.isUnversionedOrNotFound(e) || e.contains(SVNErrorCode.WC_UNSUPPORTED_FORMAT) || e.contains(SVNErrorCode.WC_UPGRADE_REQUIRED)) {
            LOG.debug((Throwable)((Object)e));
        } else {
            LOG.error((Throwable)((Object)e));
        }
    }

    @NotNull
    public WorkingCopyFormat getWorkingCopyFormat(@NotNull File ioFile) {
        if (ioFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ioFile", "org/jetbrains/idea/svn/SvnVcs", "getWorkingCopyFormat"));
        }
        WorkingCopyFormat workingCopyFormat = this.getWorkingCopyFormat(ioFile, true);
        if (workingCopyFormat == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnVcs", "getWorkingCopyFormat"));
        }
        return workingCopyFormat;
    }

    @NotNull
    public WorkingCopyFormat getWorkingCopyFormat(@NotNull File ioFile, boolean useMapping) {
        if (ioFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ioFile", "org/jetbrains/idea/svn/SvnVcs", "getWorkingCopyFormat"));
        }
        WorkingCopyFormat format = WorkingCopyFormat.UNKNOWN;
        if (useMapping) {
            RootUrlInfo rootInfo = this.getSvnFileUrlMapping().getWcRootForFilePath(ioFile);
            format = rootInfo != null ? rootInfo.getFormat() : WorkingCopyFormat.UNKNOWN;
        }
        WorkingCopyFormat workingCopyFormat = WorkingCopyFormat.UNKNOWN.equals((Object)format) ? SvnFormatSelector.findRootAndGetFormat(ioFile) : format;
        if (workingCopyFormat == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnVcs", "getWorkingCopyFormat"));
        }
        return workingCopyFormat;
    }

    public boolean isWcRoot(@NotNull FilePath filePath) {
        WorkingCopy wcRoot;
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "org/jetbrains/idea/svn/SvnVcs", "isWcRoot"));
        }
        boolean isWcRoot = false;
        VirtualFile file = filePath.getVirtualFile();
        WorkingCopy workingCopy = wcRoot = file != null ? this.myRootsToWorkingCopies.getWcRoot(file) : null;
        if (wcRoot != null) {
            isWcRoot = wcRoot.getFile().getAbsolutePath().equals(filePath.getIOFile().getAbsolutePath());
        }
        return isWcRoot;
    }

    public FileStatus[] getProvidedStatuses() {
        return new FileStatus[]{SvnFileStatus.EXTERNAL, SvnFileStatus.OBSTRUCTED, SvnFileStatus.REPLACED};
    }

    @NotNull
    public CommittedChangesProvider<SvnChangeList, ChangeBrowserSettings> getCommittedChangesProvider() {
        if (this.myCommittedChangesProvider == null) {
            this.myCommittedChangesProvider = new SvnCommittedChangesProvider(this.myProject);
        }
        SvnCommittedChangesProvider svnCommittedChangesProvider = this.myCommittedChangesProvider;
        if (svnCommittedChangesProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnVcs", "getCommittedChangesProvider"));
        }
        return svnCommittedChangesProvider;
    }

    @Nullable
    public VcsRevisionNumber parseRevisionNumber(String revisionNumberString) {
        SVNRevision revision = SVNRevision.parse((String)revisionNumberString);
        if (revision.equals((Object)SVNRevision.UNDEFINED)) {
            return null;
        }
        return new SvnRevisionNumber(revision);
    }

    public String getRevisionPattern() {
        return "\\d+";
    }

    public boolean isVersionedDirectory(VirtualFile dir) {
        return SvnUtil.seemsLikeVersionedDir(dir);
    }

    @NotNull
    public SvnFileUrlMapping getSvnFileUrlMapping() {
        if (this.myMapping == null) {
            this.myMapping = SvnFileUrlMappingImpl.getInstance(this.myProject);
        }
        SvnFileUrlMappingImpl svnFileUrlMappingImpl = this.myMapping;
        if (svnFileUrlMappingImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnVcs", "getSvnFileUrlMapping"));
        }
        return svnFileUrlMappingImpl;
    }

    public List<WCInfo> getAllWcInfos() {
        SvnFileUrlMapping urlMapping = this.getSvnFileUrlMapping();
        List<RootUrlInfo> infoList = urlMapping.getAllWcInfos();
        ArrayList<WCInfo> infos = new ArrayList<WCInfo>();
        for (RootUrlInfo info : infoList) {
            File file = info.getIoFile();
            infos.add(new WCInfo(info, SvnUtil.isWorkingCopyRoot(file), SvnUtil.getDepth(this, file)));
        }
        return infos;
    }

    public List<WCInfo> getWcInfosWithErrors() {
        ArrayList<WCInfo> result = new ArrayList<WCInfo>(this.getAllWcInfos());
        for (RootUrlInfo info : this.getSvnFileUrlMapping().getErrorRoots()) {
            result.add(new WCInfo(info, SvnUtil.isWorkingCopyRoot(info.getIoFile()), Depth.UNKNOWN));
        }
        return result;
    }

    public AbstractVcs.RootsConvertor getCustomConvertor() {
        if (this.myProject.isDefault()) {
            return null;
        }
        return this.getSvnFileUrlMapping();
    }

    public MergeProvider getMergeProvider() {
        if (this.myMergeProvider == null) {
            this.myMergeProvider = new SvnMergeProvider(this.myProject);
        }
        return this.myMergeProvider;
    }

    public List<AnAction> getAdditionalActionsForLocalChange() {
        return Arrays.asList(new AnAction[]{new ShowPropertiesDiffWithLocalAction()});
    }

    private static String keyForVf(VirtualFile vf) {
        return vf.getUrl();
    }

    public boolean allowsNestedRoots() {
        return true;
    }

    public <S> List<S> filterUniqueRoots(List<S> in, Convertor<S, VirtualFile> convertor) {
        if (in.size() <= 1) {
            return in;
        }
        ArrayList infos = new ArrayList(in.size());
        SvnFileUrlMappingImpl mapping = (SvnFileUrlMappingImpl)this.getSvnFileUrlMapping();
        LinkedList<S> notMatched = new LinkedList<S>();
        for (S s : in) {
            VirtualFile vf = (VirtualFile)convertor.convert(s);
            if (vf == null) continue;
            File ioFile = new File(vf.getPath());
            SVNURL url = mapping.getUrlForFile(ioFile);
            if (url == null && (url = SvnUtil.getUrl(this, ioFile)) == null) {
                notMatched.add(s);
                continue;
            }
            infos.add(new MyPair(vf, url.toString(), s));
        }
        List filtered = new UniqueRootsFilter().filter(infos);
        List converted = ObjectsConvertor.convert(filtered, (Convertor)new Convertor<MyPair<S>, S>(){

            public S convert(MyPair<S> o) {
                return o.getSrc();
            }
        });
        if (!notMatched.isEmpty()) {
            converted.addAll(notMatched);
        }
        return converted;
    }

    public static VcsKey getKey() {
        return ourKey;
    }

    public boolean isVcsBackgroundOperationsAllowed(@NotNull VirtualFile root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/idea/svn/SvnVcs", "isVcsBackgroundOperationsAllowed"));
        }
        ClientFactory factory = this.getFactory(VfsUtilCore.virtualToIoFile((VirtualFile)root));
        return ThreeState.YES.equals((Object)this.myAuthNotifier.isAuthenticatedFor(root, factory == this.cmdClientFactory ? factory : null));
    }

    public SvnBranchPointsCalculator getSvnBranchPointsCalculator() {
        return this.mySvnBranchPointsCalculator;
    }

    public boolean areDirectoriesVersionedItems() {
        return true;
    }

    public CheckoutProvider getCheckoutProvider() {
        if (this.myCheckoutProvider == null) {
            this.myCheckoutProvider = new SvnCheckoutProvider();
        }
        return this.myCheckoutProvider;
    }

    @NotNull
    public SvnKitManager getSvnKitManager() {
        SvnKitManager svnKitManager = this.svnKitManager;
        if (svnKitManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnVcs", "getSvnKitManager"));
        }
        return svnKitManager;
    }

    @NotNull
    private WorkingCopyFormat getProjectRootFormat() {
        WorkingCopyFormat workingCopyFormat = !this.getProject().isDefault() ? this.getWorkingCopyFormat(new File(this.getProject().getBaseDir().getPath())) : WorkingCopyFormat.UNKNOWN;
        if (workingCopyFormat == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnVcs", "getProjectRootFormat"));
        }
        return workingCopyFormat;
    }

    @NotNull
    public ClientFactory getFactory() {
        ClientFactory clientFactory = this.getFactory(this.getProjectRootFormat(), false);
        if (clientFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnVcs", "getFactory"));
        }
        return clientFactory;
    }

    @NotNull
    public ClientFactory getFactory(@NotNull WorkingCopyFormat format) {
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "org/jetbrains/idea/svn/SvnVcs", "getFactory"));
        }
        ClientFactory clientFactory = this.getFactory(format, false);
        if (clientFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnVcs", "getFactory"));
        }
        return clientFactory;
    }

    @NotNull
    public ClientFactory getFactory(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/svn/SvnVcs", "getFactory"));
        }
        ClientFactory clientFactory = this.getFactory(file, true);
        if (clientFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnVcs", "getFactory"));
        }
        return clientFactory;
    }

    @NotNull
    public ClientFactory getFactory(@NotNull File file, boolean useMapping) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/svn/SvnVcs", "getFactory"));
        }
        ClientFactory clientFactory = this.getFactory(this.getWorkingCopyFormat(file, useMapping), true);
        if (clientFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnVcs", "getFactory"));
        }
        return clientFactory;
    }

    @NotNull
    private ClientFactory getFactory(@NotNull WorkingCopyFormat format, boolean useProjectRootForUnknown) {
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "org/jetbrains/idea/svn/SvnVcs", "getFactory"));
        }
        boolean is18OrGreater = format.isOrGreater(WorkingCopyFormat.ONE_DOT_EIGHT);
        boolean isUnknown = WorkingCopyFormat.UNKNOWN.equals((Object)format);
        ClientFactory clientFactory = is18OrGreater ? this.cmdClientFactory : (!isUnknown && !this.isSupportedByCommandLine(format) ? this.svnKitClientFactory : (useProjectRootForUnknown && isUnknown ? this.getFactory() : this.getFactoryFromSettings()));
        if (clientFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnVcs", "getFactory"));
        }
        return clientFactory;
    }

    @NotNull
    public ClientFactory getFactory(@NotNull SvnTarget target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/idea/svn/SvnVcs", "getFactory"));
        }
        ClientFactory clientFactory = target.isFile() ? this.getFactory(target.getFile()) : this.getFactory();
        if (clientFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnVcs", "getFactory"));
        }
        return clientFactory;
    }

    @NotNull
    public ClientFactory getFactoryFromSettings() {
        ClientFactory clientFactory = this.myConfiguration.isCommandLine() ? this.cmdClientFactory : this.svnKitClientFactory;
        if (clientFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnVcs", "getFactoryFromSettings"));
        }
        return clientFactory;
    }

    @NotNull
    public ClientFactory getOtherFactory() {
        ClientFactory clientFactory = this.myConfiguration.isCommandLine() ? this.svnKitClientFactory : this.cmdClientFactory;
        if (clientFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnVcs", "getOtherFactory"));
        }
        return clientFactory;
    }

    @NotNull
    public ClientFactory getOtherFactory(@NotNull ClientFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "org/jetbrains/idea/svn/SvnVcs", "getOtherFactory"));
        }
        ClientFactory clientFactory = factory.equals(this.cmdClientFactory) ? this.svnKitClientFactory : this.cmdClientFactory;
        if (clientFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnVcs", "getOtherFactory"));
        }
        return clientFactory;
    }

    @NotNull
    public ClientFactory getCommandLineFactory() {
        ClientFactory clientFactory = this.cmdClientFactory;
        if (clientFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnVcs", "getCommandLineFactory"));
        }
        return clientFactory;
    }

    @NotNull
    public ClientFactory getSvnKitFactory() {
        ClientFactory clientFactory = this.svnKitClientFactory;
        if (clientFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnVcs", "getSvnKitFactory"));
        }
        return clientFactory;
    }

    @NotNull
    public WorkingCopyFormat getLowestSupportedFormatForCommandLine() {
        WorkingCopyFormat result;
        try {
            result = WorkingCopyFormat.from(CmdVersionClient.parseVersion(Registry.stringValue((String)"svn.lowest.supported.format.for.command.line")));
        }
        catch (SvnBindException ignore) {
            result = WorkingCopyFormat.ONE_DOT_SEVEN;
        }
        WorkingCopyFormat workingCopyFormat = result;
        if (workingCopyFormat == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/SvnVcs", "getLowestSupportedFormatForCommandLine"));
        }
        return workingCopyFormat;
    }

    public boolean isSupportedByCommandLine(@NotNull WorkingCopyFormat format) {
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "org/jetbrains/idea/svn/SvnVcs", "isSupportedByCommandLine"));
        }
        return format.isOrGreater(this.getLowestSupportedFormatForCommandLine());
    }

    public boolean is16SupportedByCommandLine() {
        return this.isSupportedByCommandLine(WorkingCopyFormat.ONE_DOT_SIX);
    }

    private static class MyFrameStateListener
    extends FrameStateListener.Adapter {
        private final ChangeListManager myClManager;
        private final VcsDirtyScopeManager myDirtyScopeManager;

        private MyFrameStateListener(ChangeListManager clManager, VcsDirtyScopeManager dirtyScopeManager) {
            this.myClManager = clManager;
            this.myDirtyScopeManager = dirtyScopeManager;
        }

        public void onFrameActivated() {
            List folders = ((ChangeListManagerImpl)this.myClManager).getLockedFolders();
            if (!folders.isEmpty()) {
                this.myDirtyScopeManager.filesDirty(null, (Collection)folders);
            }
        }
    }

    private static class MyPair<T>
    implements RootUrlPair {
        private final VirtualFile myFile;
        private final String myUrl;
        private final T mySrc;

        private MyPair(VirtualFile file, String url, T src) {
            this.myFile = file;
            this.myUrl = url;
            this.mySrc = src;
        }

        public T getSrc() {
            return this.mySrc;
        }

        @Override
        public VirtualFile getVirtualFile() {
            return this.myFile;
        }

        @Override
        public String getUrl() {
            return this.myUrl;
        }
    }
}

