/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils.library;

import com.intellij.CommonBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.NewLibraryConfiguration;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.execution.SoutMavenConsole;
import org.jetbrains.idea.maven.importing.MavenExtraArtifactType;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenArtifactInfo;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenRemoteRepository;
import org.jetbrains.idea.maven.model.MavenRepositoryInfo;
import org.jetbrains.idea.maven.project.MavenEmbeddersManager;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.server.MavenEmbedderWrapper;
import org.jetbrains.idea.maven.services.MavenRepositoryServicesManager;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;
import org.jetbrains.idea.maven.utils.MavenProgressIndicator;
import org.jetbrains.idea.maven.utils.RepositoryAttachDialog;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryType;

public class RepositoryAttachHandler {
    @Nullable
    public static NewLibraryConfiguration chooseLibraryAndDownload(@NotNull Project project, @Nullable String initialFilter, JComponent parentComponent) {
        List<MavenRepositoryInfo> repositories;
        boolean attachSources;
        boolean attachJavaDoc;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/maven/utils/library/RepositoryAttachHandler", "chooseLibraryAndDownload"));
        }
        RepositoryAttachDialog dialog = new RepositoryAttachDialog(project, initialFilter);
        dialog.setTitle("Download Library From Maven Repository");
        dialog.show();
        if (dialog.getExitCode() != 0) {
            return null;
        }
        String copyTo = dialog.getDirectoryPath();
        String coord = dialog.getCoordinateText();
        NewLibraryConfiguration configuration = RepositoryAttachHandler.resolveAndDownload(project, coord, attachJavaDoc = dialog.getAttachJavaDoc(), attachSources = dialog.getAttachSources(), copyTo, repositories = dialog.getRepositories());
        if (configuration == null) {
            Messages.showErrorDialog((Component)parentComponent, (String)("No files were downloaded for " + coord), (String)CommonBundle.getErrorTitle());
        }
        return configuration;
    }

    public static NewLibraryConfiguration resolveAndDownload(final Project project, final String coord, boolean attachJavaDoc, boolean attachSources, final @Nullable String copyTo, List<MavenRepositoryInfo> repositories) {
        SmartList extraTypes = new SmartList();
        if (attachSources) {
            extraTypes.add((Object)MavenExtraArtifactType.SOURCES);
        }
        if (attachJavaDoc) {
            extraTypes.add((Object)MavenExtraArtifactType.DOCS);
        }
        final Ref result = Ref.create(null);
        RepositoryAttachHandler.resolveLibrary(project, coord, (List<MavenExtraArtifactType>)extraTypes, repositories, new Processor<List<MavenArtifact>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean process(List<MavenArtifact> artifacts) {
                if (!artifacts.isEmpty()) {
                    AccessToken accessToken = WriteAction.start();
                    try {
                        final List<OrderRoot> roots = RepositoryAttachHandler.createRoots(artifacts, copyTo);
                        result.set((Object)new NewLibraryConfiguration(coord, RepositoryLibraryType.getInstance(), new RepositoryLibraryProperties(coord)){

                            public void addRoots(@NotNull LibraryEditor editor) {
                                if (editor == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/idea/maven/utils/library/RepositoryAttachHandler$1$1", "addRoots"));
                                }
                                editor.addRoots((Collection)roots);
                            }
                        });
                    }
                    finally {
                        accessToken.finish();
                    }
                    RepositoryAttachHandler.notifyArtifactsDownloaded(project, artifacts);
                }
                return true;
            }
        });
        return (NewLibraryConfiguration)result.get();
    }

    public static void notifyArtifactsDownloaded(Project project, List<MavenArtifact> artifacts) {
        StringBuilder sb = new StringBuilder();
        String title = "The following files were downloaded:";
        sb.append("<ol>");
        for (MavenArtifact each : artifacts) {
            sb.append("<li>");
            sb.append(each.getFile().getName());
            String scope = each.getScope();
            if (scope != null) {
                sb.append(" (");
                sb.append(scope);
                sb.append(")");
            }
            sb.append("</li>");
        }
        sb.append("</ol>");
        Notifications.Bus.notify((Notification)new Notification("Repository", "The following files were downloaded:", sb.toString(), NotificationType.INFORMATION), (Project)project);
    }

    public static List<OrderRoot> createRoots(@NotNull Collection<MavenArtifact> artifacts, @Nullable String copyTo) {
        if (artifacts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifacts", "org/jetbrains/idea/maven/utils/library/RepositoryAttachHandler", "createRoots"));
        }
        ArrayList<OrderRoot> result = new ArrayList<OrderRoot>();
        VirtualFileManager manager = VirtualFileManager.getInstance();
        for (MavenArtifact each : artifacts) {
            try {
                File repoFile;
                File toFile = repoFile = each.getFile();
                if (copyTo != null) {
                    toFile = new File(copyTo, repoFile.getName());
                    if (repoFile.exists()) {
                        FileUtil.copy((File)repoFile, (File)toFile);
                    }
                }
                manager.refreshAndFindFileByUrl(VfsUtilCore.pathToUrl((String)FileUtil.toSystemIndependentName((String)toFile.getPath())));
                String url = VfsUtil.getUrlForLibraryRoot((File)toFile);
                VirtualFile file = manager.refreshAndFindFileByUrl(url);
                if (file == null) continue;
                OrderRootType rootType = MavenExtraArtifactType.DOCS.getDefaultClassifier().equals(each.getClassifier()) ? JavadocOrderRootType.getInstance() : (MavenExtraArtifactType.SOURCES.getDefaultClassifier().equals(each.getClassifier()) ? OrderRootType.SOURCES : OrderRootType.CLASSES);
                result.add(new OrderRoot(file, rootType));
            }
            catch (MalformedURLException e) {
                MavenLog.LOG.warn((Throwable)e);
            }
            catch (IOException e) {
                MavenLog.LOG.warn((Throwable)e);
            }
        }
        return result;
    }

    public static void searchArtifacts(Project project, String coord, final PairProcessor<Collection<Pair<MavenArtifactInfo, MavenRepositoryInfo>>, Boolean> resultProcessor) {
        if (coord == null || coord.length() == 0) {
            return;
        }
        final MavenArtifactInfo template = coord.indexOf(58) == -1 && Character.isUpperCase(coord.charAt(0)) ? new MavenArtifactInfo(null, null, null, "jar", null, coord, null) : new MavenArtifactInfo(RepositoryAttachHandler.getMavenId(coord), "jar", null);
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, "Maven", false){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/idea/maven/utils/library/RepositoryAttachHandler$2", "run"));
                }
                String[] urls = MavenRepositoryServicesManager.getServiceUrls();
                boolean tooManyResults = false;
                AtomicBoolean proceedFlag = new AtomicBoolean(true);
                int length = urls.length;
                for (int i = 0; i < length && proceedFlag.get(); ++i) {
                    Boolean aBoolean;
                    ArrayList<Pair> resultList;
                    block10: {
                        List<MavenArtifactInfo> artifacts;
                        String serviceUrl;
                        block11: {
                            resultList = new ArrayList<Pair>();
                            serviceUrl = urls[i];
                            artifacts = MavenRepositoryServicesManager.findArtifacts(template, serviceUrl);
                            if (artifacts.isEmpty()) break block10;
                            if (proceedFlag.get()) break block11;
                            if (!proceedFlag.get()) break;
                            Boolean aBoolean2 = i == length - 1 ? Boolean.valueOf(tooManyResults) : null;
                            ApplicationManager.getApplication().invokeLater(new Runnable(proceedFlag, resultList, aBoolean2){
                                final /* synthetic */ AtomicBoolean val$proceedFlag;
                                final /* synthetic */ List val$resultList;
                                final /* synthetic */ Boolean val$aBoolean;
                                {
                                    this.val$proceedFlag = atomicBoolean;
                                    this.val$resultList = list;
                                    this.val$aBoolean = bl;
                                }

                                @Override
                                public void run() {
                                    this.val$proceedFlag.set(resultProcessor.process((Object)this.val$resultList, (Object)this.val$aBoolean));
                                }
                            }, new Condition(proceedFlag){
                                final /* synthetic */ AtomicBoolean val$proceedFlag;
                                {
                                    this.val$proceedFlag = atomicBoolean;
                                }

                                public boolean value(Object o) {
                                    return !this.val$proceedFlag.get();
                                }
                            });
                            break;
                        }
                        try {
                            List<MavenRepositoryInfo> repositories = MavenRepositoryServicesManager.getRepositories(serviceUrl);
                            THashMap map = new THashMap();
                            for (MavenRepositoryInfo repository : repositories) {
                                map.put(repository.getId(), repository);
                            }
                            for (MavenArtifactInfo artifact : artifacts) {
                                if (artifact == null) {
                                    tooManyResults = true;
                                    continue;
                                }
                                MavenRepositoryInfo repository = (MavenRepositoryInfo)map.get(artifact.getRepositoryId());
                                if (repository == null) continue;
                                resultList.add(Pair.create((Object)artifact, (Object)repository));
                            }
                        }
                        catch (Exception e) {
                            try {
                                MavenLog.LOG.error((Throwable)e);
                                if (!proceedFlag.get()) break;
                                aBoolean = i == length - 1 ? Boolean.valueOf(tooManyResults) : null;
                            }
                            catch (Throwable throwable) {
                                if (!proceedFlag.get()) break;
                                Boolean aBoolean3 = i == length - 1 ? Boolean.valueOf(tooManyResults) : null;
                                ApplicationManager.getApplication().invokeLater(new /* invalid duplicate definition of identical inner class */, new /* invalid duplicate definition of identical inner class */);
                                throw throwable;
                            }
                            ApplicationManager.getApplication().invokeLater(new /* invalid duplicate definition of identical inner class */, new /* invalid duplicate definition of identical inner class */);
                            continue;
                        }
                    }
                    if (!proceedFlag.get()) break;
                    aBoolean = i == length - 1 ? Boolean.valueOf(tooManyResults) : null;
                    ApplicationManager.getApplication().invokeLater(new /* invalid duplicate definition of identical inner class */, new /* invalid duplicate definition of identical inner class */);
                    continue;
                }
            }
        });
    }

    public static void searchRepositories(Project project, final Collection<String> nexusUrls, final Processor<Collection<MavenRepositoryInfo>> resultProcessor) {
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, "Maven", false){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/idea/maven/utils/library/RepositoryAttachHandler$3", "run"));
                }
                Ref result = Ref.create(Collections.emptyList());
                try {
                    ArrayList<MavenRepositoryInfo> repoList = new ArrayList<MavenRepositoryInfo>();
                    for (String nexusUrl : nexusUrls) {
                        List<MavenRepositoryInfo> repositories;
                        try {
                            repositories = MavenRepositoryServicesManager.getRepositories(nexusUrl);
                        }
                        catch (Exception ex) {
                            MavenLog.LOG.warn("Accessing Service at: " + nexusUrl, (Throwable)ex);
                            continue;
                        }
                        repoList.addAll(repositories);
                    }
                    result.set(repoList);
                }
                catch (Exception e) {
                    try {
                        MavenLog.LOG.error((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        ApplicationManager.getApplication().invokeLater(new Runnable(result){
                            final /* synthetic */ Ref val$result;
                            {
                                this.val$result = ref;
                            }

                            @Override
                            public void run() {
                                resultProcessor.process(this.val$result.get());
                            }
                        });
                        throw throwable;
                    }
                    ApplicationManager.getApplication().invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
                ApplicationManager.getApplication().invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        });
    }

    private static void resolveLibrary(final Project project, String coord, final List<MavenExtraArtifactType> extraTypes, final Collection<MavenRepositoryInfo> repositories, final Processor<List<MavenArtifact>> resultProcessor) {
        final MavenId mavenId = RepositoryAttachHandler.getMavenId(coord);
        Task.Modal task = new Task.Modal(project, "Maven", false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/idea/maven/utils/library/RepositoryAttachHandler$4", "run"));
                }
                RepositoryAttachHandler.doResolveInner(project, mavenId, (List<MavenExtraArtifactType>)extraTypes, (Collection<MavenRepositoryInfo>)repositories, (Processor<List<MavenArtifact>>)resultProcessor, indicator);
            }
        };
        ProgressManager.getInstance().run((Task)task);
    }

    private static void doResolveInner(Project project, MavenId mavenId, List<MavenExtraArtifactType> extraTypes, Collection<MavenRepositoryInfo> repositories, Processor<List<MavenArtifact>> resultProcessor, ProgressIndicator indicator) {
        RepositoryAttachHandler.doResolveInner(project, Collections.singletonList(mavenId), extraTypes, repositories, resultProcessor, indicator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void doResolveInner(Project project, List<MavenId> mavenIds, List<MavenExtraArtifactType> extraTypes, Collection<MavenRepositoryInfo> repositories, Processor<List<MavenArtifact>> resultProcessor, ProgressIndicator indicator) {
        boolean cancelled = false;
        LinkedHashSet<MavenArtifact> result = new LinkedHashSet<MavenArtifact>();
        MavenEmbeddersManager manager = MavenProjectsManager.getInstance(project).getEmbeddersManager();
        MavenEmbedderWrapper embedder = manager.getEmbedder(MavenEmbeddersManager.FOR_DOWNLOAD);
        try {
            embedder.customizeForResolve(new SoutMavenConsole(), new MavenProgressIndicator(indicator));
            List<MavenRemoteRepository> remoteRepositories = RepositoryAttachHandler.convertRepositories(repositories);
            ArrayList<MavenArtifactInfo> artifacts = new ArrayList<MavenArtifactInfo>(mavenIds.size());
            for (MavenId id : mavenIds) {
                artifacts.add(new MavenArtifactInfo(id, "jar", null));
            }
            List<MavenArtifact> firstResult = embedder.resolveTransitively(artifacts, remoteRepositories);
            for (MavenArtifact artifact : firstResult) {
                if (!artifact.isResolved() || "test".equals(artifact.getScope())) continue;
                result.add(artifact);
            }
            if (!extraTypes.isEmpty()) {
                THashSet allowedClassifiers = new THashSet();
                LinkedHashSet<MavenArtifactInfo> resolve = new LinkedHashSet<MavenArtifactInfo>();
                for (MavenExtraArtifactType extraType : extraTypes) {
                    allowedClassifiers.add(extraType.getDefaultClassifier());
                    for (MavenId id : mavenIds) {
                        resolve.add(new MavenArtifactInfo(id, extraType.getDefaultExtension(), extraType.getDefaultClassifier()));
                    }
                }
                for (MavenArtifact artifact : embedder.resolveTransitively(new ArrayList<MavenArtifactInfo>(resolve), remoteRepositories)) {
                    if (!artifact.isResolved() || "test".equals(artifact.getScope()) || !allowedClassifiers.contains(artifact.getClassifier())) continue;
                    result.add(artifact);
                }
            }
            manager.release(embedder);
            if (cancelled) return;
        }
        catch (MavenProcessCanceledException e) {
            try {
                cancelled = true;
                manager.release(embedder);
                if (cancelled) return;
            }
            catch (Throwable throwable) {
                manager.release(embedder);
                if (cancelled) throw throwable;
                ApplicationManager.getApplication().invokeAndWait(new Runnable(resultProcessor, result){
                    final /* synthetic */ Processor val$resultProcessor;
                    final /* synthetic */ Collection val$result;
                    {
                        this.val$resultProcessor = processor;
                        this.val$result = collection;
                    }

                    @Override
                    public void run() {
                        this.val$resultProcessor.process(new ArrayList(this.val$result));
                    }
                }, indicator.getModalityState());
                throw throwable;
            }
            ApplicationManager.getApplication().invokeAndWait(new /* invalid duplicate definition of identical inner class */, indicator.getModalityState());
            return;
        }
        ApplicationManager.getApplication().invokeAndWait(new /* invalid duplicate definition of identical inner class */, indicator.getModalityState());
        return;
    }

    private static List<MavenRemoteRepository> convertRepositories(Collection<MavenRepositoryInfo> infos) {
        ArrayList<MavenRemoteRepository> result = new ArrayList<MavenRemoteRepository>(infos.size());
        for (MavenRepositoryInfo each : infos) {
            if (each.getUrl() == null) continue;
            result.add(new MavenRemoteRepository(each.getId(), each.getName(), each.getUrl(), null, null, null));
        }
        return result;
    }

    public static MavenId getMavenId(@NotNull String coord) {
        if (coord == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "coord", "org/jetbrains/idea/maven/utils/library/RepositoryAttachHandler", "getMavenId"));
        }
        String[] parts = coord.split(":");
        return new MavenId(parts.length > 0 ? parts[0] : null, parts.length > 1 ? parts[1] : null, parts.length > 2 ? parts[2] : null);
    }
}

