/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks;

import com.intellij.tasks.TaskState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomTaskState {
    private String myId;
    private String myPresentableName;
    private boolean myPredefined;

    public CustomTaskState() {
        this.myId = "";
        this.myPresentableName = "";
    }

    public CustomTaskState(@NotNull String id, @NotNull String name) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/tasks/CustomTaskState", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/tasks/CustomTaskState", "<init>"));
        }
        this.myId = "";
        this.myPresentableName = "";
        this.myId = id;
        this.myPresentableName = name;
    }

    @NotNull
    public String getId() {
        String string = this.myId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/CustomTaskState", "getId"));
        }
        return string;
    }

    public void setId(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/tasks/CustomTaskState", "setId"));
        }
        this.myId = id;
    }

    @NotNull
    public String getPresentableName() {
        String string = this.myPresentableName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/CustomTaskState", "getPresentableName"));
        }
        return string;
    }

    public void setPresentableName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/tasks/CustomTaskState", "setPresentableName"));
        }
        this.myPresentableName = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CustomTaskState)) {
            return false;
        }
        CustomTaskState state = (CustomTaskState)o;
        return this.myId.equals(state.myId);
    }

    public int hashCode() {
        return this.myId.hashCode();
    }

    @NotNull
    public static CustomTaskState fromPredefined(@NotNull TaskState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/tasks/CustomTaskState", "fromPredefined"));
        }
        CustomTaskState result = new CustomTaskState(state.name(), state.getPresentableName());
        result.setPredefined(true);
        CustomTaskState customTaskState = result;
        if (customTaskState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/CustomTaskState", "fromPredefined"));
        }
        return customTaskState;
    }

    @Nullable
    public TaskState asPredefined() {
        if (this.isPredefined()) {
            try {
                return TaskState.valueOf(this.getId());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    private boolean isPredefined() {
        return this.myPredefined;
    }

    public void setPredefined(boolean predefined) {
        this.myPredefined = predefined;
    }

    public String toString() {
        return "CustomTaskState(id='" + this.myId + '\'' + ", name='" + this.myPresentableName + '\'' + ", predefined=" + this.myPredefined + ')';
    }
}

