/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.navigation;

import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.State;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.editors.navigation.Transform;
import com.android.tools.idea.editors.navigation.Utilities;
import com.android.tools.idea.editors.navigation.model.ModelDimension;
import com.intellij.openapi.project.Project;
import java.awt.Dimension;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class RenderingParameters {
    @NotNull
    public final Project project;
    @NotNull
    public final AndroidFacet facet;
    @NotNull
    public final Configuration configuration;

    public RenderingParameters(@NotNull AndroidFacet facet, @NotNull Configuration configuration) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/editors/navigation/RenderingParameters", "<init>"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/editors/navigation/RenderingParameters", "<init>"));
        }
        this.project = facet.getModule().getProject();
        this.facet = facet;
        this.configuration = configuration;
    }

    public RenderingParameters withConfiguration(Configuration configuration) {
        return new RenderingParameters(this.facet, configuration);
    }

    ModelDimension getDeviceScreenSize() {
        return ModelDimension.create(this.getDeviceScreenSize1());
    }

    private Dimension getDeviceScreenSize1() {
        Device device = this.configuration.getDevice();
        if (device == null) {
            return Utilities.ZERO_SIZE;
        }
        State deviceState = this.configuration.getDeviceState();
        if (deviceState == null) {
            deviceState = device.getDefaultState();
        }
        return Utilities.notNull(device.getScreenSize(deviceState.getOrientation()));
    }

    Dimension getDeviceScreenSizeFor(Transform transform) {
        return transform.modelToView(this.getDeviceScreenSize());
    }
}

