/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jdesktop.swingx.JXLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChooseSdkPathDialog
extends DialogWrapper {
    public static final int USE_IDE_SDK_PATH = 3;
    public static final int USE_PROJECT_SDK_PATH = 4;
    private JPanel myPanel;
    private JXLabel myDescriptionLabel;

    public ChooseSdkPathDialog(@NotNull File ideSdkPath, @NotNull File localPropertiesSdkPath) {
        if (ideSdkPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideSdkPath", "com/android/tools/idea/gradle/project/ChooseSdkPathDialog", "<init>"));
        }
        if (localPropertiesSdkPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localPropertiesSdkPath", "com/android/tools/idea/gradle/project/ChooseSdkPathDialog", "<init>"));
        }
        super(null);
        this.$$$setupUI$$$();
        this.setTitle("Android SDK Manager");
        this.setCrossClosesWindow(false);
        String description = String.format("The project and Android Studio point to different Android SDKs.\n\nAndroid Studio's default SDK is in:\n%1$s\n\nThe project's SDK (specified in local.properties) is in:\n%2$s\n\nTo keep results consistent between IDE and command line builds, only one path can be used. Do you want to:\n\n[1] Use Android Studio's default SDK (modifies the project's local.properties file.)\n\n[2] Use the project's SDK (modifies Android Studio's default.)\n\nNote that switching SDKs could cause compile errors if the selected SDK doesn't have the necessary Android platforms or build tools.", ideSdkPath.getPath(), localPropertiesSdkPath.getPath());
        this.myDescriptionLabel.setText(description);
        this.init();
        this.getPeer().getWindow().pack();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{new UseIdeSdkPathAction(), new UseProjectSdkPathAction()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/ChooseSdkPathDialog", "createActions"));
        }
        return actionArray;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JXLabel jXLabel;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myDescriptionLabel = jXLabel = new JXLabel();
        jXLabel.setText("");
        jXLabel.setLineWrap(true);
        jPanel.add((Component)jXLabel, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 3, null, new Dimension(500, 250), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private class UseProjectSdkPathAction
    extends DialogWrapper.DialogWrapperAction {
        protected UseProjectSdkPathAction() {
            super((DialogWrapper)ChooseSdkPathDialog.this, "Use Project's SDK");
        }

        protected void doAction(ActionEvent e) {
            ChooseSdkPathDialog.this.close(4);
        }
    }

    private class UseIdeSdkPathAction
    extends DialogWrapper.DialogWrapperAction {
        protected UseIdeSdkPathAction() {
            super((DialogWrapper)ChooseSdkPathDialog.this, "Use Android Studio's SDK");
        }

        protected void doAction(ActionEvent e) {
            ChooseSdkPathDialog.this.close(3);
        }
    }
}

