/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.junit3;

import com.intellij.junit3.JUnit3OutputObjectRegistry;
import com.intellij.junit3.TestResultsSender;
import com.intellij.junit3.TestRunnerUtil;
import com.intellij.rt.execution.junit.DeafStream;
import com.intellij.rt.execution.junit.IDEAJUnitListener;
import com.intellij.rt.execution.junit.IdeaTestRunner;
import com.intellij.rt.execution.junit.TimeSender;
import com.intellij.rt.execution.junit.TreeSender;
import com.intellij.rt.execution.junit.segments.OutputObjectRegistry;
import com.intellij.rt.execution.junit.segments.PacketProcessor;
import com.intellij.rt.execution.junit.segments.SegmentedOutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestListener;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import junit.textui.ResultPrinter;
import junit.textui.TestRunner;

public class JUnit3IdeaTestRunner
extends TestRunner
implements IdeaTestRunner {
    private TestListener myTestsListener;
    private JUnit3OutputObjectRegistry myRegistry;
    private ArrayList myListeners;
    private boolean mySendTree;

    public JUnit3IdeaTestRunner() {
        super(DeafStream.DEAF_PRINT_STREAM);
    }

    public int startRunnerWithArgs(String[] args, ArrayList listeners, String name, boolean sendTree) {
        this.myListeners = listeners;
        this.mySendTree = sendTree;
        if (sendTree) {
            this.setPrinter(new TimeSender(this.myRegistry));
        } else {
            this.setPrinter(new MockResultPrinter());
        }
        try {
            Test suite = TestRunnerUtil.getTestSuite(this, args);
            if (suite == null) {
                return -1;
            }
            TestResult result = this.doRun(suite);
            if (!result.wasSuccessful()) {
                return -1;
            }
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return -2;
        }
    }

    public void clearStatus() {
        super.clearStatus();
    }

    public void runFailed(String message) {
        super.runFailed(message);
    }

    public void setStreams(SegmentedOutputStream segmentedOut, SegmentedOutputStream segmentedErr, int lastIdx) {
        this.myRegistry = new JUnit3OutputObjectRegistry((PacketProcessor)segmentedOut, lastIdx);
        this.myTestsListener = new TestResultsSender(this.myRegistry);
    }

    public Object getTestToStart(String[] args, String name) {
        return TestRunnerUtil.getTestSuite(this, args);
    }

    public List getChildTests(Object description) {
        return JUnit3IdeaTestRunner.getTestCasesOf((Test)description);
    }

    public OutputObjectRegistry getRegistry() {
        return this.myRegistry;
    }

    public String getTestClassName(Object child) {
        return child instanceof TestSuite ? ((TestSuite)child).getName() : child.getClass().getName();
    }

    public String getStartDescription(Object child) {
        Test test = (Test)child;
        if (test instanceof TestCase) {
            return test.getClass().getName() + "," + ((TestCase)test).getName();
        }
        return test.toString();
    }

    protected TestResult createTestResult() {
        TestResult testResult = super.createTestResult();
        testResult.addListener(this.myTestsListener);
        try {
            for (int i = 0; i < this.myListeners.size(); ++i) {
                final IDEAJUnitListener junitListener = (IDEAJUnitListener)Class.forName((String)this.myListeners.get(i)).newInstance();
                testResult.addListener(new TestListener(){

                    public void addError(Test test, Throwable t) {
                    }

                    public void addFailure(Test test, AssertionFailedError t) {
                    }

                    public void endTest(Test test) {
                        if (test instanceof TestCase) {
                            junitListener.testFinished(test.getClass().getName(), ((TestCase)test).getName());
                        }
                    }

                    public void startTest(Test test) {
                        if (test instanceof TestCase) {
                            junitListener.testStarted(test.getClass().getName(), ((TestCase)test).getName());
                        }
                    }
                });
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return testResult;
    }

    public TestResult doRun(Test suite, boolean wait) {
        try {
            TreeSender.sendTree(this, suite, this.mySendTree);
        }
        catch (Exception e) {
            System.err.println("Internal Error occured.");
            e.printStackTrace(System.err);
        }
        return super.doRun(suite, wait);
    }

    static Vector getTestCasesOf(Test test) {
        Vector testCases = new Vector();
        if (test instanceof TestRunnerUtil.SuiteMethodWrapper) {
            test = ((TestRunnerUtil.SuiteMethodWrapper)test).getSuite();
        }
        if (test instanceof TestSuite) {
            TestSuite testSuite = (TestSuite)test;
            Enumeration each = testSuite.tests();
            while (each.hasMoreElements()) {
                Object childTest = each.nextElement();
                if (childTest instanceof TestSuite && !((TestSuite)childTest).tests().hasMoreElements()) continue;
                testCases.addElement(childTest);
            }
        }
        return testCases;
    }

    public static class MockResultPrinter
    extends ResultPrinter {
        public MockResultPrinter() {
            super(DeafStream.DEAF_PRINT_STREAM);
        }
    }
}

