/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ThrowableConvertor;
import git4idea.GitPlatformFacade;
import git4idea.GitUtil;
import git4idea.actions.BasicAction;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitHandler;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitLocalChangesWouldBeOverwrittenDetector;
import git4idea.commands.GitMessageWithFilesDetector;
import git4idea.commands.GitProgressAnalyzer;
import git4idea.commands.GitStandardProgressAnalyzer;
import git4idea.commands.GitTask;
import git4idea.commands.GitTaskResultHandler;
import git4idea.commands.GitTaskResultHandlerAdapter;
import git4idea.commands.GitUntrackedFilesOverwrittenByOperationDetector;
import git4idea.rebase.GitRebaseProblemDetector;
import git4idea.rebase.GitRebaser;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.update.GitFetchResult;
import git4idea.update.GitFetcher;
import git4idea.update.GitUpdateResult;
import git4idea.util.GitPreservingProcess;
import icons.GithubIcons;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubApiUtil;
import org.jetbrains.plugins.github.api.GithubConnection;
import org.jetbrains.plugins.github.api.GithubFullPath;
import org.jetbrains.plugins.github.api.GithubRepoDetailed;
import org.jetbrains.plugins.github.util.GithubAuthDataHolder;
import org.jetbrains.plugins.github.util.GithubNotifications;
import org.jetbrains.plugins.github.util.GithubSettings;
import org.jetbrains.plugins.github.util.GithubUrlUtil;
import org.jetbrains.plugins.github.util.GithubUtil;

public class GithubRebaseAction
extends DumbAwareAction {
    private static final Logger LOG = GithubUtil.LOG;
    private static final String CANNOT_PERFORM_GITHUB_REBASE = "Can't perform GitHub rebase";

    public GithubRebaseAction() {
        super("Rebase my GitHub fork", "Rebase your GitHub forked repository relative to the origin", GithubIcons.Github_icon);
    }

    public void update(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (project == null || project.isDefault()) {
            GithubUtil.setVisibleEnabled(e, false, false);
            return;
        }
        GitRepository gitRepository = GithubUtil.getGitRepository(project, file);
        if (gitRepository == null) {
            GithubUtil.setVisibleEnabled(e, false, false);
            return;
        }
        if (!GithubUtil.isRepositoryOnGitHub(gitRepository)) {
            GithubUtil.setVisibleEnabled(e, false, false);
            return;
        }
        GithubUtil.setVisibleEnabled(e, true, true);
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (project == null || project.isDisposed() || !GithubUtil.testGitExecutable(project)) {
            return;
        }
        GithubRebaseAction.rebaseMyGithubFork(project, file);
    }

    private static void rebaseMyGithubFork(final @NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/github/GithubRebaseAction", "rebaseMyGithubFork"));
        }
        final GitRepository gitRepository = GithubUtil.getGitRepository(project, file);
        if (gitRepository == null) {
            GithubNotifications.showError(project, CANNOT_PERFORM_GITHUB_REBASE, "Can't find git repository");
            return;
        }
        BasicAction.saveAll();
        new Task.Backgroundable(project, "Rebasing GitHub fork..."){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/github/GithubRebaseAction$1", "run"));
                }
                gitRepository.update();
                String upstreamRemoteUrl = GithubUtil.findUpstreamRemote(gitRepository);
                if (upstreamRemoteUrl == null) {
                    LOG.info("Configuring upstream remote");
                    indicator.setText("Configuring upstream remote...");
                    upstreamRemoteUrl = GithubRebaseAction.configureUpstreamRemote(project, gitRepository, indicator);
                    if (upstreamRemoteUrl == null) {
                        return;
                    }
                }
                if (!GithubUrlUtil.isGithubUrl(upstreamRemoteUrl)) {
                    GithubNotifications.showError(project, GithubRebaseAction.CANNOT_PERFORM_GITHUB_REBASE, "Configured upstream is not a GitHub repository: " + upstreamRemoteUrl);
                    return;
                }
                GithubFullPath userAndRepo = GithubUrlUtil.getUserAndRepositoryFromRemoteUrl(upstreamRemoteUrl);
                String login = GithubSettings.getInstance().getLogin();
                if (userAndRepo != null && userAndRepo.getUser().equals(login)) {
                    GithubNotifications.showError(project, GithubRebaseAction.CANNOT_PERFORM_GITHUB_REBASE, "Configured upstream seems to be your own repository: " + upstreamRemoteUrl);
                    return;
                }
                LOG.info("Fetching upstream");
                indicator.setText("Fetching upstream...");
                if (!GithubRebaseAction.fetchParent(project, gitRepository, indicator)) {
                    return;
                }
                LOG.info("Rebasing current branch");
                indicator.setText("Rebasing current branch...");
                GithubRebaseAction.rebaseCurrentBranch(project, gitRepository, indicator);
            }
        }.queue();
    }

    @Nullable
    static String configureUpstreamRemote(@NotNull Project project, @NotNull GitRepository gitRepository, @NotNull ProgressIndicator indicator) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/github/GithubRebaseAction", "configureUpstreamRemote"));
        }
        if (gitRepository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gitRepository", "org/jetbrains/plugins/github/GithubRebaseAction", "configureUpstreamRemote"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/github/GithubRebaseAction", "configureUpstreamRemote"));
        }
        GithubRepoDetailed repositoryInfo = GithubRebaseAction.loadRepositoryInfo(project, gitRepository, indicator);
        if (repositoryInfo == null) {
            return null;
        }
        if (!repositoryInfo.isFork() || repositoryInfo.getParent() == null) {
            GithubNotifications.showWarningURL(project, CANNOT_PERFORM_GITHUB_REBASE, "GitHub repository ", "'" + repositoryInfo.getName() + "'", " is not a fork", repositoryInfo.getHtmlUrl());
            return null;
        }
        String parentRepoUrl = GithubUrlUtil.getCloneUrl(repositoryInfo.getParent().getFullPath());
        LOG.info("Adding GitHub parent as a remote host");
        indicator.setText("Adding GitHub parent as a remote host...");
        if (GithubUtil.addGithubRemote(project, gitRepository, "upstream", parentRepoUrl)) {
            return parentRepoUrl;
        }
        return null;
    }

    @Nullable
    private static GithubRepoDetailed loadRepositoryInfo(@NotNull Project project, @NotNull GitRepository gitRepository, @NotNull ProgressIndicator indicator) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/github/GithubRebaseAction", "loadRepositoryInfo"));
        }
        if (gitRepository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gitRepository", "org/jetbrains/plugins/github/GithubRebaseAction", "loadRepositoryInfo"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/github/GithubRebaseAction", "loadRepositoryInfo"));
        }
        String remoteUrl = GithubUtil.findGithubRemoteUrl(gitRepository);
        if (remoteUrl == null) {
            GithubNotifications.showError(project, CANNOT_PERFORM_GITHUB_REBASE, "Can't find GitHub remote");
            return null;
        }
        final GithubFullPath userAndRepo = GithubUrlUtil.getUserAndRepositoryFromRemoteUrl(remoteUrl);
        if (userAndRepo == null) {
            GithubNotifications.showError(project, CANNOT_PERFORM_GITHUB_REBASE, "Can't process remote: " + remoteUrl);
            return null;
        }
        try {
            return GithubUtil.runTask(project, GithubAuthDataHolder.createFromSettings(), indicator, new ThrowableConvertor<GithubConnection, GithubRepoDetailed, IOException>(){

                @NotNull
                public GithubRepoDetailed convert(@NotNull GithubConnection connection) throws IOException {
                    if (connection == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "org/jetbrains/plugins/github/GithubRebaseAction$2", "convert"));
                    }
                    GithubRepoDetailed githubRepoDetailed = GithubApiUtil.getDetailedRepoInfo(connection, userAndRepo.getUser(), userAndRepo.getRepository());
                    if (githubRepoDetailed == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/GithubRebaseAction$2", "convert"));
                    }
                    return githubRepoDetailed;
                }
            });
        }
        catch (IOException e) {
            GithubNotifications.showError(project, "Can't load repository info", e);
            return null;
        }
    }

    private static boolean fetchParent(@NotNull Project project, @NotNull GitRepository repository, @NotNull ProgressIndicator indicator) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/github/GithubRebaseAction", "fetchParent"));
        }
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "org/jetbrains/plugins/github/GithubRebaseAction", "fetchParent"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/github/GithubRebaseAction", "fetchParent"));
        }
        GitFetchResult result = new GitFetcher(project, indicator, false).fetch(repository.getRoot(), "upstream", null);
        if (!result.isSuccess()) {
            GitFetcher.displayFetchResult((Project)project, (GitFetchResult)result, null, (Collection)result.getErrors());
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void rebaseCurrentBranch(final @NotNull Project project, final @NotNull GitRepository gitRepository, final @NotNull ProgressIndicator indicator) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/github/GithubRebaseAction", "rebaseCurrentBranch"));
        }
        if (gitRepository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gitRepository", "org/jetbrains/plugins/github/GithubRebaseAction", "rebaseCurrentBranch"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/github/GithubRebaseAction", "rebaseCurrentBranch"));
        }
        Git git = (Git)ServiceManager.getService((Project)project, Git.class);
        GitPlatformFacade facade = (GitPlatformFacade)ServiceManager.getService((Project)project, GitPlatformFacade.class);
        AccessToken token = DvcsUtil.workingTreeChangeStarted((Project)project);
        try {
            GitPreservingProcess process = new GitPreservingProcess(project, facade, git, Collections.singletonList(gitRepository), "Rebasing", "upstream/master", indicator, new Runnable(){

                @Override
                public void run() {
                    GithubRebaseAction.doRebaseCurrentBranch(project, gitRepository.getRoot(), indicator);
                }
            });
            process.execute();
        }
        finally {
            DvcsUtil.workingTreeChangeFinished((Project)project, (AccessToken)token);
        }
    }

    private static void doRebaseCurrentBranch(final @NotNull Project project, final @NotNull VirtualFile root, @NotNull ProgressIndicator indicator) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/github/GithubRebaseAction", "doRebaseCurrentBranch"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/plugins/github/GithubRebaseAction", "doRebaseCurrentBranch"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/github/GithubRebaseAction", "doRebaseCurrentBranch"));
        }
        final GitRepositoryManager repositoryManager = GitUtil.getRepositoryManager((Project)project);
        final GitRebaser rebaser = new GitRebaser(project, (Git)ServiceManager.getService(Git.class), indicator);
        final GitLineHandler handler = new GitLineHandler(project, root, GitCommand.REBASE);
        handler.setStdoutSuppressed(false);
        handler.addParameters(new String[]{"upstream/master"});
        final GitRebaseProblemDetector rebaseConflictDetector = new GitRebaseProblemDetector();
        handler.addLineListener((GitLineHandlerListener)rebaseConflictDetector);
        final GitUntrackedFilesOverwrittenByOperationDetector untrackedFilesDetector = new GitUntrackedFilesOverwrittenByOperationDetector(root);
        final GitLocalChangesWouldBeOverwrittenDetector localChangesDetector = new GitLocalChangesWouldBeOverwrittenDetector(root, GitLocalChangesWouldBeOverwrittenDetector.Operation.CHECKOUT);
        handler.addLineListener((GitLineHandlerListener)untrackedFilesDetector);
        handler.addLineListener((GitLineHandlerListener)localChangesDetector);
        GitTask pullTask = new GitTask(project, (GitHandler)handler, "Rebasing from upstream/master");
        pullTask.setProgressIndicator(indicator);
        pullTask.setProgressAnalyzer((GitProgressAnalyzer)new GitStandardProgressAnalyzer());
        pullTask.execute(true, false, (GitTaskResultHandler)new GitTaskResultHandlerAdapter(){

            protected void onSuccess() {
                root.refresh(false, true);
                repositoryManager.updateRepository(root);
                GithubNotifications.showInfo(project, "Success", "Successfully rebased GitHub fork");
            }

            protected void onFailure() {
                GitUpdateResult result = rebaser.handleRebaseFailure(handler, root, rebaseConflictDetector, (GitMessageWithFilesDetector)untrackedFilesDetector, localChangesDetector);
                repositoryManager.updateRepository(root);
                if (result == GitUpdateResult.NOTHING_TO_UPDATE || result == GitUpdateResult.SUCCESS || result == GitUpdateResult.SUCCESS_WITH_RESOLVED_CONFLICTS) {
                    GithubNotifications.showInfo(project, "Success", "Successfully rebased GitHub fork");
                }
            }
        });
    }
}

