/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.stats;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.java.decompiler.main.TextBuffer;
import org.jetbrains.java.decompiler.main.collectors.BytecodeMappingTracer;
import org.jetbrains.java.decompiler.modules.decompiler.ExprProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.SequenceHelper;
import org.jetbrains.java.decompiler.modules.decompiler.StatEdge;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;

public class SynchronizedStatement
extends Statement {
    private Statement body;
    private List<Exprent> headexprent = new ArrayList<Exprent>();

    public SynchronizedStatement() {
        this.type = 10;
        this.headexprent.add(null);
    }

    public SynchronizedStatement(Statement head, Statement body, Statement exc) {
        this();
        StatEdge edge;
        this.first = head;
        this.stats.addWithKey(head, head.id);
        this.body = body;
        this.stats.addWithKey(body, body.id);
        this.stats.addWithKey(exc, exc.id);
        List<StatEdge> lstSuccs = body.getSuccessorEdges(0x40000000);
        if (!lstSuccs.isEmpty() && (edge = lstSuccs.get(0)).getType() == 1) {
            this.post = edge.getDestination();
        }
    }

    @Override
    public TextBuffer toJava(int indent, BytecodeMappingTracer tracer) {
        TextBuffer buf = new TextBuffer();
        buf.append(ExprProcessor.listToJava(this.varDefinitions, indent, tracer));
        buf.append(this.first.toJava(indent, tracer));
        if (this.isLabeled()) {
            buf.appendIndent(indent).append("label").append(this.id.toString()).append(":").appendLineSeparator();
            tracer.incrementCurrentSourceLine();
        }
        buf.appendIndent(indent).append(this.headexprent.get(0).toJava(indent, tracer)).append(" {").appendLineSeparator();
        tracer.incrementCurrentSourceLine();
        buf.append(ExprProcessor.jmpWrapper(this.body, indent + 1, true, tracer));
        buf.appendIndent(indent).append("}").appendLineSeparator();
        tracer.incrementCurrentSourceLine();
        return buf;
    }

    @Override
    public void initExprents() {
        this.headexprent.set(0, this.first.getExprents().remove(this.first.getExprents().size() - 1));
    }

    @Override
    public List<Object> getSequentialObjects() {
        ArrayList<Object> lst = new ArrayList<Object>(this.stats);
        lst.add(1, this.headexprent.get(0));
        return lst;
    }

    @Override
    public void replaceExprent(Exprent oldexpr, Exprent newexpr) {
        if (this.headexprent.get(0) == oldexpr) {
            this.headexprent.set(0, newexpr);
        }
    }

    @Override
    public void replaceStatement(Statement oldstat, Statement newstat) {
        if (this.body == oldstat) {
            this.body = newstat;
        }
        super.replaceStatement(oldstat, newstat);
    }

    public void removeExc() {
        Statement exc = (Statement)this.stats.get(2);
        SequenceHelper.destroyStatementContent(exc, true);
        this.stats.removeWithKey(exc.id);
    }

    @Override
    public Statement getSimpleCopy() {
        return new SynchronizedStatement();
    }

    @Override
    public void initSimpleCopy() {
        this.first = (Statement)this.stats.get(0);
        this.body = (Statement)this.stats.get(1);
    }

    public Statement getBody() {
        return this.body;
    }

    public void setBody(Statement body) {
        this.body = body;
    }

    public List<Exprent> getHeadexprentList() {
        return this.headexprent;
    }

    public Exprent getHeadexprent() {
        return this.headexprent.get(0);
    }
}

