/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JDOMExternalizerUtil {
    private static final String VALUE_ATTR_NAME = "value";

    public static void writeField(@NotNull Element root, @NotNull @NonNls String fieldName, String value) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/openapi/util/JDOMExternalizerUtil", "writeField"));
        }
        if (fieldName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "com/intellij/openapi/util/JDOMExternalizerUtil", "writeField"));
        }
        Element element = new Element("option");
        element.setAttribute("name", fieldName);
        element.setAttribute(VALUE_ATTR_NAME, value == null ? "" : value);
        root.addContent(element);
    }

    @NotNull
    public static String readField(@NotNull Element parent, @NotNull @NonNls String fieldName, @NotNull String defaultValue) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/util/JDOMExternalizerUtil", "readField"));
        }
        if (fieldName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "com/intellij/openapi/util/JDOMExternalizerUtil", "readField"));
        }
        if (defaultValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultValue", "com/intellij/openapi/util/JDOMExternalizerUtil", "readField"));
        }
        String val = JDOMExternalizerUtil.readField(parent, fieldName);
        String string = val == null ? defaultValue : val;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/JDOMExternalizerUtil", "readField"));
        }
        return string;
    }

    @Nullable
    public static String readField(@NotNull Element parent, @NotNull @NonNls String fieldName) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/util/JDOMExternalizerUtil", "readField"));
        }
        if (fieldName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "com/intellij/openapi/util/JDOMExternalizerUtil", "readField"));
        }
        for (Element element : JDOMUtil.getChildren(parent, "option")) {
            String childName = element.getAttributeValue("name");
            if (!Comparing.strEqual(childName, fieldName)) continue;
            return element.getAttributeValue(VALUE_ATTR_NAME);
        }
        return null;
    }

    public static Element getOption(@NotNull Element parent, @NotNull @NonNls String fieldName) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/util/JDOMExternalizerUtil", "getOption"));
        }
        if (fieldName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "com/intellij/openapi/util/JDOMExternalizerUtil", "getOption"));
        }
        for (Element element : JDOMUtil.getChildren(parent, "option")) {
            String childName = element.getAttributeValue("name");
            if (!Comparing.strEqual(childName, fieldName)) continue;
            return element;
        }
        return null;
    }

    @NotNull
    public static Element writeOption(@NotNull Element root, @NotNull @NonNls String fieldName) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/openapi/util/JDOMExternalizerUtil", "writeOption"));
        }
        if (fieldName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "com/intellij/openapi/util/JDOMExternalizerUtil", "writeOption"));
        }
        Element element = new Element("option");
        element.setAttribute("name", fieldName);
        root.addContent(element);
        Element element2 = element;
        if (element2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/JDOMExternalizerUtil", "writeOption"));
        }
        return element2;
    }

    @NotNull
    public static Element addElementWithValueAttribute(@NotNull Element parent, @NotNull String childTagName, @Nullable String attrValue) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/util/JDOMExternalizerUtil", "addElementWithValueAttribute"));
        }
        if (childTagName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childTagName", "com/intellij/openapi/util/JDOMExternalizerUtil", "addElementWithValueAttribute"));
        }
        Element element = new Element(childTagName);
        if (attrValue != null) {
            element.setAttribute(VALUE_ATTR_NAME, attrValue);
        }
        parent.addContent(element);
        Element element2 = element;
        if (element2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/JDOMExternalizerUtil", "addElementWithValueAttribute"));
        }
        return element2;
    }

    @Nullable
    public static String getFirstChildValueAttribute(@NotNull Element parent, @NotNull String childTagName) {
        Element first;
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/util/JDOMExternalizerUtil", "getFirstChildValueAttribute"));
        }
        if (childTagName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childTagName", "com/intellij/openapi/util/JDOMExternalizerUtil", "getFirstChildValueAttribute"));
        }
        List children = parent.getChildren(childTagName);
        if (!children.isEmpty() && (first = (Element)children.get(0)) != null) {
            return first.getAttributeValue(VALUE_ATTR_NAME);
        }
        return null;
    }

    @NotNull
    public static List<String> getChildrenValueAttributes(@NotNull Element parent, @NotNull String childTagName) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/util/JDOMExternalizerUtil", "getChildrenValueAttributes"));
        }
        if (childTagName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childTagName", "com/intellij/openapi/util/JDOMExternalizerUtil", "getChildrenValueAttributes"));
        }
        List children = parent.getChildren(childTagName);
        if (children.isEmpty()) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/JDOMExternalizerUtil", "getChildrenValueAttributes"));
            }
            return list;
        }
        if (children.size() == 1) {
            String value = ((Element)children.iterator().next()).getAttributeValue(VALUE_ATTR_NAME);
            List<Object> list = value == null ? Collections.emptyList() : Collections.singletonList(value);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/JDOMExternalizerUtil", "getChildrenValueAttributes"));
            }
            return list;
        }
        ArrayList<String> values = ContainerUtil.newArrayListWithCapacity(children.size());
        for (Element child : children) {
            String value = child.getAttributeValue(VALUE_ATTR_NAME);
            if (value == null) continue;
            values.add(value);
        }
        ArrayList<String> arrayList = values;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/JDOMExternalizerUtil", "getChildrenValueAttributes"));
        }
        return arrayList;
    }

    public static void addChildrenWithValueAttribute(@NotNull Element parent, @NotNull String childTagName, @NotNull List<String> attrValues) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/util/JDOMExternalizerUtil", "addChildrenWithValueAttribute"));
        }
        if (childTagName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childTagName", "com/intellij/openapi/util/JDOMExternalizerUtil", "addChildrenWithValueAttribute"));
        }
        if (attrValues == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attrValues", "com/intellij/openapi/util/JDOMExternalizerUtil", "addChildrenWithValueAttribute"));
        }
        for (String value : attrValues) {
            if (value == null) continue;
            Element child = new Element(childTagName);
            child.setAttribute(VALUE_ATTR_NAME, value);
            parent.addContent(child);
        }
    }
}

