/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.Pair;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Function;
import com.intellij.util.containers.EmptyIterator;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.LinkedHashMap;
import com.intellij.util.containers.LinkedHashSet;
import com.intellij.util.containers.Stack;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContainerUtilRt {
    private static final int ARRAY_COPY_THRESHOLD = 20;

    @NotNull
    @Contract(pure=true)
    public static <K, V> java.util.HashMap<K, V> newHashMap() {
        HashMap hashMap = new HashMap();
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtilRt", "newHashMap"));
        }
        return hashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> java.util.HashMap<K, V> newHashMap(@NotNull Map<K, V> map) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/util/containers/ContainerUtilRt", "newHashMap"));
        }
        HashMap hashMap = new HashMap(map);
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtilRt", "newHashMap"));
        }
        return hashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> Map<K, V> newHashMap(@NotNull List<K> keys, @NotNull List<V> values) {
        if (keys == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keys", "com/intellij/util/containers/ContainerUtilRt", "newHashMap"));
        }
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/util/containers/ContainerUtilRt", "newHashMap"));
        }
        if (keys.size() != values.size()) {
            throw new IllegalArgumentException(keys + " should have same length as " + values);
        }
        java.util.HashMap<K, V> map = ContainerUtilRt.newHashMap();
        for (int i = 0; i < keys.size(); ++i) {
            map.put(keys.get(i), values.get(i));
        }
        java.util.HashMap<K, V> hashMap = map;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtilRt", "newHashMap"));
        }
        return hashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> Map<K, V> newHashMap(@NotNull Pair<K, V> first, @NotNull Pair<K, V>[] entries) {
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/intellij/util/containers/ContainerUtilRt", "newHashMap"));
        }
        if (entries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entries", "com/intellij/util/containers/ContainerUtilRt", "newHashMap"));
        }
        java.util.HashMap<K, V> map = ContainerUtilRt.newHashMap();
        map.put(first.getFirst(), first.getSecond());
        for (Pair<K, V> entry : entries) {
            map.put(entry.getFirst(), entry.getSecond());
        }
        java.util.HashMap<K, V> hashMap = map;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtilRt", "newHashMap"));
        }
        return hashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> Map<K, V> newHashMap(int initialCapacity) {
        HashMap hashMap = new HashMap(initialCapacity);
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtilRt", "newHashMap"));
        }
        return hashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K extends Comparable, V> TreeMap<K, V> newTreeMap() {
        TreeMap treeMap = new TreeMap();
        if (treeMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtilRt", "newTreeMap"));
        }
        return treeMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K extends Comparable, V> TreeMap<K, V> newTreeMap(@NotNull Map<K, V> map) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/util/containers/ContainerUtilRt", "newTreeMap"));
        }
        TreeMap<K, V> treeMap = new TreeMap<K, V>(map);
        if (treeMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtilRt", "newTreeMap"));
        }
        return treeMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> java.util.LinkedHashMap<K, V> newLinkedHashMap() {
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        if (linkedHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtilRt", "newLinkedHashMap"));
        }
        return linkedHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> java.util.LinkedHashMap<K, V> newLinkedHashMap(int capacity) {
        LinkedHashMap linkedHashMap = new LinkedHashMap(capacity);
        if (linkedHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtilRt", "newLinkedHashMap"));
        }
        return linkedHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> java.util.LinkedHashMap<K, V> newLinkedHashMap(@NotNull Map<K, V> map) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/util/containers/ContainerUtilRt", "newLinkedHashMap"));
        }
        LinkedHashMap linkedHashMap = new LinkedHashMap(map);
        if (linkedHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtilRt", "newLinkedHashMap"));
        }
        return linkedHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> java.util.LinkedHashMap<K, V> newLinkedHashMap(@NotNull Pair<K, V> first, @NotNull Pair<K, V>[] entries) {
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/intellij/util/containers/ContainerUtilRt", "newLinkedHashMap"));
        }
        if (entries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entries", "com/intellij/util/containers/ContainerUtilRt", "newLinkedHashMap"));
        }
        java.util.LinkedHashMap<K, V> map = ContainerUtilRt.newLinkedHashMap();
        map.put(first.getFirst(), first.getSecond());
        for (Pair<K, V> entry : entries) {
            map.put(entry.getFirst(), entry.getSecond());
        }
        java.util.LinkedHashMap<K, V> linkedHashMap = map;
        if (linkedHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtilRt", "newLinkedHashMap"));
        }
        return linkedHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> LinkedList<T> newLinkedList() {
        LinkedList linkedList = new LinkedList();
        if (linkedList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtilRt", "newLinkedList"));
        }
        return linkedList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> LinkedList<T> newLinkedList(T ... elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/util/containers/ContainerUtilRt", "newLinkedList"));
        }
        LinkedList<T> list = ContainerUtilRt.newLinkedList();
        Collections.addAll(list, elements);
        LinkedList<T> linkedList = list;
        if (linkedList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtilRt", "newLinkedList"));
        }
        return linkedList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> LinkedList<T> newLinkedList(@NotNull Iterable<? extends T> elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/util/containers/ContainerUtilRt", "newLinkedList"));
        }
        LinkedList<T> linkedList = ContainerUtilRt.copy(ContainerUtilRt.<T>newLinkedList(), elements);
        if (linkedList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtilRt", "newLinkedList"));
        }
        return linkedList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> ArrayList<T> newArrayList() {
        ArrayList arrayList = new ArrayList();
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtilRt", "newArrayList"));
        }
        return arrayList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> ArrayList<T> newArrayList(T ... elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/util/containers/ContainerUtilRt", "newArrayList"));
        }
        ArrayList<T> list = ContainerUtilRt.newArrayListWithCapacity(elements.length);
        Collections.addAll(list, elements);
        ArrayList<T> arrayList = list;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtilRt", "newArrayList"));
        }
        return arrayList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> ArrayList<T> newArrayList(@NotNull Iterable<? extends T> elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/util/containers/ContainerUtilRt", "newArrayList"));
        }
        if (elements instanceof Collection) {
            Collection collection = (Collection)elements;
            ArrayList arrayList = new ArrayList(collection);
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtilRt", "newArrayList"));
            }
            return arrayList;
        }
        ArrayList<T> arrayList = ContainerUtilRt.copy(ContainerUtilRt.<T>newArrayList(), elements);
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtilRt", "newArrayList"));
        }
        return arrayList;
    }

    @Contract(pure=true)
    public static <T> ArrayList<T> newArrayListWithExpectedSize(int size) {
        return ContainerUtilRt.newArrayListWithCapacity(size);
    }

    @NotNull
    @Contract(pure=true)
    public static <T> ArrayList<T> newArrayListWithCapacity(int size) {
        ArrayList arrayList = new ArrayList(size);
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtilRt", "newArrayListWithCapacity"));
        }
        return arrayList;
    }

    @NotNull
    private static <T, C extends Collection<T>> C copy(@NotNull C collection, @NotNull Iterable<? extends T> elements) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/util/containers/ContainerUtilRt", "copy"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/util/containers/ContainerUtilRt", "copy"));
        }
        for (T element : elements) {
            collection.add(element);
        }
        C c = collection;
        if (c == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtilRt", "copy"));
        }
        return c;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> java.util.HashSet<T> newHashSet() {
        HashSet hashSet = new HashSet();
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtilRt", "newHashSet"));
        }
        return hashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> java.util.HashSet<T> newHashSet(int initialCapacity) {
        HashSet hashSet = new HashSet(initialCapacity);
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtilRt", "newHashSet"));
        }
        return hashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> java.util.HashSet<T> newHashSet(T ... elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/util/containers/ContainerUtilRt", "newHashSet"));
        }
        HashSet<T> hashSet = new HashSet<T>(Arrays.asList(elements));
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtilRt", "newHashSet"));
        }
        return hashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> java.util.HashSet<T> newHashSet(@NotNull Iterable<? extends T> elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/util/containers/ContainerUtilRt", "newHashSet"));
        }
        if (elements instanceof Collection) {
            Collection collection = (Collection)elements;
            HashSet hashSet = new HashSet(collection);
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtilRt", "newHashSet"));
            }
            return hashSet;
        }
        java.util.HashSet<? extends T> hashSet = ContainerUtilRt.newHashSet(elements.iterator());
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtilRt", "newHashSet"));
        }
        return hashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> java.util.HashSet<T> newHashSet(@NotNull Iterator<? extends T> iterator) {
        if (iterator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterator", "com/intellij/util/containers/ContainerUtilRt", "newHashSet"));
        }
        java.util.HashSet<T> set = ContainerUtilRt.newHashSet();
        while (iterator.hasNext()) {
            set.add(iterator.next());
        }
        java.util.HashSet<T> hashSet = set;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtilRt", "newHashSet"));
        }
        return hashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> java.util.LinkedHashSet<T> newLinkedHashSet() {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtilRt", "newLinkedHashSet"));
        }
        return linkedHashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> java.util.LinkedHashSet<T> newLinkedHashSet(T ... elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/util/containers/ContainerUtilRt", "newLinkedHashSet"));
        }
        java.util.LinkedHashSet<T> linkedHashSet = ContainerUtilRt.newLinkedHashSet(Arrays.asList(elements));
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtilRt", "newLinkedHashSet"));
        }
        return linkedHashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> java.util.LinkedHashSet<T> newLinkedHashSet(@NotNull Iterable<? extends T> elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/util/containers/ContainerUtilRt", "newLinkedHashSet"));
        }
        if (elements instanceof Collection) {
            Collection collection = (Collection)elements;
            LinkedHashSet linkedHashSet = new LinkedHashSet(collection);
            if (linkedHashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtilRt", "newLinkedHashSet"));
            }
            return linkedHashSet;
        }
        java.util.LinkedHashSet<T> linkedHashSet = ContainerUtilRt.copy(ContainerUtilRt.<T>newLinkedHashSet(), elements);
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtilRt", "newLinkedHashSet"));
        }
        return linkedHashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> TreeSet<T> newTreeSet() {
        TreeSet treeSet = new TreeSet();
        if (treeSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtilRt", "newTreeSet"));
        }
        return treeSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> TreeSet<T> newTreeSet(T ... elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/util/containers/ContainerUtilRt", "newTreeSet"));
        }
        TreeSet<T> set = ContainerUtilRt.newTreeSet();
        Collections.addAll(set, elements);
        TreeSet<T> treeSet = set;
        if (treeSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtilRt", "newTreeSet"));
        }
        return treeSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> TreeSet<T> newTreeSet(@NotNull Iterable<? extends T> elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/util/containers/ContainerUtilRt", "newTreeSet"));
        }
        TreeSet<T> treeSet = ContainerUtilRt.copy(ContainerUtilRt.<T>newTreeSet(), elements);
        if (treeSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtilRt", "newTreeSet"));
        }
        return treeSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> TreeSet<T> newTreeSet(@Nullable Comparator<? super T> comparator) {
        TreeSet<? super T> treeSet = new TreeSet<T>(comparator);
        if (treeSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtilRt", "newTreeSet"));
        }
        return treeSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Stack<T> newStack() {
        Stack stack = new Stack();
        if (stack == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtilRt", "newStack"));
        }
        return stack;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Stack<T> newStack(@NotNull Collection<T> elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/util/containers/ContainerUtilRt", "newStack"));
        }
        Stack<T> stack = new Stack<T>(elements);
        if (stack == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtilRt", "newStack"));
        }
        return stack;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Stack<T> newStack(T ... initial) {
        if (initial == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initial", "com/intellij/util/containers/ContainerUtilRt", "newStack"));
        }
        Stack<T> stack = new Stack<T>(Arrays.asList(initial));
        if (stack == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtilRt", "newStack"));
        }
        return stack;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> emptyList() {
        EmptyList emptyList = EmptyList.INSTANCE;
        if (emptyList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtilRt", "emptyList"));
        }
        return emptyList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> CopyOnWriteArrayList<T> createEmptyCOWList() {
        CopyOnWriteArrayList<T> copyOnWriteArrayList = new CopyOnWriteArrayList<T>(ContainerUtilRt.<T>emptyList());
        if (copyOnWriteArrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtilRt", "createEmptyCOWList"));
        }
        return copyOnWriteArrayList;
    }

    public static <T> void addIfNotNull(@Nullable T element, @NotNull Collection<T> result) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/util/containers/ContainerUtilRt", "addIfNotNull"));
        }
        if (element != null) {
            result.add(element);
        }
    }

    public static <T> void addIfNotNull(@NotNull Collection<T> result, @Nullable T element) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/util/containers/ContainerUtilRt", "addIfNotNull"));
        }
        if (element != null) {
            result.add(element);
        }
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<V> map2List(@NotNull T[] array, @NotNull Function<T, V> mapper) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/util/containers/ContainerUtilRt", "map2List"));
        }
        if (mapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapper", "com/intellij/util/containers/ContainerUtilRt", "map2List"));
        }
        List<V> list = ContainerUtilRt.map2List(Arrays.asList(array), mapper);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtilRt", "map2List"));
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<V> map2List(@NotNull Collection<? extends T> collection, @NotNull Function<T, V> mapper) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/util/containers/ContainerUtilRt", "map2List"));
        }
        if (mapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapper", "com/intellij/util/containers/ContainerUtilRt", "map2List"));
        }
        if (collection.isEmpty()) {
            List<T> list = ContainerUtilRt.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtilRt", "map2List"));
            }
            return list;
        }
        ArrayList<V> list = new ArrayList<V>(collection.size());
        for (T t : collection) {
            list.add(mapper.fun(t));
        }
        ArrayList<V> arrayList = list;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtilRt", "map2List"));
        }
        return arrayList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> Set<V> map2Set(@NotNull T[] collection, @NotNull Function<T, V> mapper) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/util/containers/ContainerUtilRt", "map2Set"));
        }
        if (mapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapper", "com/intellij/util/containers/ContainerUtilRt", "map2Set"));
        }
        Set<V> set = ContainerUtilRt.map2Set(Arrays.asList(collection), mapper);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtilRt", "map2Set"));
        }
        return set;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> Set<V> map2Set(@NotNull Collection<? extends T> collection, @NotNull Function<T, V> mapper) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/util/containers/ContainerUtilRt", "map2Set"));
        }
        if (mapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapper", "com/intellij/util/containers/ContainerUtilRt", "map2Set"));
        }
        if (collection.isEmpty()) {
            Set set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtilRt", "map2Set"));
            }
            return set;
        }
        java.util.HashSet<V> set = new java.util.HashSet<V>(collection.size());
        for (T t : collection) {
            set.add(mapper.fun(t));
        }
        java.util.HashSet<V> hashSet = set;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtilRt", "map2Set"));
        }
        return hashSet;
    }

    @NotNull
    public static <T> T[] toArray(@NotNull List<T> collection, @NotNull T[] array) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/util/containers/ContainerUtilRt", "toArray"));
        }
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/util/containers/ContainerUtilRt", "toArray"));
        }
        int length = array.length;
        if (length < 20 && array.length >= collection.size()) {
            for (int i = 0; i < collection.size(); ++i) {
                array[i] = collection.get(i);
            }
            if (array == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtilRt", "toArray"));
            }
            return array;
        }
        T[] TArray = collection.toArray(array);
        if (TArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtilRt", "toArray"));
        }
        return TArray;
    }

    @NotNull
    public static <T> T[] toArray(@NotNull Collection<T> c, @NotNull T[] sample) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/util/containers/ContainerUtilRt", "toArray"));
        }
        if (sample == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sample", "com/intellij/util/containers/ContainerUtilRt", "toArray"));
        }
        int size = c.size();
        if (size == sample.length && size < 20) {
            int i = 0;
            for (T t : c) {
                sample[i++] = t;
            }
            if (sample == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtilRt", "toArray"));
            }
            return sample;
        }
        T[] TArray = c.toArray(sample);
        if (TArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtilRt", "toArray"));
        }
        return TArray;
    }

    private static class EmptyList<T>
    extends AbstractList<T>
    implements RandomAccess,
    Serializable {
        private static final long serialVersionUID = 1L;
        private static final EmptyList INSTANCE = new EmptyList();

        private EmptyList() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean contains(Object obj) {
            return false;
        }

        @Override
        public T get(int index) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }

        @Override
        @NotNull
        public Object[] toArray() {
            if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtilRt$EmptyList", "toArray"));
            }
            return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
        }

        @Override
        @NotNull
        public <T> T[] toArray(@NotNull T[] a) {
            if (a == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a", "com/intellij/util/containers/ContainerUtilRt$EmptyList", "toArray"));
            }
            if (a.length != 0) {
                a[0] = null;
            }
            if (a == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtilRt$EmptyList", "toArray"));
            }
            return a;
        }

        @Override
        @NotNull
        public Iterator<T> iterator() {
            EmptyIterator emptyIterator = EmptyIterator.getInstance();
            if (emptyIterator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtilRt$EmptyList", "iterator"));
            }
            return emptyIterator;
        }
    }
}

