/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.Accessor;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.SerializationFilter;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CompactCollectionBinding
extends Binding {
    private final String name;

    protected CompactCollectionBinding(@NotNull Accessor accessor) {
        if (accessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessor", "com/intellij/util/xmlb/CompactCollectionBinding", "<init>"));
        }
        super(accessor);
        this.name = this.myAccessor.getName();
    }

    @Override
    @Nullable
    public Object serialize(@NotNull Object o, @Nullable Object context, @NotNull SerializationFilter filter) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/util/xmlb/CompactCollectionBinding", "serialize"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/util/xmlb/CompactCollectionBinding", "serialize"));
        }
        Element result = new Element(this.name);
        List list = (List)o;
        if (list == null || list.isEmpty()) {
            return result;
        }
        for (String item : list) {
            result.addContent(new Element("item").setAttribute("value", item));
        }
        return result;
    }

    @Override
    @Nullable
    public Object deserialize(Object context, @NotNull Object node) {
        List list;
        block5: {
            Element element;
            block4: {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/util/xmlb/CompactCollectionBinding", "deserialize"));
                }
                list = (List)context;
                list.clear();
                element = (Element)node;
                if (!element.getName().equals(this.name)) break block4;
                for (Element item : element.getChildren("item")) {
                    ContainerUtil.addIfNotNull(list, item.getAttributeValue("value"));
                }
                break block5;
            }
            Element value = element.getChild("value");
            if (value != null) {
                value = value.getChild("list");
            }
            if (value == null) break block5;
            for (Element item : value.getChildren("item")) {
                ContainerUtil.addIfNotNull(list, item.getAttributeValue("itemvalue"));
            }
        }
        return list;
    }

    @Override
    public boolean isBoundTo(Object node) {
        if (node instanceof Element) {
            Element element = (Element)node;
            String elementName = element.getName();
            if (this.isNameEqual(elementName)) {
                return true;
            }
            if (elementName.equals("option")) {
                return this.isNameEqual(element.getAttributeValue("name"));
            }
        }
        return false;
    }

    private boolean isNameEqual(@Nullable String value) {
        if (value == null) {
            return false;
        }
        if (value.equals(this.name)) {
            return true;
        }
        if (value.length() == this.name.length() + 2 && value.startsWith("my")) {
            return Character.isUpperCase(value.charAt(2)) && value.regionMatches(true, 2, this.name, 0, this.name.length());
        }
        return false;
    }
}

