/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.util.xmlb.Accessor;
import com.intellij.util.xmlb.XmlSerializationException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FieldAccessor
implements Accessor {
    private final Field myField;

    public FieldAccessor(@NotNull Field field) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/util/xmlb/FieldAccessor", "<init>"));
        }
        this.myField = field;
        field.setAccessible(true);
    }

    @Override
    public Object read(@NotNull Object o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/util/xmlb/FieldAccessor", "read"));
        }
        assert (this.myField.getDeclaringClass().isInstance(o)) : "Wrong class: " + o.getClass() + "; should be: " + this.myField.getDeclaringClass();
        try {
            return this.myField.get(o);
        }
        catch (IllegalAccessException e) {
            throw new XmlSerializationException("Reading " + this.myField, e);
        }
    }

    @Override
    public void set(@NotNull Object host, @Nullable Object value) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/util/xmlb/FieldAccessor", "set"));
        }
        try {
            this.myField.set(host, value);
        }
        catch (IllegalAccessException e) {
            throw new XmlSerializationException("Writing " + this.myField, e);
        }
    }

    @Override
    public void setBoolean(@NotNull Object host, boolean value) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/util/xmlb/FieldAccessor", "setBoolean"));
        }
        try {
            this.myField.setBoolean(host, value);
        }
        catch (IllegalAccessException e) {
            throw new XmlSerializationException("Writing " + this.myField, e);
        }
    }

    @Override
    public void setInt(@NotNull Object host, int value) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/util/xmlb/FieldAccessor", "setInt"));
        }
        try {
            this.myField.setInt(host, value);
        }
        catch (IllegalAccessException e) {
            throw new XmlSerializationException("Writing " + this.myField, e);
        }
    }

    @Override
    public void setShort(@NotNull Object host, short value) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/util/xmlb/FieldAccessor", "setShort"));
        }
        try {
            this.myField.setShort(host, value);
        }
        catch (IllegalAccessException e) {
            throw new XmlSerializationException("Writing " + this.myField, e);
        }
    }

    @Override
    public void setLong(@NotNull Object host, long value) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/util/xmlb/FieldAccessor", "setLong"));
        }
        try {
            this.myField.setLong(host, value);
        }
        catch (IllegalAccessException e) {
            throw new XmlSerializationException("Writing " + this.myField, e);
        }
    }

    @Override
    public void setFloat(@NotNull Object host, float value) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/util/xmlb/FieldAccessor", "setFloat"));
        }
        try {
            this.myField.setFloat(host, value);
        }
        catch (IllegalAccessException e) {
            throw new XmlSerializationException("Writing " + this.myField, e);
        }
    }

    @Override
    public void setDouble(@NotNull Object host, double value) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/util/xmlb/FieldAccessor", "setDouble"));
        }
        try {
            this.myField.setDouble(host, value);
        }
        catch (IllegalAccessException e) {
            throw new XmlSerializationException("Writing " + this.myField, e);
        }
    }

    @Override
    public <T extends Annotation> T getAnnotation(@NotNull Class<T> annotationClass) {
        if (annotationClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationClass", "com/intellij/util/xmlb/FieldAccessor", "getAnnotation"));
        }
        return this.myField.getAnnotation(annotationClass);
    }

    @Override
    public String getName() {
        return this.myField.getName();
    }

    @Override
    public Class<?> getValueClass() {
        return this.myField.getType();
    }

    @Override
    public Type getGenericType() {
        return this.myField.getGenericType();
    }

    @Override
    public boolean isFinal() {
        return Modifier.isFinal(this.myField.getModifiers());
    }

    @NonNls
    public String toString() {
        return "FieldAccessor[" + this.myField.getDeclaringClass() + "." + this.myField.getName() + "]";
    }
}

