/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.Accessor;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.MultiNodeBinding;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.XmlSerializationException;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JDOMElementBinding
extends Binding
implements MultiNodeBinding {
    private final String myTagName;

    public JDOMElementBinding(@NotNull Accessor accessor) {
        if (accessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessor", "com/intellij/util/xmlb/JDOMElementBinding", "<init>"));
        }
        super(accessor);
        Tag tag = this.myAccessor.getAnnotation(Tag.class);
        assert (tag != null) : "jdom.Element property without @Tag annotation: " + accessor;
        String tagName = tag.value();
        if (StringUtil.isEmpty(tagName)) {
            tagName = this.myAccessor.getName();
        }
        this.myTagName = tagName;
    }

    @Override
    public Object serialize(@NotNull Object o, Object context, @NotNull SerializationFilter filter) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/util/xmlb/JDOMElementBinding", "serialize"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/util/xmlb/JDOMElementBinding", "serialize"));
        }
        Object value = this.myAccessor.read(o);
        if (value == null) {
            return null;
        }
        if (value instanceof Element) {
            Element targetElement = ((Element)value).clone();
            assert (targetElement != null);
            targetElement.setName(this.myTagName);
            return targetElement;
        }
        if (value instanceof Element[]) {
            ArrayList<Element> result = new ArrayList<Element>();
            for (Element element : (Element[])value) {
                result.add(element.clone().setName(this.myTagName));
            }
            return result;
        }
        throw new XmlSerializationException("org.jdom.Element expected but " + value + " found");
    }

    @Override
    @Nullable
    public Object deserializeList(Object context, @NotNull List<?> nodes) {
        if (nodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodes", "com/intellij/util/xmlb/JDOMElementBinding", "deserializeList"));
        }
        if (this.myAccessor.getValueClass().isArray()) {
            this.myAccessor.set(context, nodes.toArray(new Element[nodes.size()]));
        } else {
            this.myAccessor.set(context, nodes.get(0));
        }
        return context;
    }

    @Override
    public boolean isMulti() {
        return true;
    }

    @Override
    @Nullable
    public Object deserialize(Object context, @NotNull Object node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/util/xmlb/JDOMElementBinding", "deserialize"));
        }
        this.myAccessor.set(context, node);
        return context;
    }

    @Override
    public boolean isBoundTo(Object node) {
        return node instanceof Element && ((Element)node).getName().equals(this.myTagName);
    }

    @Override
    @NotNull
    public Class getBoundNodeType() {
        throw new UnsupportedOperationException("Method getBoundNodeType is not supported in " + this.getClass());
    }
}

