/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.util.ui.UIUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Filter {
    public static final Filter[] EMPTY_ARRAY = new Filter[0];

    @Nullable
    public Result applyFilter(String var1, int var2);

    public static class ResultItem {
        @Deprecated
        public final int highlightStartOffset;
        @Deprecated
        public final int highlightEndOffset;
        @Deprecated
        @Nullable
        public final TextAttributes highlightAttributes;
        @Deprecated
        @Nullable
        public final HyperlinkInfo hyperlinkInfo;

        public ResultItem(int highlightStartOffset, int highlightEndOffset, @Nullable HyperlinkInfo hyperlinkInfo) {
            this(highlightStartOffset, highlightEndOffset, hyperlinkInfo, null);
        }

        public ResultItem(int highlightStartOffset, int highlightEndOffset, @Nullable HyperlinkInfo hyperlinkInfo, @Nullable TextAttributes highlightAttributes) {
            this.highlightStartOffset = highlightStartOffset;
            this.highlightEndOffset = highlightEndOffset;
            this.hyperlinkInfo = hyperlinkInfo;
            this.highlightAttributes = highlightAttributes;
        }

        public int getHighlightStartOffset() {
            return this.highlightStartOffset;
        }

        public int getHighlightEndOffset() {
            return this.highlightEndOffset;
        }

        @Nullable
        public TextAttributes getHighlightAttributes() {
            return this.highlightAttributes;
        }

        @Nullable
        public HyperlinkInfo getHyperlinkInfo() {
            return this.hyperlinkInfo;
        }
    }

    public static enum NextAction {
        EXIT,
        CONTINUE_FILTERING;

    }

    public static class Result
    extends ResultItem {
        private static final TextAttributes INACTIVE_HYPERLINK_ATTRIBUTES;
        protected NextAction myNextAction;
        protected final List<ResultItem> myResultItems;

        public Result(int highlightStartOffset, int highlightEndOffset, @Nullable HyperlinkInfo hyperlinkInfo) {
            this(highlightStartOffset, highlightEndOffset, hyperlinkInfo, null);
        }

        public Result(int highlightStartOffset, int highlightEndOffset, @Nullable HyperlinkInfo hyperlinkInfo, @Nullable TextAttributes highlightAttributes) {
            super(highlightStartOffset, highlightEndOffset, hyperlinkInfo, highlightAttributes);
            this.myNextAction = NextAction.EXIT;
            this.myResultItems = null;
        }

        public Result(int highlightStartOffset, int highlightEndOffset, @Nullable HyperlinkInfo hyperlinkInfo, boolean inactiveHyperlink) {
            super(highlightStartOffset, highlightEndOffset, hyperlinkInfo, inactiveHyperlink ? INACTIVE_HYPERLINK_ATTRIBUTES : null);
            this.myNextAction = NextAction.EXIT;
            this.myResultItems = null;
        }

        public Result(@NotNull List<ResultItem> resultItems) {
            if (resultItems == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultItems", "com/intellij/execution/filters/Filter$Result", "<init>"));
            }
            super(-1, -1, null, null);
            this.myNextAction = NextAction.EXIT;
            this.myResultItems = resultItems;
        }

        public List<ResultItem> getResultItems() {
            List<ResultItem> resultItems = this.myResultItems;
            if (resultItems == null) {
                resultItems = Collections.singletonList(this);
            }
            return resultItems;
        }

        @Override
        @Deprecated
        public int getHighlightStartOffset() {
            return super.getHighlightStartOffset();
        }

        @Override
        @Deprecated
        public int getHighlightEndOffset() {
            return super.getHighlightEndOffset();
        }

        @Override
        @Deprecated
        @Nullable
        public TextAttributes getHighlightAttributes() {
            return super.getHighlightAttributes();
        }

        @Override
        @Deprecated
        @Nullable
        public HyperlinkInfo getHyperlinkInfo() {
            return super.getHyperlinkInfo();
        }

        @Nullable
        public HyperlinkInfo getFirstHyperlinkInfo() {
            HyperlinkInfo info = super.getHyperlinkInfo();
            if (info == null && this.myResultItems != null) {
                for (int i = 0; i < this.myResultItems.size(); ++i) {
                    ResultItem resultItem = this.myResultItems.get(i);
                    if (resultItem.getHyperlinkInfo() == null) continue;
                    return resultItem.getHyperlinkInfo();
                }
            }
            return info;
        }

        public NextAction getNextAction() {
            return this.myNextAction;
        }

        public void setNextAction(NextAction nextAction) {
            this.myNextAction = nextAction;
        }

        static {
            TextAttributes attributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(CodeInsightColors.HYPERLINK_ATTRIBUTES);
            if (attributes != null) {
                attributes = attributes.clone();
                attributes.setForegroundColor(UIUtil.getInactiveTextColor());
                attributes.setEffectColor(UIUtil.getInactiveTextColor());
            }
            INACTIVE_HYPERLINK_ATTRIBUTES = attributes;
        }
    }
}

