/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.settings;

import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalTaskExecutionInfo;
import com.intellij.openapi.externalSystem.model.execution.ExternalTaskPojo;
import com.intellij.openapi.externalSystem.model.project.ExternalProjectBuildClasspathPojo;
import com.intellij.openapi.externalSystem.model.project.ExternalProjectPojo;
import com.intellij.openapi.externalSystem.service.project.PlatformFacade;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.view.ExternalProjectsViewState;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtilRt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractExternalSystemLocalSettings {
    private static final boolean PRESERVE_EXPAND_STATE = !SystemProperties.getBooleanProperty((String)"external.system.forget.expand.nodes.state", (boolean)false);
    private final AtomicReference<Map<String, Boolean>> myExpandStates;
    private final AtomicReference<List<ExternalTaskExecutionInfo>> myRecentTasks;
    private final AtomicReference<Map<ExternalProjectPojo, Collection<ExternalProjectPojo>>> myAvailableProjects;
    private final AtomicReference<Map<String, Collection<ExternalTaskPojo>>> myAvailableTasks;
    private final AtomicReference<Map<String, ExternalProjectBuildClasspathPojo>> myProjectBuildClasspath;
    private final AtomicReference<Map<String, Long>> myExternalConfigModificationStamps;
    private final AtomicReference<ExternalProjectsViewState> myExternalProjectsViewState;
    @NotNull
    private final ProjectSystemId myExternalSystemId;
    @NotNull
    private final Project myProject;
    @NotNull
    private final PlatformFacade myPlatformFacade;

    protected AbstractExternalSystemLocalSettings(@NotNull ProjectSystemId externalSystemId, @NotNull Project project, @NotNull PlatformFacade facade) {
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalSystemId", "com/intellij/openapi/externalSystem/settings/AbstractExternalSystemLocalSettings", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/settings/AbstractExternalSystemLocalSettings", "<init>"));
        }
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "com/intellij/openapi/externalSystem/settings/AbstractExternalSystemLocalSettings", "<init>"));
        }
        this.myExpandStates = new AtomicReference(new HashMap());
        this.myRecentTasks = new AtomicReference<ArrayList>(ContainerUtilRt.newArrayList());
        this.myAvailableProjects = new AtomicReference<HashMap>(ContainerUtilRt.newHashMap());
        this.myAvailableTasks = new AtomicReference<HashMap>(ContainerUtilRt.newHashMap());
        this.myProjectBuildClasspath = new AtomicReference<HashMap>(ContainerUtilRt.newHashMap());
        this.myExternalConfigModificationStamps = new AtomicReference<HashMap>(ContainerUtilRt.newHashMap());
        this.myExternalProjectsViewState = new AtomicReference<ExternalProjectsViewState>(new ExternalProjectsViewState());
        this.myExternalSystemId = externalSystemId;
        this.myProject = project;
        this.myPlatformFacade = facade;
    }

    public void forgetExternalProjects(@NotNull Set<String> linkedProjectPathsToForget) {
        Map.Entry<Object, Collection<Comparable<ExternalProjectPojo>>> entry;
        if (linkedProjectPathsToForget == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "linkedProjectPathsToForget", "com/intellij/openapi/externalSystem/settings/AbstractExternalSystemLocalSettings", "forgetExternalProjects"));
        }
        Map<ExternalProjectPojo, Collection<ExternalProjectPojo>> projects = this.myAvailableProjects.get();
        Iterator<Object> it = projects.entrySet().iterator();
        while (it.hasNext()) {
            entry = it.next();
            if (!linkedProjectPathsToForget.contains(entry.getKey().getPath())) continue;
            it.remove();
        }
        it = this.myAvailableTasks.get().entrySet().iterator();
        while (it.hasNext()) {
            entry = it.next();
            if (!linkedProjectPathsToForget.contains(entry.getKey()) && !linkedProjectPathsToForget.contains(ExternalSystemApiUtil.getRootProjectPath((String)entry.getKey(), this.myExternalSystemId, this.myProject))) continue;
            it.remove();
        }
        it = this.myRecentTasks.get().iterator();
        while (it.hasNext()) {
            ExternalTaskExecutionInfo taskInfo = (ExternalTaskExecutionInfo)it.next();
            String path = taskInfo.getSettings().getExternalProjectPath();
            if (!linkedProjectPathsToForget.contains(path) && !linkedProjectPathsToForget.contains(ExternalSystemApiUtil.getRootProjectPath(path, this.myExternalSystemId, this.myProject))) continue;
            it.remove();
        }
        it = this.myProjectBuildClasspath.get().entrySet().iterator();
        while (it.hasNext()) {
            entry = (Map.Entry)it.next();
            if (!linkedProjectPathsToForget.contains(entry.getKey()) && !linkedProjectPathsToForget.contains(ExternalSystemApiUtil.getRootProjectPath((String)entry.getKey(), this.myExternalSystemId, this.myProject))) continue;
            it.remove();
        }
        Map<String, Long> modificationStamps = this.myExternalConfigModificationStamps.get();
        for (String path : linkedProjectPathsToForget) {
            modificationStamps.remove(path);
        }
    }

    @NotNull
    public Map<String, Boolean> getExpandStates() {
        Map<String, Boolean> map = this.myExpandStates.get();
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/settings/AbstractExternalSystemLocalSettings", "getExpandStates"));
        }
        return map;
    }

    @NotNull
    public Map<ExternalProjectPojo, Collection<ExternalProjectPojo>> getAvailableProjects() {
        Map<ExternalProjectPojo, Collection<ExternalProjectPojo>> map = this.myAvailableProjects.get();
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/settings/AbstractExternalSystemLocalSettings", "getAvailableProjects"));
        }
        return map;
    }

    public void setAvailableProjects(@NotNull Map<ExternalProjectPojo, Collection<ExternalProjectPojo>> projects) {
        if (projects == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projects", "com/intellij/openapi/externalSystem/settings/AbstractExternalSystemLocalSettings", "setAvailableProjects"));
        }
        this.myAvailableProjects.set(projects);
    }

    @NotNull
    public Map<String, Collection<ExternalTaskPojo>> getAvailableTasks() {
        Map<String, Collection<ExternalTaskPojo>> map = this.myAvailableTasks.get();
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/settings/AbstractExternalSystemLocalSettings", "getAvailableTasks"));
        }
        return map;
    }

    public void setAvailableTasks(@NotNull Map<String, Collection<ExternalTaskPojo>> tasks) {
        if (tasks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tasks", "com/intellij/openapi/externalSystem/settings/AbstractExternalSystemLocalSettings", "setAvailableTasks"));
        }
        this.myAvailableTasks.set(tasks);
    }

    @NotNull
    public List<ExternalTaskExecutionInfo> getRecentTasks() {
        List<ExternalTaskExecutionInfo> list = this.myRecentTasks.get();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/settings/AbstractExternalSystemLocalSettings", "getRecentTasks"));
        }
        return list;
    }

    public void setRecentTasks(@NotNull List<ExternalTaskExecutionInfo> tasks) {
        if (tasks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tasks", "com/intellij/openapi/externalSystem/settings/AbstractExternalSystemLocalSettings", "setRecentTasks"));
        }
        this.myRecentTasks.set(tasks);
    }

    @NotNull
    public Map<String, Long> getExternalConfigModificationStamps() {
        Map<String, Long> map = this.myExternalConfigModificationStamps.get();
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/settings/AbstractExternalSystemLocalSettings", "getExternalConfigModificationStamps"));
        }
        return map;
    }

    public void setExternalConfigModificationStamps(@NotNull Map<String, Long> modificationStamps) {
        if (modificationStamps == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modificationStamps", "com/intellij/openapi/externalSystem/settings/AbstractExternalSystemLocalSettings", "setExternalConfigModificationStamps"));
        }
        this.myExternalConfigModificationStamps.set(modificationStamps);
    }

    @NotNull
    public Map<String, ExternalProjectBuildClasspathPojo> getProjectBuildClasspath() {
        Map<String, ExternalProjectBuildClasspathPojo> map = this.myProjectBuildClasspath.get();
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/settings/AbstractExternalSystemLocalSettings", "getProjectBuildClasspath"));
        }
        return map;
    }

    public void setProjectBuildClasspath(@NotNull Map<String, ExternalProjectBuildClasspathPojo> projectsBuildClasspath) {
        if (projectsBuildClasspath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectsBuildClasspath", "com/intellij/openapi/externalSystem/settings/AbstractExternalSystemLocalSettings", "setProjectBuildClasspath"));
        }
        this.myProjectBuildClasspath.set(projectsBuildClasspath);
    }

    public ExternalProjectsViewState getExternalProjectsViewState() {
        return this.myExternalProjectsViewState.get();
    }

    public void setExternalProjectsViewState(ExternalProjectsViewState externalProjectsViewState) {
        this.myExternalProjectsViewState.set(externalProjectsViewState);
    }

    public void fillState(@NotNull State state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/openapi/externalSystem/settings/AbstractExternalSystemLocalSettings", "fillState"));
        }
        state.tasksExpandState = PRESERVE_EXPAND_STATE ? this.myExpandStates.get() : Collections.emptyMap();
        state.recentTasks = this.myRecentTasks.get();
        state.availableProjects = this.myAvailableProjects.get();
        state.availableTasks = this.myAvailableTasks.get();
        state.modificationStamps = this.myExternalConfigModificationStamps.get();
        state.projectBuildClasspath = this.myProjectBuildClasspath.get();
        state.externalProjectsViewState = this.myExternalProjectsViewState.get();
    }

    public void loadState(@NotNull State state) {
        List<ExternalTaskExecutionInfo> recentTasks;
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/openapi/externalSystem/settings/AbstractExternalSystemLocalSettings", "loadState"));
        }
        AbstractExternalSystemLocalSettings.setIfNotNull(this.myExpandStates, state.tasksExpandState);
        AbstractExternalSystemLocalSettings.setIfNotNull(this.myAvailableProjects, state.availableProjects);
        AbstractExternalSystemLocalSettings.setIfNotNull(this.myAvailableTasks, state.availableTasks);
        AbstractExternalSystemLocalSettings.setIfNotNull(this.myExternalConfigModificationStamps, state.modificationStamps);
        AbstractExternalSystemLocalSettings.setIfNotNull(this.myProjectBuildClasspath, state.projectBuildClasspath);
        this.myExternalProjectsViewState.set(state.externalProjectsViewState);
        if (state.recentTasks != null && (recentTasks = this.myRecentTasks.get()) != state.recentTasks) {
            recentTasks.clear();
            recentTasks.addAll(state.recentTasks);
        }
        this.pruneOutdatedEntries();
    }

    private void pruneOutdatedEntries() {
        ExternalSystemManager<?, ?, ?, ?, ?> manager = ExternalSystemApiUtil.getManager(this.myExternalSystemId);
        assert (manager != null);
        HashSet pathsToForget = ContainerUtilRt.newHashSet();
        for (ExternalProjectPojo pojo : this.myAvailableProjects.get().keySet()) {
            pathsToForget.add(pojo.getPath());
        }
        for (String path : this.myAvailableTasks.get().keySet()) {
            pathsToForget.add(path);
        }
        for (ExternalTaskExecutionInfo taskInfo : this.myRecentTasks.get()) {
            pathsToForget.add(taskInfo.getSettings().getExternalProjectPath());
        }
        AbstractExternalSystemSettings settings = (AbstractExternalSystemSettings)manager.getSettingsProvider().fun((Object)this.myProject);
        for (ExternalProjectSettings projectSettings : settings.getLinkedProjectsSettings()) {
            pathsToForget.remove(projectSettings.getExternalProjectPath());
        }
        for (Module module : this.myPlatformFacade.getModules(this.myProject)) {
            String id = module.getOptionValue("external.system.id");
            if (!this.myExternalSystemId.toString().equals(id)) continue;
            pathsToForget.remove(module.getOptionValue("external.linked.project.path"));
        }
        if (!pathsToForget.isEmpty()) {
            this.forgetExternalProjects(pathsToForget);
        }
    }

    private static <K, V> void setIfNotNull(@NotNull AtomicReference<Map<K, V>> ref, @Nullable Map<K, V> candidate) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/openapi/externalSystem/settings/AbstractExternalSystemLocalSettings", "setIfNotNull"));
        }
        if (candidate == null) {
            return;
        }
        Map<K, V> map = ref.get();
        if (candidate != map) {
            map.clear();
            map.putAll(candidate);
        }
    }

    public static class State {
        public Map<String, Boolean> tasksExpandState = ContainerUtilRt.newHashMap();
        public List<ExternalTaskExecutionInfo> recentTasks = ContainerUtilRt.newArrayList();
        public Map<ExternalProjectPojo, Collection<ExternalProjectPojo>> availableProjects = ContainerUtilRt.newHashMap();
        public Map<String, Collection<ExternalTaskPojo>> availableTasks = ContainerUtilRt.newHashMap();
        public Map<String, Long> modificationStamps = ContainerUtilRt.newHashMap();
        public Map<String, ExternalProjectBuildClasspathPojo> projectBuildClasspath = ContainerUtilRt.newHashMap();
        public ExternalProjectsViewState externalProjectsViewState;
    }
}

