/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.fileChooser.FileTextField;
import com.intellij.openapi.ui.ComboBox;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.JTextField;
import javax.swing.event.DocumentListener;

public class TextFieldWithHistory
extends ComboBox {
    private int myHistorySize = 5;
    private final MyModel myModel = new MyModel();

    public TextFieldWithHistory() {
        this.setModel(this.myModel);
        this.setEditable(true);
    }

    public TextFieldWithHistory(boolean cropList) {
        this();
    }

    public void addDocumentListener(DocumentListener listener) {
        this.getTextEditor().getDocument().addDocumentListener(listener);
    }

    public void removeDocumentListener(DocumentListener listener) {
        this.getTextEditor().getDocument().removeDocumentListener(listener);
    }

    public void addKeyboardListener(KeyListener listener) {
        this.getTextEditor().addKeyListener(listener);
    }

    public void setHistorySize(int aHistorySize) {
        this.myHistorySize = aHistorySize;
    }

    public void setHistory(List<String> aHistory) {
        this.myModel.setItems(aHistory);
    }

    public List<String> getHistory() {
        int itemsCount = this.myModel.getSize();
        ArrayList<String> history = new ArrayList<String>(itemsCount);
        for (int i = 0; i < itemsCount; ++i) {
            history.add((String)this.myModel.getElementAt(i));
        }
        return history;
    }

    public void setText(String aText) {
        this.getTextEditor().setText(aText);
    }

    public String getText() {
        return this.getTextEditor().getText();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.hidePopup();
    }

    public void addCurrentTextToHistory() {
        String item = this.getText();
        this.myModel.addElement(item);
    }

    public void selectText() {
        this.getTextEditor().selectAll();
    }

    public JTextField getTextEditor() {
        return (JTextField)this.getEditor().getEditorComponent();
    }

    @Override
    public void setPopupVisible(boolean v) {
        FileTextField fileTextField;
        if (v && (fileTextField = (FileTextField)this.getTextEditor().getClientProperty("fileTextField")) != null && fileTextField.isPopupDisplayed()) {
            return;
        }
        super.setPopupVisible(v);
    }

    protected static class TextFieldWithProcessing
    extends JTextField {
        protected TextFieldWithProcessing() {
        }

        @Override
        public void processKeyEvent(KeyEvent e) {
            super.processKeyEvent(e);
        }
    }

    public class MyModel
    extends AbstractListModel
    implements ComboBoxModel {
        private List<String> myFullList = new ArrayList<String>();
        private Object mySelectedItem;

        @Override
        public Object getElementAt(int index) {
            return this.myFullList.get(index);
        }

        @Override
        public int getSize() {
            return Math.min(TextFieldWithHistory.this.myHistorySize == -1 ? Integer.MAX_VALUE : TextFieldWithHistory.this.myHistorySize, this.myFullList.size());
        }

        public void addElement(Object obj) {
            String newItem = ((String)obj).trim();
            if (0 == newItem.length()) {
                return;
            }
            if (!this.contains(newItem)) {
                this.mySelectedItem = newItem;
                this.insertElementAt(newItem, 0);
            }
        }

        public void insertElementAt(Object obj, int index) {
            this.myFullList.add(index, (String)obj);
            this.fireContentsChanged();
        }

        @Override
        public Object getSelectedItem() {
            return this.mySelectedItem;
        }

        @Override
        public void setSelectedItem(Object anItem) {
            this.mySelectedItem = anItem;
            this.fireContentsChanged();
        }

        public void fireContentsChanged() {
            this.fireContentsChanged(this, -1, -1);
        }

        public boolean contains(String aNewValue) {
            return this.myFullList.contains(aNewValue);
        }

        public void setItems(List<String> aList) {
            this.myFullList = new ArrayList<String>(aList);
            this.fireContentsChanged();
        }
    }
}

