/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log;

import java.awt.Color;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface VcsLogHighlighter {
    @NotNull
    public VcsCommitStyle getStyle(int var1, boolean var2);

    public static class VcsCommitStyle {
        public static final VcsCommitStyle DEFAULT = new VcsCommitStyle(null, null);
        @Nullable
        private final Color myForeground;
        @Nullable
        private final Color myBackground;

        public VcsCommitStyle(@Nullable Color foreground, @Nullable Color background) {
            this.myForeground = foreground;
            this.myBackground = background;
        }

        @Nullable
        public Color getForeground() {
            return this.myForeground;
        }

        @Nullable
        public Color getBackground() {
            return this.myBackground;
        }

        @NotNull
        public static VcsCommitStyle foreground(@Nullable Color foreground) {
            VcsCommitStyle vcsCommitStyle = new VcsCommitStyle(foreground, null);
            if (vcsCommitStyle == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/VcsLogHighlighter$VcsCommitStyle", "foreground"));
            }
            return vcsCommitStyle;
        }

        @NotNull
        public static VcsCommitStyle background(@Nullable Color background) {
            VcsCommitStyle vcsCommitStyle = new VcsCommitStyle(null, background);
            if (vcsCommitStyle == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/VcsLogHighlighter$VcsCommitStyle", "background"));
            }
            return vcsCommitStyle;
        }

        public static VcsCommitStyle combine(@NotNull Collection<VcsCommitStyle> styles) {
            if (styles == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "styles", "com/intellij/vcs/log/VcsLogHighlighter$VcsCommitStyle", "combine"));
            }
            Color foreground = null;
            Color background = null;
            for (VcsCommitStyle style : styles) {
                if (foreground == null && style.getForeground() != null) {
                    foreground = style.getForeground();
                }
                if (background == null && style.getBackground() != null) {
                    background = style.getBackground();
                }
                if (background == null || foreground == null) continue;
                break;
            }
            return new VcsCommitStyle(foreground, background);
        }
    }
}

