/*
 * Decompiled with CFR 0.152.
 */
package com.pty4j.windows;

import com.pty4j.PtyProcess;
import com.pty4j.WinSize;
import com.pty4j.util.PtyUtil;
import com.pty4j.windows.NamedPipe;
import com.pty4j.windows.WinPTYInputStream;
import com.pty4j.windows.WinPTYOutputStream;
import com.pty4j.windows.WinPty;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinNT;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CygwinPtyProcess
extends PtyProcess {
    private static final int CONNECT_PIPE_TIMEOUT = 1000;
    private static final int PIPE_ACCESS_INBOUND = 1;
    private static final int PIPE_ACCESS_OUTBOUND = 2;
    private static final AtomicInteger processCounter = new AtomicInteger();
    private final Process myProcess;
    private final NamedPipe myInputPipe;
    private final NamedPipe myOutputPipe;
    private final NamedPipe myErrorPipe;
    private final WinNT.HANDLE myInputHandle;
    private final WinNT.HANDLE myOutputHandle;
    private final WinNT.HANDLE myErrorHandle;

    public CygwinPtyProcess(String[] command, Map<String, String> environment, String workingDirectory, File logFile) throws IOException {
        String pipePrefix = String.format("\\\\.\\pipe\\cygwinpty-%d-%d-", WinPty.KERNEL32.GetCurrentProcessId(), processCounter.getAndIncrement());
        String inPipeName = pipePrefix + "in";
        String outPipeName = pipePrefix + "out";
        String errPipeName = pipePrefix + "err";
        this.myInputHandle = WinPty.KERNEL32.CreateNamedPipeA(inPipeName, 0x40000002, 0, 1, 0, 0, 0, null);
        this.myOutputHandle = WinPty.KERNEL32.CreateNamedPipeA(outPipeName, 0x40000001, 0, 1, 0, 0, 0, null);
        this.myErrorHandle = WinPty.KERNEL32.CreateNamedPipeA(errPipeName, 0x40000001, 0, 1, 0, 0, 0, null);
        if (this.myInputHandle == WinBase.INVALID_HANDLE_VALUE || this.myOutputHandle == WinBase.INVALID_HANDLE_VALUE || this.myErrorHandle == WinBase.INVALID_HANDLE_VALUE) {
            this.closeHandles();
            throw new IOException("Unable to create a named pipe");
        }
        this.myInputPipe = new NamedPipe(this.myInputHandle);
        this.myOutputPipe = new NamedPipe(this.myOutputHandle);
        this.myErrorPipe = new NamedPipe(this.myErrorHandle);
        this.myProcess = this.startProcess(inPipeName, outPipeName, errPipeName, workingDirectory, command, environment, logFile);
    }

    private Process startProcess(String inPipeName, String outPipeName, String errPipeName, String workingDirectory, String[] command, Map<String, String> environment, File logFile) throws IOException {
        File nativeFile;
        try {
            nativeFile = PtyUtil.resolveNativeFile("cyglaunch.exe");
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        String logPath = logFile == null ? "null" : logFile.getAbsolutePath();
        ProcessBuilder processBuilder = new ProcessBuilder(nativeFile.getAbsolutePath(), logPath, inPipeName, outPipeName, errPipeName);
        for (String s : command) {
            processBuilder.command().add(s);
        }
        processBuilder.directory(new File(workingDirectory));
        processBuilder.environment().clear();
        processBuilder.environment().putAll(environment);
        final Process process = processBuilder.start();
        try {
            CygwinPtyProcess.waitForPipe(this.myInputHandle);
            CygwinPtyProcess.waitForPipe(this.myOutputHandle);
            CygwinPtyProcess.waitForPipe(this.myErrorHandle);
        }
        catch (IOException e) {
            process.destroy();
            this.closeHandles();
            throw e;
        }
        new Thread(){

            public void run() {
                while (true) {
                    try {
                        process.waitFor();
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
                CygwinPtyProcess.this.closeHandles();
            }
        }.start();
        return process;
    }

    private static void waitForPipe(WinNT.HANDLE handle) throws IOException {
        WinNT.HANDLE connectEvent = WinPty.KERNEL32.CreateEventA(null, true, false, null);
        WinBase.OVERLAPPED povl = new WinBase.OVERLAPPED();
        povl.hEvent = connectEvent;
        boolean success = WinPty.KERNEL32.ConnectNamedPipe(handle, povl);
        if (!success) {
            switch (WinPty.KERNEL32.GetLastError()) {
                case 535: {
                    success = true;
                    break;
                }
                case 997: {
                    if (WinPty.KERNEL32.WaitForSingleObject(connectEvent, 1000) != 0) {
                        WinPty.KERNEL32.CancelIo(handle);
                        success = false;
                        break;
                    }
                    success = true;
                }
            }
        }
        WinPty.KERNEL32.CloseHandle(connectEvent);
        if (!success) {
            throw new IOException("Cannot connect to a named pipe");
        }
    }

    @Override
    public boolean isRunning() {
        try {
            this.myProcess.exitValue();
            return false;
        }
        catch (IllegalThreadStateException e) {
            return true;
        }
    }

    @Override
    public void setWinSize(WinSize winSize) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public WinSize getWinSize() throws IOException {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public OutputStream getOutputStream() {
        return new WinPTYOutputStream(this.myInputPipe);
    }

    @Override
    public InputStream getInputStream() {
        return new WinPTYInputStream(this.myOutputPipe);
    }

    @Override
    public InputStream getErrorStream() {
        return new WinPTYInputStream(this.myErrorPipe);
    }

    @Override
    public int waitFor() throws InterruptedException {
        return this.myProcess.waitFor();
    }

    @Override
    public int exitValue() {
        return this.myProcess.exitValue();
    }

    @Override
    public void destroy() {
        this.myProcess.destroy();
    }

    private void closeHandles() {
        WinPty.KERNEL32.CloseHandle(this.myInputHandle);
        WinPty.KERNEL32.CloseHandle(this.myOutputHandle);
        WinPty.KERNEL32.CloseHandle(this.myErrorHandle);
    }
}

