/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner.events;

import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.testIntegration.TestLocationProvider;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleTestsExecutionConsoleManager;
import org.jetbrains.plugins.gradle.execution.test.runner.events.AbstractTestEvent;
import org.jetbrains.plugins.gradle.util.XmlXpathHelper;

public class BeforeSuiteEvent
extends AbstractTestEvent {
    public BeforeSuiteEvent(GradleTestsExecutionConsoleManager consoleManager) {
        super(consoleManager);
    }

    @Override
    public void process(XmlXpathHelper eventXml) throws XmlXpathHelper.XmlParserException {
        String testId = this.getTestId(eventXml);
        String parentTestId = this.getParentTestId(eventXml);
        String name = this.getTestName(eventXml);
        String fqClassName = this.getTestClassName(eventXml);
        if (StringUtil.isEmpty((String)parentTestId)) {
            this.getConsoleManager().getTestsMap().put(testId, (SMTestProxy)this.getResultsViewer().getTestsRootNode());
        } else {
            String locationUrl = this.findLocationUrl(null, fqClassName);
            final SMTestProxy testProxy = new SMTestProxy(name, true, locationUrl);
            testProxy.setLocator((TestLocationProvider)this.getConsoleManager().getUrlProvider());
            testProxy.setStarted();
            this.getConsoleManager().getTestsMap().put(testId, testProxy);
            final SMTestProxy parentTestProxy = this.getConsoleManager().getTestsMap().get(parentTestId);
            if (parentTestProxy != null) {
                this.addToInvokeLater(new Runnable(){

                    @Override
                    public void run() {
                        parentTestProxy.addChild(testProxy);
                        BeforeSuiteEvent.this.getResultsViewer().onSuiteStarted(testProxy);
                    }
                });
            }
        }
    }
}

