/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.difftool.properties;

import com.intellij.ui.table.TableView;
import com.intellij.util.ui.ListTableModel;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.difftool.properties.PropertiesTableModel;
import org.jetbrains.idea.svn.difftool.properties.SvnPropertiesDiffViewer;

public class PropertiesTableView
extends TableView<SvnPropertiesDiffViewer.PropertyDiffRecord> {
    private boolean myDuringResizing;

    public PropertiesTableView(@NotNull PropertiesTableModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "org/jetbrains/idea/svn/difftool/properties/PropertiesTableView", "<init>"));
        }
        super((ListTableModel)model);
    }

    protected void processMouseEvent(MouseEvent e) {
        this.preProcessMouseEvent(e);
        if (!e.isConsumed()) {
            super.processMouseEvent(e);
        }
    }

    protected void processMouseMotionEvent(MouseEvent e) {
        this.preProcessMouseEvent(e);
        if (!e.isConsumed()) {
            super.processMouseMotionEvent(e);
        }
    }

    private void preProcessMouseEvent(MouseEvent e) {
        boolean isNameColumn;
        Point point = e.getPoint();
        int column = this.columnAtPoint(point);
        int eventId = e.getID();
        boolean bl = isNameColumn = column == 1;
        if (eventId == 506) {
            if (this.myDuringResizing) {
                this.resizeValueColumns(point.getX(), this.getWidth());
                e.consume();
            }
        } else if (eventId == 503 || eventId == 504 || eventId == 505) {
            this.updateCursor(isNameColumn);
        } else if (eventId == 500) {
            if (isNameColumn && e.getClickCount() == 2) {
                this.resizeValueColumns(0.5);
                e.consume();
            }
        } else if (eventId == 501) {
            if (isNameColumn) {
                this.myDuringResizing = true;
            }
        } else if (eventId == 502) {
            this.myDuringResizing = false;
        }
    }

    private void resizeValueColumns(double x, int width) {
        TableColumnModel model = this.getColumnModel();
        TableColumn left = model.getColumn(0);
        TableColumn name = model.getColumn(1);
        TableColumn right = model.getColumn(2);
        int nameWidth = name.getWidth();
        int newLeftWidth = (int)(x - (double)(nameWidth / 2));
        int newRightWidth = width - newLeftWidth - nameWidth;
        left.setPreferredWidth(newLeftWidth);
        right.setPreferredWidth(newRightWidth);
    }

    private void resizeValueColumns(double ratio) {
        TableColumnModel model = this.getColumnModel();
        TableColumn left = model.getColumn(0);
        TableColumn right = model.getColumn(2);
        ratio = Math.max(0.0, Math.min(1.0, ratio));
        int totalWidth = left.getWidth() + right.getWidth();
        int newLeftWidth = (int)(ratio * (double)totalWidth);
        int newRightWidth = totalWidth - newLeftWidth;
        left.setPreferredWidth(newLeftWidth);
        right.setPreferredWidth(newRightWidth);
    }

    private void updateCursor(boolean resize) {
        int newCursorType;
        int n = newCursorType = resize ? 10 : 0;
        if (this.getCursor().getType() != newCursorType) {
            this.setCursor(Cursor.getPredefinedCursor(newCursorType));
        }
    }
}

