/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.mergeinfo;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.dialogs.WCInfoWithBranches;
import org.jetbrains.idea.svn.history.SvnChangeList;
import org.jetbrains.idea.svn.info.Info;
import org.jetbrains.idea.svn.mergeinfo.MergeInfoCached;
import org.jetbrains.idea.svn.mergeinfo.SvnMergeInfoCache;
import org.jetbrains.idea.svn.properties.PropertyValue;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNMergeRange;
import org.tmatesoft.svn.core.SVNMergeRangeList;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNMergeInfoUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class BranchInfo {
    private static final Logger LOG = Logger.getInstance(BranchInfo.class);
    @NotNull
    private final Map<String, Set<Long>> myPathMergedMap;
    @NotNull
    private final Map<String, Set<Long>> myNonInheritablePathMergedMap;
    private boolean myMixedRevisionsFound;
    @NotNull
    private final Map<Long, SvnMergeInfoCache.MergeCheckResult> myAlreadyCalculatedMap;
    @NotNull
    private final Object myCalculatedLock;
    @NotNull
    private final WCInfoWithBranches myInfo;
    @NotNull
    private final WCInfoWithBranches.Branch myBranch;
    @NotNull
    private final SvnVcs myVcs;
    private SvnMergeInfoCache.CopyRevison myCopyRevison;
    @NotNull
    private final MultiMap<Long, String> myPartlyMerged;

    public BranchInfo(@NotNull SvnVcs vcs, @NotNull WCInfoWithBranches info, @NotNull WCInfoWithBranches.Branch branch) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/mergeinfo/BranchInfo", "<init>"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "org/jetbrains/idea/svn/mergeinfo/BranchInfo", "<init>"));
        }
        if (branch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branch", "org/jetbrains/idea/svn/mergeinfo/BranchInfo", "<init>"));
        }
        this.myCalculatedLock = new Object();
        this.myVcs = vcs;
        this.myInfo = info;
        this.myBranch = branch;
        this.myPathMergedMap = ContainerUtil.newHashMap();
        this.myPartlyMerged = MultiMap.create();
        this.myNonInheritablePathMergedMap = ContainerUtil.newHashMap();
        this.myAlreadyCalculatedMap = ContainerUtil.newHashMap();
    }

    private long calculateCopyRevision(String branchPath) {
        if (this.myCopyRevison != null && Comparing.equal((String)this.myCopyRevison.getPath(), (String)branchPath)) {
            return this.myCopyRevison.getRevision();
        }
        this.myCopyRevison = new SvnMergeInfoCache.CopyRevison(this.myVcs, branchPath, this.myInfo.getRepoUrl(), this.myBranch.getUrl(), this.myInfo.getRootUrl());
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.myPathMergedMap.clear();
        Object object = this.myCalculatedLock;
        synchronized (object) {
            this.myAlreadyCalculatedMap.clear();
        }
        this.myMixedRevisionsFound = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public MergeInfoCached getCached() {
        Object object = this.myCalculatedLock;
        // MONITORENTER : object
        long revision = this.myCopyRevison != null ? this.myCopyRevison.getRevision() : -1L;
        MergeInfoCached mergeInfoCached = new MergeInfoCached(Collections.unmodifiableMap(this.myAlreadyCalculatedMap), revision);
        // MONITOREXIT : object
        if (mergeInfoCached != null) return mergeInfoCached;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/mergeinfo/BranchInfo", "getCached"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public SvnMergeInfoCache.MergeCheckResult checkList(final @NotNull SvnChangeList list, final String branchPath) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "org/jetbrains/idea/svn/mergeinfo/BranchInfo", "checkList"));
        }
        Object object = this.myCalculatedLock;
        // MONITORENTER : object
        long revision = this.calculateCopyRevision(branchPath);
        SvnMergeInfoCache.MergeCheckResult result = revision != -1L && revision >= list.getNumber() ? SvnMergeInfoCache.MergeCheckResult.COMMON : (SvnMergeInfoCache.MergeCheckResult)((Object)ContainerUtil.getOrCreate(this.myAlreadyCalculatedMap, (Object)list.getNumber(), (Factory)new Factory<SvnMergeInfoCache.MergeCheckResult>(){

            public SvnMergeInfoCache.MergeCheckResult create() {
                return BranchInfo.this.checkAlive(list, branchPath);
            }
        }));
        SvnMergeInfoCache.MergeCheckResult mergeCheckResult = result;
        // MONITOREXIT : object
        if (mergeCheckResult != null) return mergeCheckResult;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/mergeinfo/BranchInfo", "checkList"));
    }

    @NotNull
    private SvnMergeInfoCache.MergeCheckResult checkAlive(@NotNull SvnChangeList list, @NotNull String branchPath) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "org/jetbrains/idea/svn/mergeinfo/BranchInfo", "checkAlive"));
        }
        if (branchPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchPath", "org/jetbrains/idea/svn/mergeinfo/BranchInfo", "checkAlive"));
        }
        Info info = this.myVcs.getInfo(new File(branchPath));
        if (info == null || info.getURL() == null || !SVNPathUtil.isAncestor((String)this.myBranch.getUrl(), (String)info.getURL().toString())) {
            SvnMergeInfoCache.MergeCheckResult mergeCheckResult = SvnMergeInfoCache.MergeCheckResult.NOT_MERGED;
            if (mergeCheckResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/mergeinfo/BranchInfo", "checkAlive"));
            }
            return mergeCheckResult;
        }
        String subPathUnderBranch = SVNPathUtil.getRelativePath((String)this.myBranch.getUrl(), (String)info.getURL().toString());
        MultiMap<SvnMergeInfoCache.MergeCheckResult, String> result = this.checkPaths(list, branchPath, subPathUnderBranch);
        if (result.containsKey((Object)SvnMergeInfoCache.MergeCheckResult.NOT_EXISTS)) {
            SvnMergeInfoCache.MergeCheckResult mergeCheckResult = SvnMergeInfoCache.MergeCheckResult.NOT_EXISTS;
            if (mergeCheckResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/mergeinfo/BranchInfo", "checkAlive"));
            }
            return mergeCheckResult;
        }
        if (result.containsKey((Object)SvnMergeInfoCache.MergeCheckResult.NOT_MERGED)) {
            this.myPartlyMerged.put((Object)list.getNumber(), result.get((Object)SvnMergeInfoCache.MergeCheckResult.NOT_MERGED));
            SvnMergeInfoCache.MergeCheckResult mergeCheckResult = SvnMergeInfoCache.MergeCheckResult.NOT_MERGED;
            if (mergeCheckResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/mergeinfo/BranchInfo", "checkAlive"));
            }
            return mergeCheckResult;
        }
        SvnMergeInfoCache.MergeCheckResult mergeCheckResult = SvnMergeInfoCache.MergeCheckResult.MERGED;
        if (mergeCheckResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/mergeinfo/BranchInfo", "checkAlive"));
        }
        return mergeCheckResult;
    }

    @NotNull
    private MultiMap<SvnMergeInfoCache.MergeCheckResult, String> checkPaths(@NotNull SvnChangeList list, @NotNull String branchPath, String subPathUnderBranch) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "org/jetbrains/idea/svn/mergeinfo/BranchInfo", "checkPaths"));
        }
        if (branchPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchPath", "org/jetbrains/idea/svn/mergeinfo/BranchInfo", "checkPaths"));
        }
        MultiMap result = MultiMap.create();
        String myTrunkPathCorrespondingToLocalBranchPath = SVNPathUtil.append((String)this.myInfo.getCurrentBranch().getUrl(), (String)subPathUnderBranch);
        for (String path : list.getAffectedPaths()) {
            SvnMergeInfoCache.MergeCheckResult mergeCheckResult;
            String absoluteInTrunkPath = SVNPathUtil.append((String)this.myInfo.getRepoUrl(), (String)path);
            if (!absoluteInTrunkPath.startsWith(myTrunkPathCorrespondingToLocalBranchPath)) {
                mergeCheckResult = SvnMergeInfoCache.MergeCheckResult.NOT_EXISTS;
            } else {
                String relativeToTrunkPath = absoluteInTrunkPath.substring(myTrunkPathCorrespondingToLocalBranchPath.length());
                String localPathInBranch = new File(branchPath, relativeToTrunkPath).getAbsolutePath();
                try {
                    mergeCheckResult = this.checkPathGoingUp(list.getNumber(), -1L, branchPath, localPathInBranch, path, true);
                }
                catch (VcsException e) {
                    LOG.info((Throwable)e);
                    mergeCheckResult = SvnMergeInfoCache.MergeCheckResult.NOT_MERGED;
                }
                catch (SVNException e) {
                    LOG.info((Throwable)e);
                    mergeCheckResult = SvnMergeInfoCache.MergeCheckResult.NOT_MERGED;
                }
            }
            result.putValue((Object)mergeCheckResult, (Object)path);
            if (!SvnMergeInfoCache.MergeCheckResult.NOT_EXISTS.equals((Object)mergeCheckResult)) continue;
            break;
        }
        MultiMap multiMap = result;
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/mergeinfo/BranchInfo", "checkPaths"));
        }
        return multiMap;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private SvnMergeInfoCache.MergeCheckResult goUp(long revisionAsked, long targetRevision, String branchRootPath, String string, @NotNull String string2) throws SVNException, VcsException {
        Info svnInfo;
        void path;
        String newPath;
        void trunkUrl;
        if (string2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchRootPath", "org/jetbrains/idea/svn/mergeinfo/BranchInfo", "goUp"));
        }
        String newTrunkUrl = SVNPathUtil.removeTail((String)trunkUrl).trim();
        SvnMergeInfoCache.MergeCheckResult result = newTrunkUrl.length() == 0 || "/".equals(newTrunkUrl) ? SvnMergeInfoCache.MergeCheckResult.NOT_MERGED : ((newPath = new File((String)path).getParent()).length() < branchRootPath.length() ? (targetRevision == -1L ? SvnMergeInfoCache.MergeCheckResult.NOT_EXISTS : ((svnInfo = this.myVcs.getInfo(new File(branchRootPath))) == null || svnInfo.getURL() == null ? SvnMergeInfoCache.MergeCheckResult.NOT_MERGED : this.goUpInRepo(revisionAsked, targetRevision, svnInfo.getURL().removePathTail(), newTrunkUrl))) : this.checkPathGoingUp(revisionAsked, targetRevision, branchRootPath, newPath, newTrunkUrl, false));
        SvnMergeInfoCache.MergeCheckResult mergeCheckResult = result;
        if (mergeCheckResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/mergeinfo/BranchInfo", "goUp"));
        }
        return mergeCheckResult;
    }

    @NotNull
    private SvnMergeInfoCache.MergeCheckResult goUpInRepo(long revisionAsked, long targetRevision, SVNURL branchUrl, String trunkUrl) throws VcsException, SVNException {
        SvnMergeInfoCache.MergeCheckResult result;
        Set<Long> mergeInfo = this.myPathMergedMap.get(branchUrl.toString() + "@" + targetRevision);
        if (mergeInfo != null) {
            result = SvnMergeInfoCache.MergeCheckResult.getInstance(mergeInfo.contains(revisionAsked));
        } else {
            SvnTarget target = SvnTarget.fromURL((SVNURL)branchUrl);
            PropertyValue mergeinfoProperty = this.myVcs.getFactory(target).createPropertyClient().getProperty(target, "svn:mergeinfo", false, SVNRevision.create((long)targetRevision));
            if (mergeinfoProperty == null) {
                String newTrunkUrl = SVNPathUtil.removeTail((String)trunkUrl).trim();
                SVNURL newBranchUrl = branchUrl.removePathTail();
                String absoluteTrunk = SVNPathUtil.append((String)this.myInfo.getRepoUrl(), (String)newTrunkUrl);
                result = newTrunkUrl.length() <= 1 || newBranchUrl.toString().length() <= this.myInfo.getRepoUrl().length() || newBranchUrl.toString().equals(absoluteTrunk) ? SvnMergeInfoCache.MergeCheckResult.NOT_MERGED : this.goUpInRepo(revisionAsked, targetRevision, newBranchUrl, newTrunkUrl);
            } else {
                result = this.processMergeinfoProperty(branchUrl.toString() + "@" + targetRevision, revisionAsked, mergeinfoProperty, trunkUrl, false);
            }
        }
        SvnMergeInfoCache.MergeCheckResult mergeCheckResult = result;
        if (mergeCheckResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/mergeinfo/BranchInfo", "goUpInRepo"));
        }
        return mergeCheckResult;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private SvnMergeInfoCache.MergeCheckResult checkPathGoingUp(long revisionAsked, long targetRevision, @NotNull String branchRootPath, @NotNull String path, String string, boolean bl) throws VcsException, SVNException {
        SvnMergeInfoCache.MergeCheckResult result;
        void trunkUrl;
        if (branchRootPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetRevision", "org/jetbrains/idea/svn/mergeinfo/BranchInfo", "checkPathGoingUp"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/idea/svn/mergeinfo/BranchInfo", "checkPathGoingUp"));
        }
        File pathFile = new File(path);
        if (targetRevision == -1L && !pathFile.exists()) {
            result = this.goUp(revisionAsked, targetRevision, branchRootPath, path, (String)trunkUrl);
        } else {
            Info svnInfo = this.myVcs.getInfo(pathFile);
            if (svnInfo == null || svnInfo.getURL() == null) {
                LOG.info("Svninfo for " + pathFile + " is null or not full.");
                result = SvnMergeInfoCache.MergeCheckResult.NOT_MERGED;
            } else {
                void self;
                long actualRevision = svnInfo.getRevision().getNumber();
                long targetRevisionCorrected = targetRevision == -1L ? actualRevision : targetRevision;
                String keyString = path + "@" + targetRevisionCorrected;
                Set<Long> selfInfo = self != false ? this.myNonInheritablePathMergedMap.get(keyString) : null;
                Set<Long> mergeInfo = this.myPathMergedMap.get(keyString);
                if (mergeInfo != null || selfInfo != null) {
                    boolean merged = mergeInfo != null && mergeInfo.contains(revisionAsked) || selfInfo != null && selfInfo.contains(revisionAsked);
                    result = SvnMergeInfoCache.MergeCheckResult.getInstance(merged);
                } else {
                    SVNRevision revision;
                    SvnTarget target;
                    if (actualRevision != targetRevisionCorrected) {
                        this.myMixedRevisionsFound = true;
                    }
                    if (actualRevision == targetRevisionCorrected) {
                        target = SvnTarget.fromFile((File)pathFile, (SVNRevision)SVNRevision.WORKING);
                        revision = SVNRevision.WORKING;
                    } else {
                        target = SvnTarget.fromURL((SVNURL)svnInfo.getURL());
                        revision = SVNRevision.create((long)targetRevisionCorrected);
                    }
                    PropertyValue mergeinfoProperty = this.myVcs.getFactory(target).createPropertyClient().getProperty(target, "svn:mergeinfo", false, revision);
                    result = mergeinfoProperty == null ? this.goUp(revisionAsked, targetRevisionCorrected, branchRootPath, path, (String)trunkUrl) : this.processMergeinfoProperty(keyString, revisionAsked, mergeinfoProperty, (String)trunkUrl, (boolean)self);
                }
            }
        }
        SvnMergeInfoCache.MergeCheckResult mergeCheckResult = result;
        if (mergeCheckResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/mergeinfo/BranchInfo", "checkPathGoingUp"));
        }
        return mergeCheckResult;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private SvnMergeInfoCache.MergeCheckResult processMergeinfoProperty(String pathWithRevisionNumber, final long revisionAsked, @NotNull PropertyValue value, final String trunkRelativeUrl, boolean bl) throws SvnBindException {
        SvnMergeInfoCache.MergeCheckResult result;
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/idea/svn/mergeinfo/BranchInfo", "processMergeinfoProperty"));
        }
        Map<String, SVNMergeRangeList> mergedPathsMap = BranchInfo.parseMergeInfo(value);
        String mergedPathAffectingTrunkUrl = (String)ContainerUtil.find(mergedPathsMap.keySet(), (Condition)new Condition<String>(){

            public boolean value(String path) {
                return trunkRelativeUrl.startsWith(path);
            }
        });
        if (mergedPathAffectingTrunkUrl != null) {
            void self;
            SVNMergeRangeList mergeRangeList = mergedPathsMap.get(mergedPathAffectingTrunkUrl);
            this.fillMergedRevisions(pathWithRevisionNumber, mergeRangeList);
            boolean isAskedRevisionMerged = ContainerUtil.or((Object[])mergeRangeList.getRanges(), (Condition)new Condition<SVNMergeRange>((boolean)self){
                final /* synthetic */ boolean val$self;
                {
                    this.val$self = bl;
                }

                public boolean value(@NotNull SVNMergeRange range) {
                    if (range == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "org/jetbrains/idea/svn/mergeinfo/BranchInfo$3", "value"));
                    }
                    return BranchInfo.isInRange(range, revisionAsked) && (range.isInheritable() || this.val$self);
                }
            });
            result = SvnMergeInfoCache.MergeCheckResult.getInstance(isAskedRevisionMerged);
        } else {
            this.myPathMergedMap.put(pathWithRevisionNumber, Collections.emptySet());
            result = SvnMergeInfoCache.MergeCheckResult.NOT_MERGED;
        }
        SvnMergeInfoCache.MergeCheckResult mergeCheckResult = result;
        if (mergeCheckResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/mergeinfo/BranchInfo", "processMergeinfoProperty"));
        }
        return mergeCheckResult;
    }

    @NotNull
    public static Map<String, SVNMergeRangeList> parseMergeInfo(@NotNull PropertyValue value) throws SvnBindException {
        Map map;
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/idea/svn/mergeinfo/BranchInfo", "parseMergeInfo"));
        }
        try {
            map = SVNMergeInfoUtil.parseMergeInfo((StringBuffer)new StringBuffer(value.toString().replace('\r', '\n').replace("\n\n", "\n")), null);
        }
        catch (SVNException e) {
            throw new SvnBindException(e);
        }
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/mergeinfo/BranchInfo", "parseMergeInfo"));
        }
        return map;
    }

    private void fillMergedRevisions(String pathWithRevisionNumber, @NotNull SVNMergeRangeList mergeRangeList) {
        if (mergeRangeList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergeRangeList", "org/jetbrains/idea/svn/mergeinfo/BranchInfo", "fillMergedRevisions"));
        }
        HashSet revisions = ContainerUtil.newHashSet();
        HashSet nonInheritableRevisions = ContainerUtil.newHashSet();
        for (SVNMergeRange range : mergeRangeList.getRanges()) {
            (range.isInheritable() ? revisions : nonInheritableRevisions).addAll(BranchInfo.toRevisionsList(range));
        }
        this.myPathMergedMap.put(pathWithRevisionNumber, revisions);
        if (!nonInheritableRevisions.isEmpty()) {
            this.myNonInheritablePathMergedMap.put(pathWithRevisionNumber, nonInheritableRevisions);
        }
    }

    @NotNull
    private static Collection<Long> toRevisionsList(@NotNull SVNMergeRange range) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "org/jetbrains/idea/svn/mergeinfo/BranchInfo", "toRevisionsList"));
        }
        ArrayList result = ContainerUtil.newArrayList();
        for (long i = range.getStartRevision() + 1L; i <= range.getEndRevision(); ++i) {
            result.add(i);
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/mergeinfo/BranchInfo", "toRevisionsList"));
        }
        return arrayList;
    }

    public static boolean isInRange(@NotNull SVNMergeRange range, long revision) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "org/jetbrains/idea/svn/mergeinfo/BranchInfo", "isInRange"));
        }
        return revision > range.getStartRevision() && revision <= range.getEndRevision();
    }

    public boolean isMixedRevisionsFound() {
        return this.myMixedRevisionsFound;
    }

    @NotNull
    public Collection<String> getNotMergedPaths(long number) {
        Collection collection = this.myPartlyMerged.get((Object)number);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/mergeinfo/BranchInfo", "getNotMergedPaths"));
        }
        return collection;
    }
}

