/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.rendering.api.LayoutLog;
import com.android.tools.idea.rendering.LayoutPsiPullParser;
import com.android.tools.idea.rendering.RenderService;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MenuPsiPullParser
extends LayoutPsiPullParser.AttributeFilteredLayoutParser {
    private static final String[] FILTERS = new String[]{"onClick", "actionViewClass", "actionLayout"};

    public MenuPsiPullParser(XmlFile file, LayoutLog logger) {
        super(file, logger, new RenderService.AttributeFilter(){

            @Override
            @Nullable
            public String getAttribute(@NotNull XmlTag node, @Nullable String namespace, @NotNull String localName) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/idea/rendering/MenuPsiPullParser$1", "getAttribute"));
                }
                if (localName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localName", "com/android/tools/idea/rendering/MenuPsiPullParser$1", "getAttribute"));
                }
                if ("http://schemas.android.com/apk/res/android".equals(namespace)) {
                    if (localName.equals("showAsAction")) {
                        return this.getShowAsActionValue(node);
                    }
                    for (String filter : FILTERS) {
                        if (!filter.equals(localName)) continue;
                        return "";
                    }
                }
                return null;
            }

            @Nullable
            private String getShowAsActionValue(@NotNull XmlTag node) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/idea/rendering/MenuPsiPullParser$1", "getShowAsActionValue"));
                }
                if (node.getAttribute("showAsAction", "http://schemas.android.com/apk/res/android") != null || node.getAttribute("showAsAction", "http://schemas.android.com/tools") != null) {
                    return null;
                }
                XmlAttribute attr = node.getAttribute("showAsAction", "http://schemas.android.com/apk/res-auto");
                if (attr != null) {
                    return attr.getValue();
                }
                return null;
            }
        });
    }

    @Override
    @Nullable
    public Object getViewCookie() {
        LayoutPsiPullParser.Element element;
        if (this.myProvideViewCookies && (element = this.getCurrentNode()) != null) {
            LayoutPsiPullParser.Element previousElement;
            if (element.tag.equals("menu") && (previousElement = this.getPreviousNode()) != null) {
                return previousElement.cookie;
            }
            return element.cookie;
        }
        return null;
    }
}

