/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.core;

import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import java.util.List;
import org.gradle.api.GradleException;
import org.gradle.api.Nullable;
import org.gradle.internal.exceptions.Contextual;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelPath {
    public static final String SEPARATOR = ".";
    public static final Splitter PATH_SPLITTER = Splitter.on((char)'.');
    public static final Joiner PATH_JOINER = Joiner.on((char)'.');
    private final String path;
    private static final CharMatcher VALID_FIRST_CHAR_MATCHER = CharMatcher.inRange((char)'a', (char)'z').or(CharMatcher.inRange((char)'A', (char)'Z')).or(CharMatcher.is((char)'_'));
    private static final CharMatcher INVALID_FIRST_CHAR_MATCHER = VALID_FIRST_CHAR_MATCHER.negate().precomputed();
    private static final CharMatcher INVALID_CHAR_MATCHER = CharMatcher.inRange((char)'0', (char)'9').or(VALID_FIRST_CHAR_MATCHER).negate().precomputed();

    public ModelPath(String path) {
        this.path = path;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModelPath modelPath = (ModelPath)o;
        return this.path.equals(modelPath.path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public String toString() {
        return this.path;
    }

    public static ModelPath path(String path) {
        return new ModelPath(path);
    }

    public static ModelPath path(Iterable<String> names) {
        return ModelPath.path(PATH_JOINER.join(names));
    }

    public static String pathString(Iterable<String> names) {
        return PATH_JOINER.join(names);
    }

    public ModelPath child(String child) {
        return ModelPath.path(this.path + SEPARATOR + child);
    }

    public ModelPath getParent() {
        int lastIndex = this.path.lastIndexOf(SEPARATOR);
        if (lastIndex == -1) {
            return null;
        }
        return ModelPath.path(this.path.substring(0, lastIndex));
    }

    public String getName() {
        int lastIndex = this.path.lastIndexOf(SEPARATOR);
        if (lastIndex == -1) {
            return this.path;
        }
        return this.path.substring(lastIndex + 1);
    }

    public boolean isDirectChild(ModelPath other) {
        ModelPath otherParent = other.getParent();
        return otherParent != null && otherParent.equals(this);
    }

    public static void validateName(String name) {
        if (name.isEmpty()) {
            throw new InvalidNameException("Cannot use an empty string as a model element name.");
        }
        char firstChar = name.charAt(0);
        if (INVALID_FIRST_CHAR_MATCHER.matches(firstChar)) {
            throw new InvalidNameException(String.format("Model element name '%s' has illegal first character '%s' (names must start with an ASCII letter or underscore).", name, Character.valueOf(firstChar)));
        }
        for (int i = 1; i < name.length(); ++i) {
            char character = name.charAt(i);
            if (!INVALID_CHAR_MATCHER.matches(character)) continue;
            throw new InvalidNameException(String.format("Model element name '%s' contains illegal character '%s' (only ASCII letters, numbers and the underscore are allowed).", name, Character.valueOf(character)));
        }
    }

    @Nullable
    public static ModelPath validatedPath(@Nullable String path) {
        if (path == null) {
            return null;
        }
        ModelPath.validatePath(path);
        return ModelPath.path(path);
    }

    public static ModelPath nonNullValidatedPath(String path) {
        if (path == null) {
            throw new IllegalArgumentException("path cannot be null");
        }
        return ModelPath.validatedPath(path);
    }

    public static void validatePath(String path) throws InvalidPathException {
        if (path.isEmpty()) {
            throw new InvalidPathException("Cannot use an empty string as a model path.", null);
        }
        if (path.startsWith(SEPARATOR)) {
            throw new InvalidPathException(String.format("Model path '%s' cannot start with name separator '%s'.", path, SEPARATOR), null);
        }
        if (path.endsWith(SEPARATOR)) {
            throw new InvalidPathException(String.format("Model path '%s' cannot end with name separator '%s'.", path, SEPARATOR), null);
        }
        List names = PATH_SPLITTER.splitToList((CharSequence)path);
        if (names.size() == 1) {
            ModelPath.validateName((String)names.get(0));
        } else {
            for (String name : names) {
                try {
                    ModelPath.validateName(name);
                }
                catch (InvalidNameException e) {
                    throw new InvalidPathException(String.format("Model path '%s' is invalid due to invalid name component.", path), e);
                }
            }
        }
    }

    @Contextual
    public static class InvalidPathException
    extends GradleException {
        public InvalidPathException(String message, InvalidNameException e) {
            super(message, (Throwable)((Object)e));
        }
    }

    public static class InvalidNameException
    extends GradleException {
        public InvalidNameException(String message) {
            super(message);
        }
    }
}

