/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.report.unbound;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnboundRuleInput {
    private final String path;
    private final String type;
    private final boolean bound;
    private final String description;
    private final Collection<String> suggestedPaths;

    public String getPath() {
        return this.path;
    }

    public String getType() {
        return this.type;
    }

    public boolean isBound() {
        return this.bound;
    }

    public Collection<? extends String> getSuggestedPaths() {
        return this.suggestedPaths;
    }

    public String getDescription() {
        return this.description;
    }

    private UnboundRuleInput(String path, String type, boolean bound, List<String> suggestedPaths, String description) {
        this.path = path;
        this.type = type;
        this.bound = bound;
        this.suggestedPaths = suggestedPaths;
        this.description = description;
    }

    public static Builder type(String type) {
        return new Builder(type);
    }

    public static Builder type(Class<?> type) {
        return UnboundRuleInput.type(type.getName());
    }

    public static Builder type(ModelType<?> type) {
        return UnboundRuleInput.type(type.toString());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        private String path;
        private String type;
        private boolean bound;
        private List<String> suggestedPaths = new ArrayList<String>();
        private String description;

        private Builder(String type) {
            this.type = type;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder path(ModelPath path) {
            return this.path(path.toString());
        }

        public Builder bound() {
            this.bound = true;
            return this;
        }

        public Builder suggestions(Collection<? extends String> suggestedPaths) {
            this.suggestedPaths.addAll(suggestedPaths);
            return this;
        }

        public Builder suggestions(String ... suggestedPath) {
            return this.suggestions(Arrays.asList(suggestedPath));
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public UnboundRuleInput build() {
            return new UnboundRuleInput(this.path, this.type, this.bound, this.suggestedPaths, this.description);
        }
    }
}

