/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions.dynamic;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.annotator.intentions.QuickfixUtil;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.DynamicManager;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.ui.DynamicElementSettings;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.ui.DynamicPropertyDialog;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;

public class DynamicPropertyFix
extends GroovyFix
implements IntentionAction,
LowPriorityAction {
    private final GrReferenceExpression myReferenceExpression;
    private final GrArgumentLabel myArgumentLabel;
    private final PsiClass myTargetClass;

    public DynamicPropertyFix(GrReferenceExpression referenceExpression) {
        this.myReferenceExpression = referenceExpression;
        this.myArgumentLabel = null;
        this.myTargetClass = null;
    }

    public DynamicPropertyFix(GrArgumentLabel argumentLabel, PsiClass targetClass) {
        this.myArgumentLabel = argumentLabel;
        this.myReferenceExpression = null;
        this.myTargetClass = targetClass;
    }

    @NotNull
    public String getText() {
        String string = GroovyBundle.message("add.dynamic.property", this.getRefName());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/annotator/intentions/dynamic/DynamicPropertyFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/annotator/intentions/dynamic/DynamicPropertyFix", "getName"));
        }
        return string;
    }

    @Nullable
    private String getRefName() {
        if (this.myReferenceExpression != null) {
            return this.myReferenceExpression.getReferenceName();
        }
        return this.myArgumentLabel.getName();
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = GroovyBundle.message("add.dynamic.element", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/annotator/intentions/dynamic/DynamicPropertyFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile psiFile) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/annotator/intentions/dynamic/DynamicPropertyFix", "isAvailable"));
        }
        return !(this.myReferenceExpression != null && !this.myReferenceExpression.isValid() || this.myArgumentLabel != null && !this.myArgumentLabel.isValid());
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile psiFile) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/annotator/intentions/dynamic/DynamicPropertyFix", "invoke"));
        }
        this.invokeInner();
    }

    private void invokeInner() {
        DynamicPropertyDialog dialog = this.myReferenceExpression != null ? new DynamicPropertyDialog(this.myReferenceExpression) : new DynamicPropertyDialog(this.myArgumentLabel, this.myTargetClass);
        dialog.show();
    }

    @Override
    protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
        this.invokeInner();
    }

    public void invoke(Project project) throws IncorrectOperationException {
        DynamicElementSettings settings = this.myReferenceExpression != null ? QuickfixUtil.createSettings(this.myReferenceExpression) : QuickfixUtil.createSettings(this.myArgumentLabel, this.myTargetClass);
        DynamicManager.getInstance(project).addProperty(settings);
    }

    public boolean startInWriteAction() {
        return false;
    }

    public GrReferenceExpression getReferenceExpression() {
        return this.myReferenceExpression;
    }
}

