/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PathMappingSettings
implements Cloneable {
    @NotNull
    private List<PathMapping> myPathMappings;

    public PathMappingSettings(@Nullable List<PathMapping> pathMappings) {
        this.myPathMappings = PathMappingSettings.create(pathMappings);
    }

    @NotNull
    private static List<PathMapping> create(@Nullable List<PathMapping> mappings) {
        ArrayList<PathMapping> result = ContainerUtil.newArrayList();
        if (mappings != null) {
            for (PathMapping m : mappings) {
                if (m == null || PathMappingSettings.areBothEmpty(m.myLocalRoot, m.myRemoteRoot)) continue;
                result.add(m);
            }
        }
        ArrayList<PathMapping> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/PathMappingSettings", "create"));
        }
        return arrayList;
    }

    public PathMappingSettings() {
        this.myPathMappings = ContainerUtil.newArrayList();
    }

    public List<String> convertToRemote(Collection<String> paths) {
        ArrayList<String> result = ContainerUtil.newArrayList();
        for (String p : paths) {
            result.add(this.convertToRemote(p));
        }
        return result;
    }

    public boolean isEmpty() {
        return this.myPathMappings.isEmpty();
    }

    @NotNull
    public String convertToLocal(String remotePath) {
        BestMappingSelector selector = new BestMappingSelector();
        for (PathMapping mapping : this.myPathMappings) {
            if (!mapping.canReplaceRemote(remotePath)) continue;
            selector.consider(mapping, mapping.getRemoteLen());
        }
        if (selector.get() != null) {
            String string = selector.get().mapToLocal(remotePath);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/PathMappingSettings", "convertToLocal"));
            }
            return string;
        }
        String string = remotePath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/PathMappingSettings", "convertToLocal"));
        }
        return string;
    }

    public String convertToRemote(String localPath) {
        BestMappingSelector selector = new BestMappingSelector();
        for (PathMapping mapping : this.myPathMappings) {
            if (!mapping.canReplaceLocal(localPath)) continue;
            selector.consider(mapping, mapping.getLocalLen());
        }
        if (selector.get() != null) {
            return selector.get().mapToRemote(localPath);
        }
        return localPath;
    }

    public void add(PathMapping mapping) {
        if (PathMappingSettings.areBothEmpty(mapping.myLocalRoot, mapping.myRemoteRoot)) {
            return;
        }
        this.myPathMappings.add(mapping);
    }

    public void addMapping(String local, String remote) {
        PathMapping mapping = new PathMapping(local, remote);
        this.add(mapping);
    }

    public void addMappingCheckUnique(String local, String remote) {
        for (PathMapping mapping : this.myPathMappings) {
            if (!PathMappingSettings.pathEquals(local, mapping.getLocalRoot()) || !PathMappingSettings.pathEquals(remote, mapping.getRemoteRoot())) continue;
            return;
        }
        this.addMapping(local, remote);
    }

    private static boolean pathEquals(@NotNull String path1, @NotNull String path2) {
        if (path1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path1", "com/intellij/util/PathMappingSettings", "pathEquals"));
        }
        if (path2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path2", "com/intellij/util/PathMappingSettings", "pathEquals"));
        }
        return PathMappingSettings.norm(path1).equals(PathMappingSettings.norm(path2));
    }

    public boolean canReplaceRemote(String remotePath) {
        for (PathMapping mapping : this.myPathMappings) {
            if (!mapping.canReplaceRemote(remotePath)) continue;
            return true;
        }
        return false;
    }

    public boolean canReplaceLocal(String localPath) {
        for (PathMapping mapping : this.myPathMappings) {
            if (!mapping.canReplaceLocal(localPath)) continue;
            return true;
        }
        return false;
    }

    private static String norm(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/util/PathMappingSettings", "norm"));
        }
        return FileUtil.toSystemIndependentName(path);
    }

    private static String normLocal(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/util/PathMappingSettings", "normLocal"));
        }
        if (SystemInfo.isWindows) {
            path = path.toLowerCase();
        }
        return PathMappingSettings.norm(path);
    }

    public boolean isUseMapping() {
        return !this.myPathMappings.isEmpty();
    }

    @NotNull
    public List<PathMapping> getPathMappings() {
        List<PathMapping> list = this.myPathMappings;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/PathMappingSettings", "getPathMappings"));
        }
        return list;
    }

    public void setPathMappings(@Nullable List<PathMapping> pathMappings) {
        this.myPathMappings = PathMappingSettings.create(pathMappings);
    }

    @NotNull
    public static String mapToLocal(String path, String remoteRoot, String localRoot) {
        if (PathMappingSettings.areBothEmpty(localRoot, remoteRoot)) {
            String string = path;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/PathMappingSettings", "mapToLocal"));
            }
            return string;
        }
        path = PathMappingSettings.norm(path);
        String remotePrefix = PathMappingSettings.norm(remoteRoot);
        String string = path = path.replace(remotePrefix, PathMappingSettings.norm(localRoot));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/PathMappingSettings", "mapToLocal"));
        }
        return string;
    }

    public static boolean areBothEmpty(String localRoot, String remoteRoot) {
        return StringUtil.isEmpty(localRoot) || StringUtil.isEmpty(remoteRoot);
    }

    @Nullable
    public static PathMappingSettings readExternal(@Nullable Element element) {
        if (element == null) {
            return null;
        }
        Element settingsElement = element.getChild(PathMappingSettings.class.getSimpleName());
        if (settingsElement == null) {
            return null;
        }
        return XmlSerializer.deserialize(settingsElement, PathMappingSettings.class);
    }

    public static void writeExternal(@Nullable Element element, @Nullable PathMappingSettings mappings) {
        if (element == null || mappings == null || !mappings.isUseMapping()) {
            return;
        }
        element.addContent(XmlSerializer.serialize(mappings));
    }

    public void addAll(@NotNull PathMappingSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/util/PathMappingSettings", "addAll"));
        }
        this.myPathMappings.addAll(settings.getPathMappings());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PathMappingSettings settings = (PathMappingSettings)o;
        return ((Object)this.myPathMappings).equals(settings.myPathMappings);
    }

    public int hashCode() {
        return ((Object)this.myPathMappings).hashCode();
    }

    @Tag(value="mapping")
    public static class PathMapping {
        private String myLocalRoot;
        private String myRemoteRoot;

        public PathMapping() {
        }

        public PathMapping(String localRoot, String remoteRoot) {
            this.myLocalRoot = PathMapping.normalize(localRoot);
            this.myRemoteRoot = PathMapping.normalize(remoteRoot);
        }

        @Nullable
        private static String normalize(@Nullable String path) {
            if (path == null) {
                return null;
            }
            return PathMapping.trimSlash(FileUtil.toSystemIndependentName(path));
        }

        @Attribute(value="local-root")
        public String getLocalRoot() {
            return this.myLocalRoot;
        }

        @Attribute(value="remote-root")
        public String getRemoteRoot() {
            return this.myRemoteRoot;
        }

        private int getLocalLen() {
            return this.myLocalRoot != null ? this.myLocalRoot.length() : -1;
        }

        private int getRemoteLen() {
            return this.myRemoteRoot != null ? this.myRemoteRoot.length() : -1;
        }

        public void setLocalRoot(String localRoot) {
            this.myLocalRoot = localRoot;
        }

        public void setRemoteRoot(String remoteRoot) {
            this.myRemoteRoot = remoteRoot;
        }

        @NotNull
        public String mapToLocal(@NotNull String path) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/util/PathMappingSettings$PathMapping", "mapToLocal"));
            }
            String string = PathMappingSettings.mapToLocal(path, this.myRemoteRoot, this.myLocalRoot);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/PathMappingSettings$PathMapping", "mapToLocal"));
            }
            return string;
        }

        public boolean canReplaceLocal(@NotNull String path) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/util/PathMappingSettings$PathMapping", "canReplaceLocal"));
            }
            if (this.isEmpty()) {
                return false;
            }
            String localPrefix = PathMappingSettings.normLocal(this.myLocalRoot);
            return !localPrefix.isEmpty() && PathMappingSettings.normLocal(path).startsWith(localPrefix);
        }

        public String mapToRemote(@NotNull String path) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/util/PathMappingSettings$PathMapping", "mapToRemote"));
            }
            if (this.isEmpty()) {
                return path;
            }
            if (this.canReplaceLocal(path)) {
                return PathMappingSettings.norm(this.myRemoteRoot) + PathMappingSettings.norm(path).substring(PathMappingSettings.normLocal(this.myLocalRoot).length());
            }
            return path;
        }

        private boolean isEmpty() {
            return PathMappingSettings.areBothEmpty(this.myLocalRoot, this.myRemoteRoot);
        }

        private static String trimSlash(String s) {
            return StringUtil.trimEnd(s, "/");
        }

        public boolean canReplaceRemote(String path) {
            if (this.isEmpty()) {
                return false;
            }
            path = PathMappingSettings.norm(path);
            String remotePrefix = PathMappingSettings.norm(this.myRemoteRoot);
            return !this.myRemoteRoot.isEmpty() && path.startsWith(remotePrefix);
        }

        public PathMapping clone() {
            return new PathMapping(this.myLocalRoot, this.myRemoteRoot);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PathMapping mapping = (PathMapping)o;
            if (this.myLocalRoot != null ? !this.myLocalRoot.equals(mapping.myLocalRoot) : mapping.myLocalRoot != null) {
                return false;
            }
            return !(this.myRemoteRoot != null ? !this.myRemoteRoot.equals(mapping.myRemoteRoot) : mapping.myRemoteRoot != null);
        }

        public int hashCode() {
            int result = this.myLocalRoot != null ? this.myLocalRoot.hashCode() : 0;
            result = 31 * result + (this.myRemoteRoot != null ? this.myRemoteRoot.hashCode() : 0);
            return result;
        }
    }

    private static class BestMappingSelector {
        private int myBestWeight = -1;
        private PathMapping myBest = null;

        private BestMappingSelector() {
        }

        public void consider(PathMapping mapping, int weight) {
            if (weight > this.myBestWeight) {
                this.myBestWeight = weight;
                this.myBest = mapping;
            }
        }

        @Nullable
        public PathMapping get() {
            return this.myBest;
        }
    }
}

