/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.findUsages;

import com.intellij.find.FindBundle;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.JavaFindUsagesDialog;
import com.intellij.find.findUsages.JavaThrowFindUsagesOptions;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.search.ThrowSearchUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.StateRestoringCheckBox;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class FindThrowUsagesDialog
extends JavaFindUsagesDialog<JavaThrowFindUsagesOptions> {
    private StateRestoringCheckBox myCbUsages;
    private JComboBox myCbExns;
    private boolean myHasFindWhatPanel;
    private ThrowSearchUtil.Root[] myRoots;

    public FindThrowUsagesDialog(@NotNull PsiElement element, @NotNull Project project, @NotNull JavaThrowFindUsagesOptions findUsagesOptions, boolean toShowInNewTab, boolean mustOpenInNewTab, boolean isSingleFile, @NotNull FindUsagesHandler handler) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/find/findUsages/FindThrowUsagesDialog", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/find/findUsages/FindThrowUsagesDialog", "<init>"));
        }
        if (findUsagesOptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "findUsagesOptions", "com/intellij/find/findUsages/FindThrowUsagesDialog", "<init>"));
        }
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/find/findUsages/FindThrowUsagesDialog", "<init>"));
        }
        super(element, project, findUsagesOptions, toShowInNewTab, mustOpenInNewTab, isSingleFile, handler);
    }

    @Override
    protected void init() {
        this.myRoots = ThrowSearchUtil.getSearchRoots(this.myPsiElement);
        super.init();
    }

    @Override
    public JComponent getPreferredFocusedControl() {
        return this.myHasFindWhatPanel ? this.myCbUsages : null;
    }

    @Override
    protected JComponent createNorthPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.insets = new Insets(0, 0, 4, 0);
        gbConstraints.fill = 1;
        gbConstraints.weightx = 1.0;
        gbConstraints.weighty = 1.0;
        gbConstraints.anchor = 13;
        this.myCbExns = new JComboBox<ThrowSearchUtil.Root>(this.myRoots);
        panel.add((Component)this.myCbExns, gbConstraints);
        return panel;
    }

    @Override
    public void calcFindUsagesOptions(JavaThrowFindUsagesOptions options) {
        super.calcFindUsagesOptions(options);
        options.isUsages = FindThrowUsagesDialog.isSelected(this.myCbUsages) || !this.myHasFindWhatPanel;
    }

    @Override
    protected JPanel createFindWhatPanel() {
        JPanel findWhatPanel = new JPanel();
        findWhatPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)FindBundle.message("find.what.group", new Object[0]), (boolean)true));
        findWhatPanel.setLayout(new BoxLayout(findWhatPanel, 1));
        this.myCbUsages = this.addCheckboxToPanel(FindBundle.message("find.what.usages.checkbox", new Object[0]), this.myFindUsagesOptions.isUsages, findWhatPanel, true);
        this.myHasFindWhatPanel = true;
        return findWhatPanel;
    }

    @Override
    protected void doOKAction() {
        ((JavaThrowFindUsagesOptions)this.getFindUsagesOptions()).setRoot((ThrowSearchUtil.Root)this.myCbExns.getSelectedItem());
        super.doOKAction();
    }

    @Override
    protected void update() {
        if (!this.myHasFindWhatPanel) {
            this.setOKActionEnabled(true);
        } else {
            ((JavaThrowFindUsagesOptions)this.getFindUsagesOptions()).setRoot((ThrowSearchUtil.Root)this.myCbExns.getSelectedItem());
            boolean hasSelected = FindThrowUsagesDialog.isSelected(this.myCbUsages);
            this.setOKActionEnabled(hasSelected);
        }
    }
}

