/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core;

import com.intellij.history.FileRevisionTimestampComparator;
import com.intellij.history.core.ChangeSetsProcessor;
import com.intellij.history.core.Content;
import com.intellij.history.core.LocalHistoryFacade;
import com.intellij.history.core.changes.Change;
import com.intellij.history.core.changes.ChangeSet;
import com.intellij.history.core.changes.ChangeVisitor;
import com.intellij.history.core.changes.ContentChange;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.List;

public class ByteContentRetriever
extends ChangeSetsProcessor {
    private final LocalHistoryFacade myVcs;
    private final FileRevisionTimestampComparator myComparator;
    private long myCurrentFileTimestamp;
    private Content myCurrentFileContent;

    public ByteContentRetriever(IdeaGateway gateway, LocalHistoryFacade vcs, VirtualFile file, FileRevisionTimestampComparator c) {
        super(file.getPath());
        this.myVcs = vcs;
        this.myComparator = c;
        Entry e = gateway.createTransientEntry(file);
        this.myCurrentFileContent = e.getContent();
        this.myCurrentFileTimestamp = e.getTimestamp();
    }

    public byte[] getResult() {
        try {
            this.checkCurrentRevision();
            this.process();
        }
        catch (ContentFoundException ignore) {
            return this.myCurrentFileContent.getBytesIfAvailable();
        }
        return null;
    }

    @Override
    protected Pair<String, List<ChangeSet>> collectChanges() {
        final ArrayList result = new ArrayList();
        this.myVcs.accept(new ChangeVisitor(){

            @Override
            public void begin(ChangeSet c) throws ChangeVisitor.StopVisitingException {
                if (c.affectsPath(ByteContentRetriever.this.myPath)) {
                    result.add(c);
                }
            }
        });
        return Pair.create((Object)this.myPath, result);
    }

    @Override
    protected void nothingToVisit() {
        this.checkCurrentRevision();
    }

    @Override
    public void visit(ChangeSet changeSet) {
        this.checkCurrentRevision();
        this.recordContentAndTimestamp(changeSet);
    }

    private void checkCurrentRevision() {
        if (this.myComparator.isSuitable(this.myCurrentFileTimestamp)) {
            throw new ContentFoundException();
        }
    }

    private void recordContentAndTimestamp(ChangeSet c) {
        for (Change each : c.getChanges()) {
            ContentChange cc;
            if (!(each instanceof ContentChange) || !(cc = (ContentChange)each).affectsPath(this.myPath)) continue;
            this.myCurrentFileTimestamp = cc.getOldTimestamp();
            this.myCurrentFileContent = cc.getOldContent();
        }
    }

    private static class ContentFoundException
    extends RuntimeException {
        private ContentFoundException() {
        }
    }
}

