/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.concurrency.JobScheduler;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.notification.NotificationsConfiguration;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.SystemProperties;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.PropertyKey;

public class SystemHealthMonitor
extends ApplicationComponent.Adapter {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.SystemHealthMonitor");
    private static final NotificationGroup GROUP = new NotificationGroup("System Health", NotificationDisplayType.STICKY_BALLOON, false);
    private static final NotificationGroup LOG_GROUP = NotificationGroup.logOnlyGroup((String)"System Health (minor)");
    @NotNull
    private final PropertiesComponent myProperties;

    public SystemHealthMonitor(@NotNull PropertiesComponent properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/ide/SystemHealthMonitor", "<init>"));
        }
        this.myProperties = properties;
    }

    public void initComponent() {
        this.checkJvm();
        SystemHealthMonitor.startDiskSpaceMonitoring();
    }

    private void checkJvm() {
        if (StringUtil.containsIgnoreCase((String)System.getProperty("java.vm.name", ""), (String)"OpenJDK") && !SystemInfo.isJavaVersionAtLeast((String)"1.7")) {
            this.notifyUnsupportedJvm("unsupported.jvm.openjdk.message");
        } else if (StringUtil.endsWithIgnoreCase((String)System.getProperty("java.version", ""), (String)"-ea")) {
            this.notifyUnsupportedJvm("unsupported.jvm.ea.message");
        }
    }

    private void notifyUnsupportedJvm(@PropertyKey(resourceBundle="messages.IdeBundle") String key) {
        final String ignoreKey = "ignore." + key;
        String message = IdeBundle.message((String)key, (Object[])new Object[0]) + IdeBundle.message((String)"unsupported.jvm.link", (Object[])new Object[0]);
        this.showNotification(ignoreKey, message, new HyperlinkAdapter(){

            protected void hyperlinkActivated(HyperlinkEvent e) {
                SystemHealthMonitor.this.myProperties.setValue(ignoreKey, "true");
            }
        });
    }

    private void showNotification(String ignoreKey, final String message, final HyperlinkAdapter hyperlinkAdapter) {
        if (this.myProperties.isValueSet(ignoreKey)) {
            return;
        }
        final Application app = ApplicationManager.getApplication();
        app.getMessageBus().connect((Disposable)app).subscribe(AppLifecycleListener.TOPIC, (Object)new AppLifecycleListener.Adapter(){

            @Override
            public void appFrameCreated(String[] commandLineArgs, @NotNull Ref<Boolean> willOpenProject) {
                if (willOpenProject == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "willOpenProject", "com/intellij/ide/SystemHealthMonitor$2", "appFrameCreated"));
                }
                app.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JRootPane component = WindowManager.getInstance().findVisibleFrame().getRootPane();
                        if (component != null) {
                            Rectangle rect = component.getVisibleRect();
                            JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(message, MessageType.WARNING, (HyperlinkListener)hyperlinkAdapter).setFadeoutTime(-1L).setHideOnFrameResize(false).setHideOnLinkClick(true).setDisposable((Disposable)app).createBalloon().show(new RelativePoint((Component)component, new Point(rect.x + 30, rect.y + rect.height - 10)), Balloon.Position.above);
                        }
                        Notification notification = LOG_GROUP.createNotification(message, NotificationType.WARNING);
                        notification.setImportant(true);
                        Notifications.Bus.notify((Notification)notification);
                    }
                });
            }
        });
    }

    private static void startDiskSpaceMonitoring() {
        if (SystemProperties.getBooleanProperty((String)"idea.no.system.path.space.monitoring", (boolean)false)) {
            return;
        }
        final File file = new File(PathManager.getSystemPath());
        final AtomicBoolean reported = new AtomicBoolean();
        final ThreadLocal ourFreeSpaceCalculation = new ThreadLocal();
        JobScheduler.getScheduler().schedule(new Runnable(){
            private static final long LOW_DISK_SPACE_THRESHOLD = 0x3200000L;
            private static final long MAX_WRITE_SPEED_IN_BPS = 524288000L;

            @Override
            public void run() {
                if (!reported.get()) {
                    Future future = (Future)ourFreeSpaceCalculation.get();
                    if (future == null) {
                        future = ApplicationManager.getApplication().executeOnPooledThread((Callable)new Callable<Long>(){

                            @Override
                            public Long call() throws Exception {
                                long fileUsableSpace = file.getUsableSpace();
                                while (fileUsableSpace == 0L) {
                                    Thread.sleep(5000L);
                                    fileUsableSpace = file.getUsableSpace();
                                }
                                return fileUsableSpace;
                            }
                        });
                        ourFreeSpaceCalculation.set(future);
                    }
                    if (!future.isDone() || future.isCancelled()) {
                        JobScheduler.getScheduler().schedule(this, 1L, TimeUnit.SECONDS);
                        return;
                    }
                    try {
                        final long fileUsableSpace = (Long)future.get();
                        final long timeout = Math.max(5L, (fileUsableSpace - 0x3200000L) / 524288000L);
                        ourFreeSpaceCalculation.set(null);
                        if (fileUsableSpace < 0x3200000L) {
                            if (!this.notificationsComponentIsLoaded()) {
                                ourFreeSpaceCalculation.set(future);
                                JobScheduler.getScheduler().schedule(this, 1L, TimeUnit.SECONDS);
                                return;
                            }
                            reported.compareAndSet(false, true);
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    String productName = ApplicationNamesInfo.getInstance().getFullProductName();
                                    String message = IdeBundle.message((String)"low.disk.space.message", (Object[])new Object[]{productName});
                                    if (fileUsableSpace < 102400L) {
                                        LOG.warn(message);
                                        Messages.showErrorDialog((String)message, (String)"Fatal Configuration Problem");
                                        reported.compareAndSet(true, false);
                                        this.restart(timeout);
                                    } else {
                                        GROUP.createNotification(message, file.getPath(), NotificationType.ERROR, null).whenExpired(new Runnable(){

                                            @Override
                                            public void run() {
                                                reported.compareAndSet(true, false);
                                                this.restart(timeout);
                                            }
                                        }).notify(null);
                                    }
                                }
                            });
                        } else {
                            this.restart(timeout);
                        }
                    }
                    catch (Exception ex) {
                        LOG.error((Throwable)ex);
                    }
                }
            }

            private boolean notificationsComponentIsLoaded() {
                return ApplicationManager.getApplication().runReadAction((Computable)new Computable<NotificationsConfiguration>(){

                    public NotificationsConfiguration compute() {
                        return NotificationsConfiguration.getNotificationsConfiguration();
                    }
                }) != null;
            }

            private void restart(long timeout) {
                JobScheduler.getScheduler().schedule(this, timeout, TimeUnit.SECONDS);
            }
        }, 1L, TimeUnit.SECONDS);
    }
}

