/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.components.impl.stores.StateStorageManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.Icon;

public class SaveAsDirectoryBasedFormatAction
extends AnAction
implements DumbAware {
    public void actionPerformed(AnActionEvent e) {
        IProjectStore projectStore;
        Project project = e.getProject();
        if (project instanceof ProjectEx && StorageScheme.DIRECTORY_BASED != (projectStore = ((ProjectEx)project).getStateStore()).getStorageScheme() && Messages.showOkCancelDialog((Project)project, (String)"Project will be saved and reopened in new Directory-Based format.\nAre you sure you want to continue?", (String)"Save project to Directory-Based format", (Icon)Messages.getWarningIcon()) == 0) {
            VirtualFile baseDir = project.getBaseDir();
            assert (baseDir != null);
            File ideaDir = new File(baseDir.getPath(), ".idea" + File.separatorChar);
            if (ideaDir.exists() && ideaDir.isDirectory() || SaveAsDirectoryBasedFormatAction.createDir(ideaDir)) {
                LocalFileSystem.getInstance().refreshAndFindFileByIoFile(ideaDir);
                StateStorageManager storageManager = projectStore.getStateStorageManager();
                for (String file : new ArrayList<String>(storageManager.getStorageFileNames())) {
                    storageManager.clearStateStorage(file);
                }
                projectStore.setProjectFilePath(baseDir.getPath());
                project.save();
                ProjectUtil.closeAndDispose(project);
                ProjectUtil.openProject(baseDir.getPath(), null, false);
            } else {
                Messages.showErrorDialog((Project)project, (String)String.format("Unable to create '.idea' directory (%s)", ideaDir), (String)"Error saving project!");
            }
        }
    }

    private static boolean createDir(File ideaDir) {
        try {
            VfsUtil.createDirectories((String)ideaDir.getPath());
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public void update(AnActionEvent e) {
        boolean visible;
        Project project = e.getProject();
        boolean bl = visible = project != null;
        if (project instanceof ProjectEx) {
            visible = ((ProjectEx)project).getStateStore().getStorageScheme() != StorageScheme.DIRECTORY_BASED;
        }
        e.getPresentation().setVisible(visible);
    }
}

