/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.injected.editor;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectionModelWindow
implements SelectionModel {
    private final SelectionModel myHostModel;
    private final DocumentWindow myDocument;
    private final EditorWindow myInjectedEditor;

    public SelectionModelWindow(EditorEx delegate, DocumentWindow document, EditorWindow injectedEditor) {
        this.myDocument = document;
        this.myInjectedEditor = injectedEditor;
        this.myHostModel = delegate.getSelectionModel();
    }

    public int getSelectionStart() {
        return this.myDocument.hostToInjected(this.myHostModel.getSelectionStart());
    }

    @Nullable
    public VisualPosition getSelectionStartPosition() {
        return this.myHostModel.getSelectionStartPosition();
    }

    public int getSelectionEnd() {
        return this.myDocument.hostToInjected(this.myHostModel.getSelectionEnd());
    }

    @Nullable
    public VisualPosition getSelectionEndPosition() {
        return this.myHostModel.getSelectionEndPosition();
    }

    public String getSelectedText() {
        return this.myHostModel.getSelectedText();
    }

    @Nullable
    public String getSelectedText(boolean allCarets) {
        return this.myHostModel.getSelectedText(allCarets);
    }

    public int getLeadSelectionOffset() {
        return this.myDocument.hostToInjected(this.myHostModel.getLeadSelectionOffset());
    }

    @Nullable
    public VisualPosition getLeadSelectionPosition() {
        return this.myHostModel.getLeadSelectionPosition();
    }

    public boolean hasSelection() {
        return this.myHostModel.hasSelection();
    }

    public boolean hasSelection(boolean anyCaret) {
        return this.myHostModel.hasSelection(anyCaret);
    }

    public void setSelection(int startOffset, int endOffset) {
        TextRange hostRange = this.myDocument.injectedToHost((TextRange)new ProperTextRange(startOffset, endOffset));
        this.myHostModel.setSelection(hostRange.getStartOffset(), hostRange.getEndOffset());
    }

    public void setSelection(int startOffset, @Nullable VisualPosition endPosition, int endOffset) {
        TextRange hostRange = this.myDocument.injectedToHost((TextRange)new ProperTextRange(startOffset, endOffset));
        this.myHostModel.setSelection(hostRange.getStartOffset(), endPosition, hostRange.getEndOffset());
    }

    public void setSelection(@Nullable VisualPosition startPosition, int startOffset, @Nullable VisualPosition endPosition, int endOffset) {
        TextRange hostRange = this.myDocument.injectedToHost((TextRange)new ProperTextRange(startOffset, endOffset));
        this.myHostModel.setSelection(startPosition, hostRange.getStartOffset(), endPosition, hostRange.getEndOffset());
    }

    public void removeSelection() {
        this.myHostModel.removeSelection();
    }

    public void removeSelection(boolean allCarets) {
        this.myHostModel.removeSelection(allCarets);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.myHostModel.addSelectionListener(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.myHostModel.removeSelectionListener(listener);
    }

    public void selectLineAtCaret() {
        this.myHostModel.selectLineAtCaret();
    }

    public void selectWordAtCaret(boolean honorCamelWordsSettings) {
        this.myHostModel.selectWordAtCaret(honorCamelWordsSettings);
    }

    public void copySelectionToClipboard() {
        this.myHostModel.copySelectionToClipboard();
    }

    public void setBlockSelection(@NotNull LogicalPosition blockStart, @NotNull LogicalPosition blockEnd) {
        if (blockStart == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "blockStart", "com/intellij/injected/editor/SelectionModelWindow", "setBlockSelection"));
        }
        if (blockEnd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "blockEnd", "com/intellij/injected/editor/SelectionModelWindow", "setBlockSelection"));
        }
        this.myHostModel.setBlockSelection(this.myInjectedEditor.injectedToHost(blockStart), this.myInjectedEditor.injectedToHost(blockEnd));
    }

    public void removeBlockSelection() {
    }

    public boolean hasBlockSelection() {
        return false;
    }

    @NotNull
    public int[] getBlockSelectionStarts() {
        int[] result = this.myHostModel.getBlockSelectionStarts();
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.myDocument.hostToInjected(result[i]);
        }
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/injected/editor/SelectionModelWindow", "getBlockSelectionStarts"));
        }
        return result;
    }

    @NotNull
    public int[] getBlockSelectionEnds() {
        int[] result = this.myHostModel.getBlockSelectionEnds();
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.myDocument.hostToInjected(result[i]);
        }
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/injected/editor/SelectionModelWindow", "getBlockSelectionEnds"));
        }
        return result;
    }

    public LogicalPosition getBlockStart() {
        return null;
    }

    public LogicalPosition getBlockEnd() {
        return null;
    }

    public boolean isBlockSelectionGuarded() {
        return false;
    }

    public RangeMarker getBlockSelectionGuard() {
        return null;
    }

    public TextAttributes getTextAttributes() {
        return this.myHostModel.getTextAttributes();
    }
}

