/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;

public abstract class ConvertIndentsActionBase
extends EditorAction {
    private static IndentBuilder tabIndentBuilder = new IndentBuilder(){

        @Override
        public String buildIndent(int length, int tabSize) {
            return StringUtil.repeatSymbol((char)'\t', (int)(length / tabSize)) + StringUtil.repeatSymbol((char)' ', (int)(length % tabSize));
        }
    };
    private static IndentBuilder spaceIndentBuilder = new IndentBuilder(){

        @Override
        public String buildIndent(int length, int tabSize) {
            return StringUtil.repeatSymbol((char)' ', (int)length);
        }
    };

    protected ConvertIndentsActionBase() {
        super(null);
        this.setupHandler((EditorActionHandler)new Handler());
    }

    public static int convertIndentsToTabs(Document document, int tabSize, TextRange textRange) {
        return ConvertIndentsActionBase.processIndents(document, tabSize, textRange, tabIndentBuilder);
    }

    public static int convertIndentsToSpaces(Document document, int tabSize, TextRange textRange) {
        return ConvertIndentsActionBase.processIndents(document, tabSize, textRange, spaceIndentBuilder);
    }

    private static int processIndents(Document document, int tabSize, TextRange textRange, IndentBuilder indentBuilder) {
        int changedLines = 0;
        int startLine = document.getLineNumber(textRange.getStartOffset());
        int endLine = document.getLineNumber(textRange.getEndOffset());
        for (int line = startLine; line <= endLine; ++line) {
            String newIndent;
            String oldIndent;
            int lineEnd;
            int indent = 0;
            int lineStart = document.getLineStartOffset(line);
            int indentEnd = lineEnd = document.getLineEndOffset(line);
            for (int offset = Math.max(lineStart, textRange.getStartOffset()); offset < lineEnd; ++offset) {
                char c = document.getCharsSequence().charAt(offset);
                if (c == ' ') {
                    ++indent;
                    continue;
                }
                if (c == '\t') {
                    indent = (indent / tabSize + 1) * tabSize;
                    continue;
                }
                indentEnd = offset;
                break;
            }
            if (indent <= 0 || (oldIndent = ((Object)document.getCharsSequence().subSequence(lineStart, indentEnd)).toString()).equals(newIndent = indentBuilder.buildIndent(indent, tabSize))) continue;
            document.replaceString(lineStart, indentEnd, (CharSequence)newIndent);
            ++changedLines;
        }
        return changedLines;
    }

    protected abstract int performAction(Editor var1, TextRange var2);

    private class Handler
    extends EditorWriteActionHandler {
        private Handler() {
        }

        public void executeWriteAction(Editor editor, DataContext dataContext) {
            SelectionModel selectionModel = editor.getSelectionModel();
            int changedLines = 0;
            changedLines = selectionModel.hasSelection() ? ConvertIndentsActionBase.this.performAction(editor, new TextRange(selectionModel.getSelectionStart(), selectionModel.getSelectionEnd())) : (changedLines += ConvertIndentsActionBase.this.performAction(editor, new TextRange(0, editor.getDocument().getTextLength())));
            if (changedLines == 0) {
                HintManager.getInstance().showInformationHint(editor, "All lines already have requested indentation");
            } else {
                HintManager.getInstance().showInformationHint(editor, "Changed indentation in " + changedLines + (changedLines == 1 ? " line" : " lines"));
            }
        }
    }

    private static interface IndentBuilder {
        public String buildIndent(int var1, int var2);
    }
}

