/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingGroup;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.util.Key;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class FoldRegionsTree {
    private static final Key<Boolean> VISIBLE = Key.create((String)"visible.fold.region");
    @NotNull
    private volatile CachedData myCachedData = new CachedData();
    @NotNull
    private List<FoldRegion> myRegions = ContainerUtil.newArrayList();
    private static final Comparator<FoldRegion> BY_END_OFFSET = new Comparator<FoldRegion>(){

        @Override
        public int compare(FoldRegion r1, FoldRegion r2) {
            int end2;
            int end1 = r1.getEndOffset();
            if (end1 < (end2 = r2.getEndOffset())) {
                return -1;
            }
            if (end1 > end2) {
                return 1;
            }
            return 0;
        }
    };
    private static final Comparator<? super FoldRegion> BY_END_OFFSET_REVERSE = Collections.reverseOrder(BY_END_OFFSET);
    private static final TObjectHashingStrategy<FoldRegion> OFFSET_BASED_HASHING_STRATEGY = new TObjectHashingStrategy<FoldRegion>(){

        public int computeHashCode(FoldRegion o) {
            return o.getStartOffset() * 31 + o.getEndOffset();
        }

        public boolean equals(FoldRegion o1, FoldRegion o2) {
            return o1.getStartOffset() == o2.getStartOffset() && o1.getEndOffset() == o2.getEndOffset();
        }
    };

    FoldRegionsTree() {
    }

    void clear() {
        this.clearCachedValues();
        for (FoldRegion region : this.myRegions) {
            region.dispose();
        }
        this.myRegions = new ArrayList<FoldRegion>();
    }

    void clearCachedValues() {
        this.myCachedData = new CachedData();
    }

    protected abstract boolean isFoldingEnabled();

    void rebuild() {
        ArrayList<FoldRegion> topLevels = new ArrayList<FoldRegion>(this.myRegions.size() / 2);
        ArrayList<FoldRegion> visible = new ArrayList<FoldRegion>(this.myRegions.size());
        ArrayList<FoldRegion> allValid = new ArrayList<FoldRegion>(this.myRegions.size());
        THashMap distinctRegions = new THashMap(this.myRegions.size(), OFFSET_BASED_HASHING_STRATEGY);
        for (FoldRegion region : this.myRegions) {
            if (!region.isValid()) continue;
            if (distinctRegions.contains((Object)region)) {
                if (region.getUserData(VISIBLE) == null) {
                    region.dispose();
                    continue;
                }
                FoldRegion identicalRegion = (FoldRegion)distinctRegions.remove((Object)region);
                identicalRegion.dispose();
            }
            distinctRegions.put((Object)region, (Object)region);
        }
        for (FoldRegion region : this.myRegions) {
            if (!region.isValid()) continue;
            allValid.add(region);
        }
        if (allValid.size() < this.myRegions.size()) {
            this.myRegions = allValid;
        }
        Collections.sort(this.myRegions, RangeMarker.BY_START_OFFSET);
        FoldRegion currentCollapsed = null;
        for (FoldRegion region : this.myRegions) {
            if (!region.isExpanded()) {
                FoldRegionsTree.removeRegionsWithSameStartOffset(visible, region);
                FoldRegionsTree.removeRegionsWithSameStartOffset(topLevels, region);
            }
            if (currentCollapsed == null || !FoldRegionsTree.contains(currentCollapsed, region)) {
                visible.add(region);
                region.putUserData(VISIBLE, (Object)Boolean.TRUE);
                if (region.isExpanded()) continue;
                currentCollapsed = region;
                topLevels.add(region);
                continue;
            }
            region.putUserData(VISIBLE, null);
        }
        FoldRegion[] topLevelRegions = FoldRegionsTree.toFoldArray(topLevels);
        FoldRegion[] visibleRegions = FoldRegionsTree.toFoldArray(visible);
        Arrays.sort(topLevelRegions, BY_END_OFFSET);
        Arrays.sort(visibleRegions, BY_END_OFFSET_REVERSE);
        this.updateCachedOffsets(visibleRegions, topLevelRegions);
    }

    private static void removeRegionsWithSameStartOffset(List<FoldRegion> regions, FoldRegion region) {
        for (int i = regions.size() - 1; i >= 0 && regions.get(i).getStartOffset() == region.getStartOffset(); --i) {
            regions.remove(i);
        }
    }

    @NotNull
    private static FoldRegion[] toFoldArray(@NotNull List<FoldRegion> topLevels) {
        if (topLevels == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topLevels", "com/intellij/openapi/editor/impl/FoldRegionsTree", "toFoldArray"));
        }
        FoldRegion[] foldRegionArray = topLevels.isEmpty() ? FoldRegion.EMPTY_ARRAY : topLevels.toArray(new FoldRegion[topLevels.size()]);
        if (foldRegionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/FoldRegionsTree", "toFoldArray"));
        }
        return foldRegionArray;
    }

    void updateCachedOffsets() {
        CachedData cachedData = this.myCachedData;
        this.updateCachedOffsets(cachedData.visibleRegions, cachedData.topLevelRegions);
    }

    private void updateCachedOffsets(FoldRegion[] visibleRegions, FoldRegion[] topLevelRegions) {
        if (!this.isFoldingEnabled()) {
            return;
        }
        if (visibleRegions == null) {
            this.rebuild();
            return;
        }
        THashSet distinctRegions = new THashSet(visibleRegions.length, OFFSET_BASED_HASHING_STRATEGY);
        for (FoldRegion foldRegion : visibleRegions) {
            if (foldRegion.isValid() && distinctRegions.add(foldRegion)) continue;
            this.rebuild();
            return;
        }
        int length = topLevelRegions.length;
        int[] startOffsets = length == 0 ? ArrayUtil.EMPTY_INT_ARRAY : new int[length];
        int[] endOffsets = length == 0 ? ArrayUtil.EMPTY_INT_ARRAY : new int[length];
        int[] foldedLines = length == 0 ? ArrayUtil.EMPTY_INT_ARRAY : new int[length];
        int sum = 0;
        for (int i = 0; i < length; ++i) {
            FoldRegion region = topLevelRegions[i];
            startOffsets[i] = region.getStartOffset();
            endOffsets[i] = region.getEndOffset() - 1;
            Document document = region.getDocument();
            foldedLines[i] = sum += document.getLineNumber(region.getEndOffset()) - document.getLineNumber(region.getStartOffset());
        }
        this.myCachedData = new CachedData(visibleRegions, topLevelRegions, startOffsets, endOffsets, foldedLines);
    }

    boolean addRegion(@NotNull FoldRegion range) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/openapi/editor/impl/FoldRegionsTree", "addRegion"));
        }
        int start = range.getStartOffset();
        int end = range.getEndOffset();
        int insertionIndex = this.myRegions.size();
        for (int i = 0; i < this.myRegions.size(); ++i) {
            FoldRegion region = this.myRegions.get(i);
            int rStart = region.getStartOffset();
            int rEnd = region.getEndOffset();
            if (rStart < start) {
                if (!region.isValid() || start >= rEnd || rEnd >= end) continue;
                return false;
            }
            if (rStart == start) {
                if (rEnd == end) {
                    return false;
                }
                if (rEnd <= end) continue;
                insertionIndex = Math.min(insertionIndex, i);
                continue;
            }
            insertionIndex = Math.min(insertionIndex, i);
            if (rStart > end) break;
            if (!region.isValid() || rStart >= end || end >= rEnd) continue;
            return false;
        }
        this.myRegions.add(insertionIndex, range);
        return true;
    }

    @Nullable
    FoldRegion fetchOutermost(int offset) {
        CachedData cachedData = this.myCachedData;
        if (cachedData.isUnavailable()) {
            return null;
        }
        int[] starts = cachedData.startOffsets;
        int[] ends = cachedData.endOffsets;
        if (starts == null || ends == null) {
            return null;
        }
        int start = 0;
        int end = ends.length - 1;
        while (start <= end) {
            int i = (start + end) / 2;
            if (offset < starts[i]) {
                end = i - 1;
                continue;
            }
            if (offset > ends[i]) {
                start = i + 1;
                continue;
            }
            return cachedData.topLevelRegions[i];
        }
        return null;
    }

    FoldRegion[] fetchVisible() {
        CachedData cachedData = this.myCachedData;
        return cachedData.isUnavailable() ? FoldRegion.EMPTY_ARRAY : cachedData.visibleRegions;
    }

    @Nullable
    FoldRegion[] fetchTopLevel() {
        CachedData cachedData = this.myCachedData;
        return cachedData.isUnavailable() ? null : cachedData.topLevelRegions;
    }

    private static boolean contains(FoldRegion outer, FoldRegion inner) {
        return outer.getStartOffset() <= inner.getStartOffset() && outer.getEndOffset() >= inner.getEndOffset();
    }

    static boolean contains(FoldRegion region, int offset) {
        return region.getStartOffset() < offset && region.getEndOffset() > offset;
    }

    public FoldRegion[] fetchCollapsedAt(int offset) {
        if (this.myCachedData.isUnavailable()) {
            return FoldRegion.EMPTY_ARRAY;
        }
        ArrayList<FoldRegion> allCollapsed = new ArrayList<FoldRegion>();
        for (FoldRegion region : this.myRegions) {
            if (region.isExpanded() || !FoldRegionsTree.contains(region, offset)) continue;
            allCollapsed.add(region);
        }
        return FoldRegionsTree.toFoldArray(allCollapsed);
    }

    boolean intersectsRegion(int startOffset, int endOffset) {
        if (!this.isFoldingEnabled()) {
            return true;
        }
        for (FoldRegion region : this.myRegions) {
            boolean contains2;
            boolean contains1 = FoldRegionsTree.contains(region, startOffset);
            if (contains1 == (contains2 = FoldRegionsTree.contains(region, endOffset))) continue;
            return true;
        }
        return false;
    }

    FoldRegion[] fetchAllRegions() {
        if (this.myCachedData.isUnavailable()) {
            return FoldRegion.EMPTY_ARRAY;
        }
        return FoldRegionsTree.toFoldArray(this.myRegions);
    }

    void removeRegion(@NotNull FoldRegion range) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/openapi/editor/impl/FoldRegionsTree", "removeRegion"));
        }
        this.myRegions.remove(range);
    }

    int getFoldedLinesCountBefore(int offset) {
        CachedData snapshot = this.myCachedData;
        int idx = FoldRegionsTree.getLastTopLevelIndexBefore(snapshot, offset);
        if (idx == -1) {
            return 0;
        }
        return snapshot.foldedLines[idx];
    }

    public int getLastTopLevelIndexBefore(int offset) {
        return FoldRegionsTree.getLastTopLevelIndexBefore(this.myCachedData, offset);
    }

    private static int getLastTopLevelIndexBefore(CachedData snapshot, int offset) {
        int[] endOffsets = snapshot.endOffsets;
        if (snapshot.isUnavailable() || endOffsets == null) {
            return -1;
        }
        --offset;
        int start = 0;
        int end = endOffsets.length - 1;
        while (start <= end) {
            int i = (start + end) / 2;
            if (offset < endOffsets[i]) {
                end = i - 1;
                continue;
            }
            if (offset > endOffsets[i]) {
                start = i + 1;
                continue;
            }
            return i;
        }
        return end;
    }

    @Nullable
    public FoldRegion getRegionAt(int startOffset, int endOffset) {
        int index = Collections.binarySearch(this.myRegions, new DummyFoldRegion(startOffset, endOffset), RangeMarker.BY_START_OFFSET);
        return index < 0 ? null : this.myRegions.get(index);
    }

    private static class DummyFoldRegion
    implements FoldRegion {
        private final int myStartOffset;
        private final int myEndOffset;

        private DummyFoldRegion(int startOffset, int endOffset) {
            this.myStartOffset = startOffset;
            this.myEndOffset = endOffset;
        }

        public boolean isExpanded() {
            throw new UnsupportedOperationException();
        }

        public void setExpanded(boolean expanded) {
            throw new UnsupportedOperationException();
        }

        @NotNull
        public String getPlaceholderText() {
            throw new UnsupportedOperationException();
        }

        public Editor getEditor() {
            throw new UnsupportedOperationException();
        }

        @Nullable
        public FoldingGroup getGroup() {
            throw new UnsupportedOperationException();
        }

        public boolean shouldNeverExpand() {
            throw new UnsupportedOperationException();
        }

        @NotNull
        public Document getDocument() {
            throw new UnsupportedOperationException();
        }

        public int getStartOffset() {
            return this.myStartOffset;
        }

        public int getEndOffset() {
            return this.myEndOffset;
        }

        public boolean isValid() {
            throw new UnsupportedOperationException();
        }

        public void setGreedyToLeft(boolean greedy) {
            throw new UnsupportedOperationException();
        }

        public void setGreedyToRight(boolean greedy) {
            throw new UnsupportedOperationException();
        }

        public boolean isGreedyToRight() {
            throw new UnsupportedOperationException();
        }

        public boolean isGreedyToLeft() {
            throw new UnsupportedOperationException();
        }

        public void dispose() {
            throw new UnsupportedOperationException();
        }

        @Nullable
        public <T> T getUserData(@NotNull Key<T> key) {
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/editor/impl/FoldRegionsTree$DummyFoldRegion", "getUserData"));
            }
            throw new UnsupportedOperationException();
        }

        public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/editor/impl/FoldRegionsTree$DummyFoldRegion", "putUserData"));
            }
            throw new UnsupportedOperationException();
        }
    }

    private class CachedData
    implements Cloneable {
        private final FoldRegion[] visibleRegions;
        private final FoldRegion[] topLevelRegions;
        private final int[] startOffsets;
        private final int[] endOffsets;
        private final int[] foldedLines;

        private CachedData() {
            this.visibleRegions = null;
            this.topLevelRegions = null;
            this.startOffsets = null;
            this.endOffsets = null;
            this.foldedLines = null;
        }

        private CachedData(FoldRegion[] visibleRegions, FoldRegion[] topLevelRegions, int[] startOffsets, int[] endOffsets, int[] foldedLines) {
            this.visibleRegions = visibleRegions;
            this.topLevelRegions = topLevelRegions;
            this.startOffsets = startOffsets;
            this.endOffsets = endOffsets;
            this.foldedLines = foldedLines;
        }

        private boolean isUnavailable() {
            return !FoldRegionsTree.this.isFoldingEnabled() || this.visibleRegions == null;
        }
    }
}

