/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.view;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorLinePainter;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.LineExtensionInfo;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.PrioritizedDocumentListener;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.view.LineView;
import com.intellij.openapi.editor.impl.view.TextLayoutHighlightShape;
import com.intellij.openapi.editor.markup.CustomHighlighterRenderer;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.LineSeparatorRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.SeparatorPlacement;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.Processor;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class EditorView
implements PrioritizedDocumentListener,
Disposable {
    private final EditorImpl myEditor;
    private final DocumentEx myDocument;
    private final FontRenderContext myFontRenderContext;
    private final ArrayList<LineView> myLines = new ArrayList();
    private int myWidthInPixels;
    private int myMaxLineWithExtensionWidth;
    private int myWidestLineWithExtension;
    private int myPlainSpaceWidth;
    private int myDocumentChangeOldEndLine;
    private TextLayout myPrefixLayout;
    private TextAttributes myPrefixAttributes;

    public EditorView(EditorImpl editor) {
        this.myFontRenderContext = EditorView.createFontRenderContext();
        this.myEditor = editor;
        this.myDocument = editor.getDocument();
        this.myDocument.addDocumentListener(this, this);
        this.myPlainSpaceWidth = EditorUtil.getSpaceWidth(0, editor);
        this.invalidateCachedWidth();
        this.invalidateLines(0, -1, this.getDocumentLineCount() - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FontRenderContext createFontRenderContext() {
        Graphics2D g = (Graphics2D)UIUtil.createImage((int)1, (int)1, (int)1).getGraphics();
        try {
            UISettings.setupAntialiasing((Graphics)g);
            FontRenderContext fontRenderContext = g.getFontRenderContext();
            return fontRenderContext;
        }
        finally {
            g.dispose();
        }
    }

    public void dispose() {
        this.myLines.clear();
    }

    @NotNull
    public LogicalPosition offsetToLogicalPosition(int offset) {
        int textLength = this.myDocument.getTextLength();
        if (offset < 0 || textLength == 0) {
            LogicalPosition logicalPosition = new LogicalPosition(0, 0);
            if (logicalPosition == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/view/EditorView", "offsetToLogicalPosition"));
            }
            return logicalPosition;
        }
        offset = Math.min(offset, textLength);
        int line = this.myDocument.getLineNumber(offset);
        int offsetInsideLine = offset - this.myDocument.getLineStartOffset(line);
        int column = line < this.myLines.size() ? this.getLineRenderer(line).offsetToColumn(offsetInsideLine, this.myPlainSpaceWidth) : offsetInsideLine;
        LogicalPosition logicalPosition = new LogicalPosition(line, column);
        if (logicalPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/view/EditorView", "offsetToLogicalPosition"));
        }
        return logicalPosition;
    }

    public int logicalPositionToOffset(@NotNull LogicalPosition pos) {
        if (pos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pos", "com/intellij/openapi/editor/impl/view/EditorView", "logicalPositionToOffset"));
        }
        int line = pos.line;
        if (line >= this.getDocumentLineCount()) {
            return this.myDocument.getTextLength();
        }
        return this.myDocument.getLineStartOffset(line) + (line < this.myLines.size() ? this.getLineRenderer(line).columnToOffset(pos.column, this.myPlainSpaceWidth)[0] : pos.column);
    }

    @NotNull
    public VisualPosition logicalToVisualPosition(@NotNull LogicalPosition pos) {
        if (pos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pos", "com/intellij/openapi/editor/impl/view/EditorView", "logicalToVisualPosition"));
        }
        VisualPosition visualPosition = new VisualPosition(pos.line, pos.column);
        if (visualPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/view/EditorView", "logicalToVisualPosition"));
        }
        return visualPosition;
    }

    @NotNull
    public LogicalPosition visualToLogicalPosition(@NotNull VisualPosition pos) {
        if (pos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pos", "com/intellij/openapi/editor/impl/view/EditorView", "visualToLogicalPosition"));
        }
        LogicalPosition logicalPosition = new LogicalPosition(pos.line, pos.column);
        if (logicalPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/view/EditorView", "visualToLogicalPosition"));
        }
        return logicalPosition;
    }

    @NotNull
    public VisualPosition offsetToVisualPosition(int offset) {
        VisualPosition visualPosition = this.logicalToVisualPosition(this.offsetToLogicalPosition(offset));
        if (visualPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/view/EditorView", "offsetToVisualPosition"));
        }
        return visualPosition;
    }

    public int offsetToVisualLine(int offset) {
        if (offset <= 0) {
            return 0;
        }
        if (offset >= this.myDocument.getTextLength()) {
            return Math.max(0, this.getDocumentLineCount() - 1);
        }
        return this.myDocument.getLineNumber(offset);
    }

    @NotNull
    public VisualPosition xyToVisualPosition(@NotNull Point p) {
        int prefixShift;
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/openapi/editor/impl/view/EditorView", "xyToVisualPosition"));
        }
        int line = this.myEditor.yPositionToVisibleLine(Math.max(p.y, 0));
        int n = prefixShift = line == 0 ? this.getPrefixTextWidthInPixels() : 0;
        if (line < this.myLines.size()) {
            LineView lineView = this.getLineRenderer(line);
            VisualPosition visualPosition = new VisualPosition(line, lineView.xToColumn(p.x - prefixShift, this.myPlainSpaceWidth, this.myEditor.getSettings().isCaretInsideTabs()));
            if (visualPosition == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/view/EditorView", "xyToVisualPosition"));
            }
            return visualPosition;
        }
        VisualPosition visualPosition = new VisualPosition(line, LineView.spacePixelsToColumns(p.x - prefixShift, this.myPlainSpaceWidth));
        if (visualPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/view/EditorView", "xyToVisualPosition"));
        }
        return visualPosition;
    }

    @NotNull
    public Point visualPositionToXY(@NotNull VisualPosition pos) {
        int prefixShift;
        if (pos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pos", "com/intellij/openapi/editor/impl/view/EditorView", "visualPositionToXY"));
        }
        int y = this.myEditor.visibleLineToY(pos.line);
        int n = prefixShift = pos.line == 0 ? this.getPrefixTextWidthInPixels() : 0;
        if (pos.line < this.myLines.size()) {
            LineView lineView = this.getLineRenderer(pos.line);
            Point point = new Point(lineView.columnToX(pos.column, this.myPlainSpaceWidth) + prefixShift, y);
            if (point == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/view/EditorView", "visualPositionToXY"));
            }
            return point;
        }
        Point point = new Point(LineView.spaceColumnsToPixels(pos.column, this.myPlainSpaceWidth) + prefixShift, y);
        if (point == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/view/EditorView", "visualPositionToXY"));
        }
        return point;
    }

    public Dimension getPreferredSize() {
        int width = this.getPreferredWidth();
        if (!this.myDocument.isInBulkUpdate()) {
            for (Caret caret : this.myEditor.getCaretModel().getAllCarets()) {
                if (!caret.isUpToDate()) continue;
                int caretX = this.visualPositionToXY((VisualPosition)caret.getVisualPosition()).x;
                width = Math.max(caretX, width);
            }
        }
        return new Dimension(width += this.myEditor.getSettings().getAdditionalColumnsCount() * this.myPlainSpaceWidth, this.myEditor.getPreferredHeight());
    }

    public Dimension getContentSize() {
        return this.getPreferredSize();
    }

    private int getPreferredWidth() {
        if (this.myWidthInPixels < 0) {
            this.myWidthInPixels = this.calculatePreferredWidth();
        }
        this.validateMaxLineWithExtension();
        return Math.max(this.myWidthInPixels, this.myMaxLineWithExtensionWidth);
    }

    private void validateMaxLineWithExtension() {
        if (this.myMaxLineWithExtensionWidth > 0) {
            Project project = this.myEditor.getProject();
            VirtualFile virtualFile = this.myEditor.getVirtualFile();
            if (project != null && virtualFile != null) {
                for (EditorLinePainter painter : (EditorLinePainter[])EditorLinePainter.EP_NAME.getExtensions()) {
                    Collection<LineExtensionInfo> extensions = painter.getLineExtensions(project, virtualFile, this.myWidestLineWithExtension);
                    if (extensions == null || extensions.isEmpty()) continue;
                    return;
                }
            }
            this.myMaxLineWithExtensionWidth = 0;
        }
    }

    private int calculatePreferredWidth() {
        int maxWidth = this.getPrefixTextWidthInPixels() + (this.myLines.isEmpty() ? 0 : this.getLineRenderer(0).getWidthInPixels());
        for (int line = 1; line < this.myLines.size(); ++line) {
            LineView lineView = this.myLines.get(line);
            if (lineView == null) continue;
            maxWidth = Math.max(maxWidth, lineView.getWidthInPixels());
        }
        int longestLineNumber = this.guessLongestLineNumber();
        if (longestLineNumber > 0 && longestLineNumber < this.myLines.size()) {
            maxWidth = Math.max(maxWidth, this.getLineRenderer(longestLineNumber).getWidthInPixels());
        }
        return maxWidth;
    }

    private int guessLongestLineNumber() {
        int lineCount = this.getDocumentLineCount();
        int longestLineNumber = -1;
        int longestLine = -1;
        for (int line = 0; line < lineCount; ++line) {
            int lineChars = this.myDocument.getLineEndOffset(line) - this.myDocument.getLineStartOffset(line);
            if (lineChars <= longestLine) continue;
            longestLine = lineChars;
            longestLineNumber = line;
        }
        return longestLineNumber;
    }

    public int getMaxWidthInRange(int startOffset, int endOffset) {
        return this.getMaxWidthInLineRange(this.offsetToLogicalPosition((int)startOffset).line, this.offsetToLogicalPosition((int)endOffset).line);
    }

    private int getMaxWidthInLineRange(int startLine, int endLine) {
        int maxWidth = 0;
        for (int line = startLine; line <= endLine && line < this.myLines.size(); ++line) {
            maxWidth = Math.max(maxWidth, this.getLineWidth(line));
        }
        return maxWidth;
    }

    private int getLineWidth(int line) {
        int length = this.getLineRenderer(line).getWidthInPixels();
        if (line == 0) {
            length += this.getPrefixTextWidthInPixels();
        }
        return length;
    }

    public void paint(Graphics2D g) {
        Rectangle clip = g.getClipBounds();
        if (this.myEditor.getContentComponent().isOpaque()) {
            g.setColor(this.myEditor.getBackgroundColor());
            g.fillRect(clip.x, clip.y, clip.width, clip.height);
        }
        if (this.paintPlaceholderText(g)) {
            return;
        }
        int startLine = this.myEditor.yPositionToVisibleLine(Math.max(clip.y, 0));
        int endLine = this.myEditor.yPositionToVisibleLine(Math.max(clip.y + clip.height, 0));
        int lineCount = this.getDocumentLineCount();
        int startOffset = startLine >= lineCount ? this.myDocument.getTextLength() : this.myDocument.getLineStartOffset(startLine);
        int endOffset = endLine >= lineCount ? this.myDocument.getTextLength() : this.myDocument.getLineEndOffset(endLine);
        this.paintBackground(g, clip, startLine, endLine);
        this.paintRightMargin(g, clip);
        this.paintCustomRenderers(g, startOffset, endOffset);
        MarkupModelEx docMarkup = (MarkupModelEx)DocumentMarkupModel.forDocument(this.myDocument, this.myEditor.getProject(), true);
        this.paintLineMarkersSeparators(g, clip, docMarkup, startOffset, endOffset);
        this.paintLineMarkersSeparators(g, clip, this.myEditor.getMarkupModel(), startOffset, endOffset);
        this.paintTextWithEffects(g, clip, startLine, endLine);
        this.paintHighlightersAfterEndOfLine(g, docMarkup, startOffset, endOffset);
        this.paintHighlightersAfterEndOfLine(g, this.myEditor.getMarkupModel(), startOffset, endOffset);
        this.paintBorderEffect(g, this.myEditor.getHighlighter(), startOffset, endOffset);
        this.paintBorderEffect(g, docMarkup, startOffset, endOffset);
        this.paintBorderEffect(g, this.myEditor.getMarkupModel(), startOffset, endOffset);
        this.paintCaret(g, clip);
    }

    private void paintCaret(Graphics2D g, Rectangle clip) {
        EditorImpl.CaretRectangle[] locations = this.myEditor.getCaretLocations();
        if (locations == null) {
            return;
        }
        for (EditorImpl.CaretRectangle location : locations) {
            this.paintCaretAt(g, clip, location.myPoint.x, location.myPoint.y, location.myCaret);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintCaretAt(Graphics2D g, Rectangle clip, int x, int y, Caret caret) {
        Rectangle viewRectangle = this.myEditor.getScrollingModel().getVisibleArea();
        if (x - viewRectangle.x < 0) {
            return;
        }
        int lineHeight = this.myEditor.getLineHeight();
        EditorSettings settings = this.myEditor.getSettings();
        Color caretColor = this.myEditor.getColorsScheme().getColor(EditorColors.CARET_COLOR);
        if (caretColor == null) {
            caretColor = new JBColor((Color)Gray._0, (Color)Gray._255);
        }
        g.setColor(caretColor);
        if (this.myEditor.isInsertMode() != settings.isBlockCursor()) {
            if (UIUtil.isRetina()) {
                g.fillRect(x, y, settings.getLineCursorWidth(), lineHeight);
            } else {
                for (int i = 0; i < settings.getLineCursorWidth(); ++i) {
                    UIUtil.drawLine((Graphics)g, (int)(x + i), (int)y, (int)(x + i), (int)(y + lineHeight - 1));
                }
            }
        } else {
            int offset = caret.getOffset();
            int line = this.myDocument.getLineNumber(offset);
            TextLayoutHighlightShape shape = null;
            if (offset < this.myDocument.getLineEndOffset(line)) {
                LineView lineView = this.myLines.get(line);
                int lineStartOffset = this.myDocument.getLineStartOffset(line);
                shape = lineView.getRangeShape(this.myEditor, offset - lineStartOffset, offset - lineStartOffset + 1);
            }
            Graphics2D window = (Graphics2D)g.create(0, this.myEditor.visibleLineToY(line), clip.x + clip.width, lineHeight);
            try {
                Color background = this.myEditor.getCaretModel().getTextAttributes().getBackgroundColor();
                if (background == null) {
                    background = this.myEditor.getBackgroundColor();
                }
                window.setXORMode(background);
                if (shape == null) {
                    window.fillRect(x, 0, this.myPlainSpaceWidth, lineHeight);
                } else {
                    shape.fill(window);
                }
                window.setPaintMode();
            }
            finally {
                window.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintBackground(Graphics2D g, Rectangle clip, int startLine, int endLine) {
        for (int line = startLine; line <= endLine; ++line) {
            Graphics2D window = (Graphics2D)g.create(0, this.myEditor.visibleLineToY(line), clip.x + clip.width, this.myEditor.getLineHeight());
            try {
                if (line == 0 && this.myPrefixLayout != null) {
                    LineView.paintBackground(window, this.myEditor, this.myPrefixLayout, 0, this.myPrefixLayout.getCharacterCount(), this.myPrefixAttributes);
                    window.translate(this.getPrefixTextWidthInPixels(), 0);
                }
                if (line >= this.myLines.size()) break;
                LineView lineView = this.getLineRenderer(line);
                lineView.paintBackground(window, this.myEditor, this.myDocument.getLineStartOffset(line), this.myDocument.getLineEndOffset(line), this.myPlainSpaceWidth);
                continue;
            }
            finally {
                window.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintTextWithEffects(Graphics2D g, Rectangle clip, int startLine, int endLine) {
        CharSequence text = this.myDocument.getImmutableCharSequence();
        EditorImpl.LineWhitespacePaintingStrategy whitespacePaintingStrategy = this.myEditor.new EditorImpl.LineWhitespacePaintingStrategy();
        for (int line = startLine; line <= endLine; ++line) {
            Graphics2D window = (Graphics2D)g.create(0, this.myEditor.visibleLineToY(line), clip.x + clip.width, this.myEditor.getLineHeight());
            try {
                if (line == 0 && this.myPrefixLayout != null) {
                    this.paintTextLayoutWithEffect(window, this.myPrefixLayout, this.myPrefixAttributes.getEffectColor(), this.myPrefixAttributes.getEffectType());
                    window.translate(this.getPrefixTextWidthInPixels(), 0);
                }
                if (line >= this.myLines.size()) break;
                LineView lineView = this.getLineRenderer(line);
                int lineStartOffset = this.myDocument.getLineStartOffset(line);
                int lineEndOffset = this.myDocument.getLineEndOffset(line);
                whitespacePaintingStrategy.update(text, lineStartOffset, lineEndOffset);
                lineView.paintTextAndEffects(window, this.myEditor, lineStartOffset, lineEndOffset, whitespacePaintingStrategy, this.myPlainSpaceWidth);
                window.translate(lineView.getWidthInPixels(), 0);
                this.paintLineExtensions(window, line);
                continue;
            }
            finally {
                window.dispose();
            }
        }
    }

    public void setPrefix(String prefixText, TextAttributes attributes) {
        this.myPrefixLayout = prefixText == null || prefixText.isEmpty() ? null : this.createTextLayout(prefixText, attributes.getFontType(), attributes.getForegroundColor());
        this.myPrefixAttributes = attributes;
    }

    private TextLayout createTextLayout(String text, int fontStyle, Color fontColor) {
        AttributedString string = LineView.createAttributedString(text);
        LineView.setFontAttributes(string, 0, text.length(), fontStyle, fontColor, this.myEditor.getColorsScheme().getFontPreferences(), null);
        return new TextLayout(string.getIterator(), this.myFontRenderContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintTextLayoutWithEffect(Graphics2D g, TextLayout textLayout, Color effectColor, EffectType effectType) {
        textLayout.draw(g, 0.0f, this.myEditor.getAscent());
        if (LineView.hasTextEffect(effectColor, effectType)) {
            TextLayoutHighlightShape shape = new TextLayoutHighlightShape(textLayout, 0, textLayout.getCharacterCount(), this.myEditor.getAscent(), this.myEditor.getLineHeight());
            Graphics2D window = (Graphics2D)g.create();
            try {
                shape.setAsClip(window);
                Rectangle clipBounds = window.getClipBounds();
                window.setColor(effectColor);
                LineView.paintTextEffect(window, this.myEditor, (int)clipBounds.getMinX(), (int)clipBounds.getMaxX(), this.myEditor.getAscent(), effectType);
            }
            finally {
                window.dispose();
            }
        }
    }

    public int getPrefixTextWidthInPixels() {
        return this.myPrefixLayout == null ? 0 : (int)this.myPrefixLayout.getAdvance();
    }

    private void paintCustomRenderers(final Graphics2D g, final int startOffset, final int endOffset) {
        this.myEditor.getMarkupModel().processRangeHighlightersOverlappingWith(startOffset, endOffset, (Processor<? super RangeHighlighterEx>)new Processor<RangeHighlighterEx>(){

            public boolean process(RangeHighlighterEx highlighter) {
                CustomHighlighterRenderer customRenderer;
                if (highlighter.getEditorFilter().avaliableIn((Editor)EditorView.this.myEditor) && (customRenderer = highlighter.getCustomRenderer()) != null && startOffset < highlighter.getEndOffset() && highlighter.getStartOffset() < endOffset) {
                    customRenderer.paint((Editor)EditorView.this.myEditor, (RangeHighlighter)highlighter, (Graphics)g);
                }
                return true;
            }
        });
    }

    private void paintLineMarkersSeparators(final Graphics g, final Rectangle clip, MarkupModelEx markupModel, int startOffset, int endOffset) {
        markupModel.processRangeHighlightersOverlappingWith(startOffset, endOffset, (Processor<? super RangeHighlighterEx>)new Processor<RangeHighlighterEx>(){

            public boolean process(RangeHighlighterEx highlighter) {
                if (highlighter.getEditorFilter().avaliableIn((Editor)EditorView.this.myEditor)) {
                    EditorView.this.paintLineMarkerSeparator(highlighter, clip, g);
                }
                return true;
            }
        });
    }

    private void paintHighlightersAfterEndOfLine(final Graphics2D g, MarkupModelEx markupModel, final int startOffset, int endOffset) {
        markupModel.processRangeHighlightersOverlappingWith(startOffset, endOffset, (Processor<? super RangeHighlighterEx>)new Processor<RangeHighlighterEx>(){

            public boolean process(RangeHighlighterEx highlighter) {
                if (highlighter.getEditorFilter().avaliableIn((Editor)EditorView.this.myEditor) && highlighter.getStartOffset() >= startOffset) {
                    EditorView.this.paintHighlighterAfterEndOfLine(g, highlighter);
                }
                return true;
            }
        });
    }

    private void paintLineMarkerSeparator(RangeHighlighter marker, Rectangle clip, Graphics g) {
        Color separatorColor = marker.getLineSeparatorColor();
        LineSeparatorRenderer lineSeparatorRenderer = marker.getLineSeparatorRenderer();
        if (separatorColor == null && lineSeparatorRenderer == null) {
            return;
        }
        int line = this.myDocument.getLineNumber(marker.getLineSeparatorPlacement() == SeparatorPlacement.TOP ? marker.getStartOffset() : marker.getEndOffset());
        int y = this.myEditor.visibleLineToY(line + (marker.getLineSeparatorPlacement() == SeparatorPlacement.TOP ? 0 : 1));
        if (--y + this.myEditor.getLineHeight() < clip.y || y > clip.y + clip.height) {
            return;
        }
        int endShift = clip.x + clip.width;
        EditorSettings settings = this.myEditor.getSettings();
        if (settings.isRightMarginShown() && this.myEditor.getColorsScheme().getColor(EditorColors.RIGHT_MARGIN_COLOR) != null) {
            endShift = Math.min(endShift, settings.getRightMargin(this.myEditor.getProject()) * this.myPlainSpaceWidth);
        }
        g.setColor(separatorColor);
        if (lineSeparatorRenderer != null) {
            lineSeparatorRenderer.drawLine(g, 0, endShift, y);
        } else {
            UIUtil.drawLine((Graphics)g, (int)0, (int)y, (int)endShift, (int)y);
        }
    }

    private void paintHighlighterAfterEndOfLine(Graphics2D g, RangeHighlighterEx highlighter) {
        if (!highlighter.isAfterEndOfLine()) {
            return;
        }
        int offset = highlighter.getStartOffset();
        int line = this.myDocument.getLineNumber(offset);
        if (line >= this.myLines.size()) {
            return;
        }
        int x = this.getLineWidth(line);
        int y = this.myEditor.visibleLineToY(line);
        TextAttributes attributes = highlighter.getTextAttributes();
        Color backgroundColor = EditorView.getBackgroundColor(this.myEditor, attributes);
        if (backgroundColor != null) {
            g.setColor(backgroundColor);
            g.fillRect(x, y, this.myPlainSpaceWidth, this.myEditor.getLineHeight());
        }
        if (attributes != null && attributes.getEffectColor() != null) {
            LineView.paintTextEffect(g, this.myEditor, x, x + this.myPlainSpaceWidth - 1, this.myEditor.getAscent(), attributes.getEffectType());
        }
    }

    private boolean paintPlaceholderText(Graphics2D g) {
        CharSequence hintText = this.myEditor.getPlaceholder();
        EditorComponentImpl editorComponent = this.myEditor.getContentComponent();
        if (this.myDocument.getTextLength() > 0 || hintText == null || hintText.length() == 0 || KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner() == editorComponent && !this.myEditor.getShowPlaceholderWhenFocused()) {
            return false;
        }
        hintText = SwingUtilities.layoutCompoundLabel(g.getFontMetrics(), ((Object)hintText).toString(), null, 0, 0, 0, 0, editorComponent.getBounds(), new Rectangle(), new Rectangle(), 0);
        g.setColor(this.myEditor.getFoldingModel().getPlaceholderAttributes().getForegroundColor());
        g.setFont(this.myEditor.getColorsScheme().getFont(EditorFontType.PLAIN));
        g.drawString(((Object)hintText).toString(), 0, this.myEditor.getAscent());
        return true;
    }

    private void paintRightMargin(Graphics g, Rectangle clip) {
        EditorSettings settings = this.myEditor.getSettings();
        Color rightMargin = this.myEditor.getColorsScheme().getColor(EditorColors.RIGHT_MARGIN_COLOR);
        if (!settings.isRightMarginShown() || rightMargin == null) {
            return;
        }
        int x = settings.getRightMargin(this.myEditor.getProject()) * this.myPlainSpaceWidth;
        g.setColor(rightMargin);
        UIUtil.drawLine((Graphics)g, (int)x, (int)clip.y, (int)x, (int)(clip.y + clip.height));
    }

    static Color getBackgroundColor(EditorImpl editor, TextAttributes attributes) {
        if (attributes == null) {
            return null;
        }
        Color attrColor = attributes.getBackgroundColor();
        return attrColor == null || attrColor.equals(editor.getColorsScheme().getDefaultBackground()) || attrColor.equals(editor.getBackgroundColor()) ? null : attrColor;
    }

    private void paintBorderEffect(Graphics2D g, EditorHighlighter highlighter, int clipStartOffset, int clipEndOffset) {
        HighlighterIterator it = highlighter.createIterator(clipStartOffset);
        while (!it.atEnd() && it.getStart() < clipEndOffset) {
            TextAttributes attributes = it.getTextAttributes();
            if (EditorView.isBorder(attributes)) {
                this.paintBorderEffect(g, it.getStart(), it.getEnd(), attributes);
            }
            it.advance();
        }
    }

    private void paintBorderEffect(final Graphics2D g, MarkupModelEx markupModel, int clipStartOffset, int clipEndOffset) {
        markupModel.processRangeHighlightersOverlappingWith(clipStartOffset, clipEndOffset, (Processor<? super RangeHighlighterEx>)new Processor<RangeHighlighterEx>(){

            public boolean process(RangeHighlighterEx rangeHighlighter) {
                TextAttributes attributes;
                if (rangeHighlighter.getEditorFilter().avaliableIn((Editor)EditorView.this.myEditor) && EditorView.isBorder(attributes = rangeHighlighter.getTextAttributes())) {
                    EditorView.this.paintBorderEffect(g, rangeHighlighter.getAffectedAreaStartOffset(), rangeHighlighter.getAffectedAreaEndOffset(), attributes);
                }
                return true;
            }
        });
    }

    private static boolean isBorder(TextAttributes attributes) {
        return attributes != null && (attributes.getEffectType() == EffectType.BOXED || attributes.getEffectType() == EffectType.ROUNDED_BOX) && attributes.getEffectColor() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintBorderEffect(Graphics2D g, int startOffset, int endOffset, TextAttributes attributes) {
        int endLine;
        int startLine = this.myDocument.getLineNumber(startOffset);
        if (startLine + 1 == (endLine = this.myDocument.getLineNumber(endOffset)) && startOffset == this.myDocument.getLineStartOffset(startLine) && endOffset == this.myDocument.getLineStartOffset(endLine)) {
            endOffset = this.myDocument.getLineEndOffset(--endLine);
        }
        if (startLine >= this.myLines.size() || endLine >= this.myLines.size()) {
            return;
        }
        int startLineStartOffset = this.myDocument.getLineStartOffset(startLine);
        int start = startOffset - startLineStartOffset;
        int end = endOffset - this.myDocument.getLineStartOffset(endLine);
        LineView startLineView = this.getLineRenderer(startLine);
        LineView endLineView = this.getLineRenderer(endLine);
        int maxWidth = this.getMaxWidthInLineRange(startLine, endLine);
        Graphics2D window = (Graphics2D)g.create(0, this.myEditor.visibleLineToY(startLine), maxWidth + 2, (endLine - startLine + 1) * this.myEditor.getLineHeight());
        try {
            boolean rounded;
            window.setColor(attributes.getEffectColor());
            boolean bl = rounded = attributes.getEffectType() == EffectType.ROUNDED_BOX;
            if (startLine == endLine) {
                startLineView.getRangeShape(this.myEditor, start, end).draw(window, rounded);
            } else {
                TextLayoutHighlightShape leading = startLineView.getRangeShape(this.myEditor, start, this.myDocument.getLineEndOffset(startLine) - startLineStartOffset);
                TextLayoutHighlightShape trailing = endLineView.getRangeShape(this.myEditor, 0, end);
                TextLayoutHighlightShape.drawCombined(window, leading, trailing, (endLine - startLine) * this.myEditor.getLineHeight(), maxWidth, startLineView.getVisualLineEndOffset() >= start, rounded);
            }
        }
        finally {
            window.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintLineExtensions(Graphics2D g, int line) {
        Project project = this.myEditor.getProject();
        VirtualFile virtualFile = this.myEditor.getVirtualFile();
        if (project == null || virtualFile == null) {
            return;
        }
        for (EditorLinePainter painter : (EditorLinePainter[])EditorLinePainter.EP_NAME.getExtensions()) {
            Collection<LineExtensionInfo> extensions = painter.getLineExtensions(project, virtualFile, line);
            if (extensions == null) continue;
            for (LineExtensionInfo info : extensions) {
                TextLayout textLayout = this.createTextLayout(info.getText(), info.getFontType(), info.getColor());
                Graphics2D gCopy = (Graphics2D)g.create();
                try {
                    this.paintTextLayoutWithEffect(gCopy, textLayout, info.getEffectColor(), info.getEffectType());
                }
                finally {
                    gCopy.dispose();
                }
                g.translate(textLayout.getAdvance(), 0.0);
                int currentLineWidth = (int)g.getTransform().getTranslateX();
                if (currentLineWidth <= this.myMaxLineWithExtensionWidth) continue;
                this.myMaxLineWithExtensionWidth = currentLineWidth;
                this.myWidestLineWithExtension = line;
            }
        }
    }

    @Override
    public int getPriority() {
        return 70;
    }

    public void beforeDocumentChange(DocumentEvent event) {
        this.myDocumentChangeOldEndLine = this.getAdjustedLineNumber(event.getOffset() + event.getOldLength());
    }

    public void documentChanged(DocumentEvent event) {
        this.invalidateCachedWidth();
        int startLine = this.myDocument.getLineNumber(event.getOffset());
        int newEndLine = this.getAdjustedLineNumber(event.getOffset() + event.getNewLength());
        this.invalidateLines(startLine, this.myDocumentChangeOldEndLine, newEndLine);
    }

    private int getAdjustedLineNumber(int offset) {
        return this.myDocument.getTextLength() == 0 ? -1 : this.myDocument.getLineNumber(offset);
    }

    private int getDocumentLineCount() {
        return this.myDocument.getTextLength() == 0 ? 0 : this.myDocument.getLineCount();
    }

    public void reinitSettings() {
        this.myPlainSpaceWidth = EditorUtil.getSpaceWidth(0, this.myEditor);
        this.invalidateCachedWidth();
        this.invalidateAll();
    }

    public void invalidateCachedWidth() {
        this.myWidthInPixels = -1;
    }

    public void invalidateAll() {
        int maxLine = this.myLines.size() - 1;
        this.invalidateLines(0, maxLine, maxLine);
    }

    public void invalidateLines(int startLine, int endLine) {
        if (startLine > endLine || startLine >= this.myLines.size() || endLine < 0) {
            return;
        }
        startLine = Math.max(0, startLine);
        endLine = Math.min(this.myLines.size() - 1, endLine);
        this.invalidateLines(startLine, endLine, endLine);
    }

    private void invalidateLines(int startLine, int oldEndLine, int newEndLine) {
        int endLine = Math.min(oldEndLine, newEndLine);
        for (int line = startLine; line <= endLine; ++line) {
            this.myLines.set(line, null);
        }
        if (oldEndLine < newEndLine) {
            this.myLines.addAll(oldEndLine + 1, Collections.nCopies(newEndLine - oldEndLine, null));
        } else if (oldEndLine > newEndLine) {
            this.myLines.subList(newEndLine + 1, oldEndLine + 1).clear();
        }
    }

    public void reinitAllForEditorTextFieldCellRenderer() {
        this.invalidateCachedWidth();
        this.invalidateLines(0, this.myLines.size() - 1, this.myDocument.getLineCount() - 1);
    }

    private LineView getLineRenderer(int line) {
        LineView renderer = this.myLines.get(line);
        if (renderer == null) {
            int lineStart = this.myDocument.getLineStartOffset(line);
            int lineEnd = this.myDocument.getLineEndOffset(line);
            renderer = new LineView(this.myEditor, lineStart, lineEnd, this.myFontRenderContext);
            this.myLines.set(line, renderer);
            int width = renderer.getWidthInPixels();
            if (this.myWidthInPixels >= 0 && width > this.myWidthInPixels) {
                this.myWidthInPixels = width;
                this.myEditor.getContentComponent().revalidate();
            }
        }
        return renderer;
    }
}

