/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.view;

import gnu.trove.TFloatArrayList;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.Nullable;

public class TextLayoutHighlightShape {
    private static final BasicStroke DEFAULT_STROKE = new BasicStroke();
    private final Shape myShape;
    private final float myHeight;

    public TextLayoutHighlightShape(@Nullable TextLayout textLayout, int start, int end, int ascent, int height) {
        this.myHeight = height;
        if (textLayout == null) {
            Path2D.Float shape = new Path2D.Float();
            shape.moveTo(0.0f, 0.0f);
            shape.lineTo(0.0f, 0.0f);
            shape.lineTo(0.0f, height);
            shape.lineTo(0.0f, height);
            shape.closePath();
            this.myShape = shape;
        } else {
            Rectangle2D.Float clip = new Rectangle2D.Float(0.0f, -ascent, textLayout.getAdvance(), height);
            Shape shape = textLayout.getLogicalHighlightShape(start, end, clip);
            this.myShape = AffineTransform.getTranslateInstance(0.0, ascent).createTransformedShape(shape);
        }
    }

    public void draw(Graphics2D g, boolean rounded) {
        TFloatArrayList[] coords = this.getAdjustedChunksCoordinates();
        if (coords == null) {
            return;
        }
        g.setStroke(DEFAULT_STROKE);
        float maxY = this.myHeight - 1.0f;
        for (int i = 0; i < coords[0].size(); i += 2) {
            float topStart = coords[0].get(i);
            float topEnd = coords[0].get(i + 1);
            float bottomStart = coords[1].get(i);
            float bottomEnd = coords[1].get(i + 1);
            Path2D.Float path = new Path2D.Float();
            TextLayoutHighlightShape.addLine(path, topStart, 0.0f, topEnd, 0.0f, rounded);
            TextLayoutHighlightShape.addLine(path, topEnd, 0.0f, bottomEnd, maxY, rounded);
            TextLayoutHighlightShape.addLine(path, bottomEnd, maxY, bottomStart, maxY, rounded);
            TextLayoutHighlightShape.addLine(path, bottomStart, maxY, topStart, 0.0f, rounded);
            g.draw(path);
        }
    }

    @Nullable
    private TFloatArrayList[] getAdjustedChunksCoordinates() {
        TFloatArrayList[] coords = new TFloatArrayList[]{new TFloatArrayList(), new TFloatArrayList()};
        PathIterator it = this.myShape.getPathIterator(null);
        float[] data = new float[6];
        while (!it.isDone()) {
            switch (it.currentSegment(data)) {
                case 0: 
                case 1: {
                    this.addBoundaryPoint(data[0], data[1], coords);
                    break;
                }
                case 2: {
                    this.addBoundaryPoint(data[2], data[3], coords);
                    break;
                }
                case 3: {
                    this.addBoundaryPoint(data[4], data[5], coords);
                }
            }
            it.next();
        }
        if (coords[0].isEmpty() || coords[0].size() != coords[1].size() || coords[0].size() % 2 != 0 || coords[1].size() % 2 != 0) {
            return null;
        }
        coords[0].sort();
        coords[1].sort();
        int pos = 2;
        while (pos < coords[0].size()) {
            if (coords[0].get(pos) == coords[0].get(pos - 1) && coords[1].get(pos) == coords[1].get(pos - 1)) {
                coords[0].remove(pos - 1, 2);
                coords[1].remove(pos - 1, 2);
                continue;
            }
            pos += 2;
        }
        for (int i = 0; i < coords[0].size(); i += 2) {
            float topStart = coords[0].get(i);
            float topEnd = coords[0].get(i + 1);
            float bottomStart = coords[1].get(i);
            float bottomEnd = coords[1].get(i + 1);
            if (topStart == topEnd) {
                coords[0].set(i + 1, topEnd + 1.0f);
            } else {
                coords[0].set(i + 1, topEnd - 1.0f);
            }
            if (bottomStart == bottomEnd) {
                coords[1].set(i + 1, bottomEnd + 1.0f);
                continue;
            }
            float slopeLeft = (bottomStart - topStart) / this.myHeight;
            float slopeRight = (bottomEnd - topEnd) / this.myHeight;
            coords[1].set(i, bottomStart - slopeLeft);
            coords[1].set(i + 1, bottomEnd - 1.0f - slopeRight);
        }
        return coords;
    }

    private void addBoundaryPoint(float x, float y, TFloatArrayList[] coords) {
        if (y == 0.0f) {
            coords[0].add(x);
        } else if (y == this.myHeight) {
            coords[1].add(x);
        }
    }

    public void fill(Graphics2D g) {
        g.fill(this.myShape);
    }

    public void setAsClip(Graphics2D g) {
        g.setClip(this.myShape);
    }

    public static void drawCombined(Graphics2D g, TextLayoutHighlightShape leadingShape, TextLayoutHighlightShape trailingShape, int verticalShift, int maxWidth, boolean extendFirstLineToTheRight, boolean rounded) {
        float bottomStart;
        TFloatArrayList[] leadingCoords = leadingShape.getAdjustedChunksCoordinates();
        TFloatArrayList[] trailingCoords = trailingShape.getAdjustedChunksCoordinates();
        if (leadingCoords == null || trailingCoords == null) {
            return;
        }
        --maxWidth;
        boolean containsInnerLines = (float)verticalShift > leadingShape.myHeight;
        Path2D.Float path = new Path2D.Float();
        float bottomY = leadingShape.myHeight - 1.0f;
        float topStart = 0.0f;
        float topEnd = 0.0f;
        float bottomEnd = 0.0f;
        float leftGap = leadingCoords[1].get(0) - (containsInnerLines ? 0.0f : trailingCoords[0].get(0));
        float adjustY = leftGap == 0.0f ? 2.0f : (leftGap > 0.0f ? 1.0f : 0.0f);
        for (int i = 0; i < leadingCoords[0].size(); i += 2) {
            topStart = leadingCoords[0].get(i);
            topEnd = leadingCoords[0].get(i + 1);
            bottomStart = leadingCoords[1].get(i);
            bottomEnd = leadingCoords[1].get(i + 1);
            if (i > 0) {
                TextLayoutHighlightShape.addLine(path, leadingCoords[1].get(i - 1), bottomY, bottomStart, bottomY, rounded);
            }
            TextLayoutHighlightShape.addLine(path, bottomStart, bottomY + adjustY, topStart, 0.0f, rounded);
            if (i + 2 < leadingCoords[0].size() || !extendFirstLineToTheRight) {
                TextLayoutHighlightShape.addLine(path, topStart, 0.0f, topEnd, 0.0f, rounded);
                TextLayoutHighlightShape.addLine(path, topEnd, 0.0f, bottomEnd, bottomY, rounded);
            }
            adjustY = 0.0f;
        }
        if (extendFirstLineToTheRight) {
            topEnd = Math.max(topEnd, (float)maxWidth);
            TextLayoutHighlightShape.addLine(path, topStart, 0.0f, topEnd, 0.0f, rounded);
            TextLayoutHighlightShape.addLine(path, topEnd, 0.0f, topEnd, verticalShift - 1, rounded);
        } else if (containsInnerLines) {
            if (bottomEnd < (float)maxWidth) {
                TextLayoutHighlightShape.addLine(path, bottomEnd, bottomY + 1.0f, rounded);
                TextLayoutHighlightShape.addLine(path, bottomEnd, bottomY + 1.0f, maxWidth, bottomY + 1.0f, rounded);
                TextLayoutHighlightShape.addLine(path, maxWidth, bottomY + 1.0f, maxWidth, verticalShift - 1, rounded);
            } else {
                TextLayoutHighlightShape.addLine(path, bottomEnd, verticalShift - 1, rounded);
            }
        }
        bottomY = trailingShape.myHeight - 1.0f + (float)verticalShift;
        float lastX = (float)path.getCurrentPoint().getX();
        float targetX = trailingCoords[0].get(trailingCoords[0].size() - 1);
        if (lastX < targetX) {
            TextLayoutHighlightShape.addLine(path, lastX, verticalShift, rounded);
            TextLayoutHighlightShape.addLine(path, lastX, verticalShift, targetX, verticalShift, rounded);
        } else {
            TextLayoutHighlightShape.addLine(path, lastX, verticalShift - 1, targetX, verticalShift - 1, rounded);
            adjustY = lastX == targetX ? -2.0f : -1.0f;
        }
        for (int i = trailingCoords[0].size() - 2; i >= 0; i -= 2) {
            topStart = trailingCoords[0].get(i);
            topEnd = trailingCoords[0].get(i + 1);
            bottomStart = trailingCoords[1].get(i);
            bottomEnd = trailingCoords[1].get(i + 1);
            TextLayoutHighlightShape.addLine(path, topEnd, (float)verticalShift + adjustY, bottomEnd, bottomY, rounded);
            TextLayoutHighlightShape.addLine(path, bottomEnd, bottomY, bottomStart, bottomY, rounded);
            TextLayoutHighlightShape.addLine(path, bottomStart, bottomY, topStart, verticalShift, rounded);
            if (i > 0) {
                TextLayoutHighlightShape.addLine(path, topStart, verticalShift, trailingCoords[0].get(i - 1), verticalShift, rounded);
            }
            adjustY = 0.0f;
        }
        if (containsInnerLines) {
            if (topStart > 0.0f) {
                TextLayoutHighlightShape.addLine(path, topStart, verticalShift + 1, rounded);
                TextLayoutHighlightShape.addLine(path, topStart, verticalShift + 1, 0.0f, verticalShift + 1, rounded);
                TextLayoutHighlightShape.addLine(path, 0.0f, verticalShift + 1, 0.0f, leadingShape.myHeight, rounded);
            } else {
                TextLayoutHighlightShape.addLine(path, 0.0f, leadingShape.myHeight, rounded);
            }
        }
        lastX = (float)path.getCurrentPoint().getX();
        targetX = leadingCoords[1].get(0);
        bottomY = leadingShape.myHeight - 1.0f;
        if (lastX < targetX) {
            TextLayoutHighlightShape.addLine(path, lastX, bottomY + 1.0f, targetX, bottomY + 1.0f, rounded);
        } else {
            TextLayoutHighlightShape.addLine(path, lastX, bottomY, rounded);
            TextLayoutHighlightShape.addLine(path, lastX, bottomY, targetX, bottomY, rounded);
        }
        g.setStroke(DEFAULT_STROKE);
        g.draw(path);
    }

    private static void addLine(Path2D path, float toX, float toY, boolean rounded) {
        TextLayoutHighlightShape.addLine(path, (float)path.getCurrentPoint().getX(), (float)path.getCurrentPoint().getY(), toX, toY, false, rounded);
    }

    private static void addLine(Path2D path, float fromX, float fromY, float toX, float toY, boolean rounded) {
        TextLayoutHighlightShape.addLine(path, fromX, fromY, toX, toY, rounded, rounded);
    }

    private static void addLine(Path2D path, float fromX, float fromY, float toX, float toY, boolean roundedStart, boolean roundedEnd) {
        if (roundedStart || roundedEnd) {
            float distX = Math.abs(toX - fromX);
            float distY = Math.abs(toY - fromY);
            if (distX >= 2.0f || distY >= 2.0f) {
                float dy;
                float dx;
                if (distX > distY) {
                    dx = Math.signum(toX - fromX);
                    dy = (toY - fromY) / distX;
                } else {
                    dy = Math.signum(toY - fromY);
                    dx = (toX - fromX) / distY;
                }
                if (roundedStart) {
                    fromX += dx;
                    fromY += dy;
                }
                if (roundedEnd) {
                    toX -= dx;
                    toY -= dy;
                }
            } else {
                return;
            }
        }
        path.moveTo(fromX, fromY);
        path.lineTo(toX, toY);
    }
}

