/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.LibraryPathType;
import com.intellij.openapi.externalSystem.service.project.ExternalLibraryPathTypeMapper;
import com.intellij.openapi.externalSystem.service.project.PlatformFacade;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataServiceEx;
import com.intellij.openapi.externalSystem.util.DisposeAwareProjectChange;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemConstants;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

@Order(value=42)
public class LibraryDataService
implements ProjectDataServiceEx<LibraryData, Library> {
    private static final Logger LOG = Logger.getInstance((String)("#" + LibraryDataService.class.getName()));
    @NotNull
    public static final NotNullFunction<String, File> PATH_TO_FILE = new NotNullFunction<String, File>(){

        @NotNull
        public File fun(String path) {
            File file = new File(path);
            if (file == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService$1", "fun"));
            }
            return file;
        }
    };
    @NotNull
    private final ExternalLibraryPathTypeMapper myLibraryPathTypeMapper;

    public LibraryDataService(@NotNull ExternalLibraryPathTypeMapper mapper) {
        if (mapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapper", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService", "<init>"));
        }
        this.myLibraryPathTypeMapper = mapper;
    }

    @NotNull
    public Key<LibraryData> getTargetDataKey() {
        Key key = ProjectKeys.LIBRARY;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService", "getTargetDataKey"));
        }
        return key;
    }

    public void importData(@NotNull Collection<DataNode<LibraryData>> toImport, @NotNull Project project, boolean synchronous) {
        if (toImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toImport", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService", "importData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService", "importData"));
        }
        PlatformFacade platformFacade = (PlatformFacade)ServiceManager.getService(PlatformFacade.class);
        this.importData(toImport, project, platformFacade, synchronous);
    }

    @Override
    public void importData(@NotNull Collection<DataNode<LibraryData>> toImport, @NotNull Project project, @NotNull PlatformFacade platformFacade, boolean synchronous) {
        if (toImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toImport", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService", "importData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService", "importData"));
        }
        if (platformFacade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "platformFacade", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService", "importData"));
        }
        for (DataNode<LibraryData> dataNode : toImport) {
            this.importLibrary((LibraryData)dataNode.getData(), project, platformFacade, synchronous);
        }
    }

    private void importLibrary(@NotNull LibraryData toImport, @NotNull Project project, @NotNull PlatformFacade platformFacade, boolean synchronous) {
        if (toImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toImport", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService", "importLibrary"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService", "importLibrary"));
        }
        if (platformFacade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "platformFacade", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService", "importLibrary"));
        }
        Map<OrderRootType, Collection<File>> libraryFiles = this.prepareLibraryFiles(toImport);
        Library library = platformFacade.findIdeLibrary(toImport, project);
        if (library != null) {
            this.syncPaths(toImport, library, project, synchronous);
            return;
        }
        this.importLibrary(toImport.getInternalName(), libraryFiles, project, platformFacade, synchronous);
    }

    @NotNull
    public Map<OrderRootType, Collection<File>> prepareLibraryFiles(@NotNull LibraryData data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService", "prepareLibraryFiles"));
        }
        HashMap result = ContainerUtilRt.newHashMap();
        for (LibraryPathType pathType : LibraryPathType.values()) {
            Set paths = data.getPaths(pathType);
            if (paths.isEmpty()) continue;
            result.put(this.myLibraryPathTypeMapper.map(pathType), ContainerUtil.map((Collection)paths, PATH_TO_FILE));
        }
        HashMap hashMap = result;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService", "prepareLibraryFiles"));
        }
        return hashMap;
    }

    private void importLibrary(final @NotNull String libraryName, final @NotNull Map<OrderRootType, Collection<File>> libraryFiles, final @NotNull Project project, final @NotNull PlatformFacade platformFacade, boolean synchronous) {
        if (libraryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryName", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService", "importLibrary"));
        }
        if (libraryFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryFiles", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService", "importLibrary"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService", "importLibrary"));
        }
        if (platformFacade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "platformFacade", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService", "importLibrary"));
        }
        ExternalSystemApiUtil.executeProjectChangeAction((boolean)synchronous, (DisposeAwareProjectChange)new DisposeAwareProjectChange((ComponentManager)project){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute() {
                Library intellijLibrary;
                LibraryTable libraryTable = platformFacade.getProjectLibraryTable(project);
                LibraryTable.ModifiableModel projectLibraryModel = libraryTable.getModifiableModel();
                try {
                    intellijLibrary = projectLibraryModel.createLibrary(libraryName);
                }
                finally {
                    projectLibraryModel.commit();
                }
                Library.ModifiableModel libraryModel = intellijLibrary.getModifiableModel();
                try {
                    LibraryDataService.this.registerPaths(libraryFiles, libraryModel, libraryName);
                }
                finally {
                    libraryModel.commit();
                }
            }
        });
    }

    public void registerPaths(@NotNull Map<OrderRootType, Collection<File>> libraryFiles, @NotNull Library.ModifiableModel model, @NotNull String libraryName) {
        if (libraryFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryFiles", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService", "registerPaths"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService", "registerPaths"));
        }
        if (libraryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryName", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService", "registerPaths"));
        }
        for (Map.Entry<OrderRootType, Collection<File>> entry : libraryFiles.entrySet()) {
            for (File file : entry.getValue()) {
                VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
                if (virtualFile == null) {
                    String[] urls;
                    String url;
                    if (ExternalSystemConstants.VERBOSE_PROCESSING && entry.getKey() == OrderRootType.CLASSES) {
                        LOG.warn(String.format("Can't find %s of the library '%s' at path '%s'", entry.getKey(), libraryName, file.getAbsolutePath()));
                    }
                    if (ArrayUtil.contains((String)(url = VfsUtil.getUrlForLibraryRoot((File)file)), (String[])(urls = model.getUrls(entry.getKey())))) continue;
                    model.addRoot(url, entry.getKey());
                    continue;
                }
                if (virtualFile.isDirectory()) {
                    Object[] files = model.getFiles(entry.getKey());
                    if (ArrayUtil.contains((Object)virtualFile, (Object[])files)) continue;
                    model.addRoot(virtualFile, entry.getKey());
                    continue;
                }
                VirtualFile jarRoot = JarFileSystem.getInstance().getJarRootForLocalFile(virtualFile);
                if (jarRoot == null) {
                    LOG.warn(String.format("Can't parse contents of the JAR file at path '%s' for the library '%s''", file.getAbsolutePath(), libraryName));
                    continue;
                }
                Object[] files = model.getFiles(entry.getKey());
                if (ArrayUtil.contains((Object)jarRoot, (Object[])files)) continue;
                model.addRoot(jarRoot, entry.getKey());
            }
        }
    }

    public void removeData(@NotNull Collection<? extends Library> libraries, @NotNull Project project, boolean synchronous) {
        if (libraries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraries", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService", "removeData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService", "removeData"));
        }
        PlatformFacade platformFacade = (PlatformFacade)ServiceManager.getService(PlatformFacade.class);
        this.removeData(libraries, project, platformFacade, synchronous);
    }

    @Override
    public void removeData(final @NotNull Collection<? extends Library> libraries, final @NotNull Project project, final @NotNull PlatformFacade platformFacade, boolean synchronous) {
        if (libraries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraries", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService", "removeData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService", "removeData"));
        }
        if (platformFacade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "platformFacade", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService", "removeData"));
        }
        if (libraries.isEmpty()) {
            return;
        }
        ExternalSystemApiUtil.executeProjectChangeAction((boolean)synchronous, (DisposeAwareProjectChange)new DisposeAwareProjectChange((ComponentManager)project){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute() {
                LibraryTable libraryTable = platformFacade.getProjectLibraryTable(project);
                LibraryTable.ModifiableModel model = libraryTable.getModifiableModel();
                try {
                    for (Library library : libraries) {
                        Library libraryToRemove;
                        String libraryName = library.getName();
                        if (libraryName == null || (libraryToRemove = model.getLibraryByName(libraryName)) == null) continue;
                        model.removeLibrary(libraryToRemove);
                    }
                }
                finally {
                    model.commit();
                }
            }
        });
    }

    public void syncPaths(final @NotNull LibraryData externalLibrary, final @NotNull Library ideLibrary, @NotNull Project project, boolean synchronous) {
        if (externalLibrary == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalLibrary", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService", "syncPaths"));
        }
        if (ideLibrary == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideLibrary", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService", "syncPaths"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService", "syncPaths"));
        }
        if (externalLibrary.isUnresolved()) {
            return;
        }
        final HashMap toRemove = ContainerUtilRt.newHashMap();
        final HashMap toAdd = ContainerUtilRt.newHashMap();
        for (LibraryPathType pathType : LibraryPathType.values()) {
            OrderRootType ideType = this.myLibraryPathTypeMapper.map(pathType);
            HashSet toAddPerType = ContainerUtilRt.newHashSet((Iterable)externalLibrary.getPaths(pathType));
            toAdd.put(ideType, toAddPerType);
            HashSet toRemovePerType = ContainerUtilRt.newHashSet();
            toRemove.put(ideType, toRemovePerType);
            for (VirtualFile ideFile : ideLibrary.getFiles(ideType)) {
                String idePath = ExternalSystemApiUtil.getLocalFileSystemPath((VirtualFile)ideFile);
                if (toAddPerType.remove(idePath)) continue;
                toRemovePerType.add(ideFile.getUrl());
            }
        }
        if (toRemove.isEmpty() && toAdd.isEmpty()) {
            return;
        }
        ExternalSystemApiUtil.executeProjectChangeAction((boolean)synchronous, (DisposeAwareProjectChange)new DisposeAwareProjectChange((ComponentManager)project){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute() {
                Library.ModifiableModel model = ideLibrary.getModifiableModel();
                try {
                    for (Map.Entry entry : toRemove.entrySet()) {
                        for (String path : (Set)entry.getValue()) {
                            model.removeRoot(path, (OrderRootType)entry.getKey());
                        }
                    }
                    for (Map.Entry entry : toAdd.entrySet()) {
                        HashMap roots = ContainerUtilRt.newHashMap();
                        roots.put(entry.getKey(), ContainerUtil.map((Collection)((Collection)entry.getValue()), PATH_TO_FILE));
                        LibraryDataService.this.registerPaths(roots, model, externalLibrary.getInternalName());
                    }
                }
                finally {
                    model.commit();
                }
            }
        });
    }
}

