/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions.diff;

import com.intellij.diff.actions.impl.GoToChangePopupBuilder;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowser;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.util.Consumer;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ChangeGoToChangePopupAction<Chain extends DiffRequestChain>
extends GoToChangePopupBuilder.BaseGoToChangePopupAction<Chain> {
    public ChangeGoToChangePopupAction(@NotNull Chain chain, @NotNull Consumer onSelected) {
        if (chain == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chain", "com/intellij/openapi/vcs/changes/actions/diff/ChangeGoToChangePopupAction", "<init>"));
        }
        if (onSelected == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onSelected", "com/intellij/openapi/vcs/changes/actions/diff/ChangeGoToChangePopupAction", "<init>"));
        }
        super(chain, (Consumer<Integer>)onSelected);
    }

    @Override
    @NotNull
    protected JBPopup createPopup(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/changes/actions/diff/ChangeGoToChangePopupAction", "createPopup"));
        }
        Project project = e.getProject();
        if (project == null) {
            project = ProjectManager.getInstance().getDefaultProject();
        }
        Ref popup = new Ref();
        MyChangesBrowser cb = new MyChangesBrowser(project, this.getChanges(), this.getCurrentSelection(), (Ref<JBPopup>)popup);
        popup.set((Object)JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)cb, cb.getPreferredFocusedComponent()).setResizable(true).setModalContext(false).setFocusable(true).setRequestFocus(true).setCancelOnWindowDeactivation(true).setCancelOnOtherWindowOpen(true).setMovable(true).setCancelKeyEnabled(true).setCancelOnClickOutside(true).createPopup());
        JBPopup jBPopup = (JBPopup)popup.get();
        if (jBPopup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/actions/diff/ChangeGoToChangePopupAction", "createPopup"));
        }
        return jBPopup;
    }

    protected abstract int findSelectedStep(@Nullable Change var1);

    @NotNull
    protected abstract List<Change> getChanges();

    @Nullable
    protected abstract Change getCurrentSelection();

    private class MyChangesBrowser
    extends ChangesBrowser
    implements Runnable {
        @NotNull
        Ref<JBPopup> myPopup;

        public MyChangesBrowser(@NotNull Project project, @Nullable List<Change> changes, @NotNull Change currentChange, Ref<JBPopup> popup) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/actions/diff/ChangeGoToChangePopupAction$MyChangesBrowser", "<init>"));
            }
            if (changes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/openapi/vcs/changes/actions/diff/ChangeGoToChangePopupAction$MyChangesBrowser", "<init>"));
            }
            if (popup == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popup", "com/intellij/openapi/vcs/changes/actions/diff/ChangeGoToChangePopupAction$MyChangesBrowser", "<init>"));
            }
            super(project, null, changes, null, false, false, null, ChangesBrowser.MyUseCase.LOCAL_CHANGES, null);
            this.setSelectionMode(0);
            this.setChangesToDisplay(changes);
            if (currentChange != null) {
                this.select(Collections.singletonList(currentChange));
            }
            this.myPopup = popup;
        }

        @Override
        protected void buildToolBar(DefaultActionGroup toolBarGroup) {
        }

        @Override
        @NotNull
        protected Runnable getDoubleClickHandler() {
            MyChangesBrowser myChangesBrowser = this;
            if (myChangesBrowser == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/actions/diff/ChangeGoToChangePopupAction$MyChangesBrowser", "getDoubleClickHandler"));
            }
            return myChangesBrowser;
        }

        @Override
        public void run() {
            Change change = this.getSelectedChanges().get(0);
            final int index = ChangeGoToChangePopupAction.this.findSelectedStep(change);
            ((JBPopup)this.myPopup.get()).cancel();
            IdeFocusManager.getInstance((Project)this.myProject).doWhenFocusSettlesDown(new Runnable(){

                @Override
                public void run() {
                    ChangeGoToChangePopupAction.this.myOnSelected.consume((Object)index);
                }
            });
        }
    }
}

