/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.impl.VcsInitObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;

public class VcsInitialization {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.impl.VcsInitialization");
    private final List<Pair<VcsInitObject, Runnable>> myList;
    private final Object myLock;
    private boolean myInitStarted;
    private volatile Future<?> myFuture;

    public VcsInitialization(final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/impl/VcsInitialization", "<init>"));
        }
        this.myList = new ArrayList<Pair<VcsInitObject, Runnable>>();
        this.myLock = new Object();
        StartupManager.getInstance((Project)project).registerPostStartupActivity((Runnable)new DumbAwareRunnable(){

            public void run() {
                if (project.isDisposed()) {
                    return;
                }
                VcsInitialization.this.myFuture = ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                    @Override
                    public void run() {
                        if (!project.isDisposed()) {
                            VcsInitialization.this.execute();
                        }
                    }
                });
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(@NotNull VcsInitObject vcsInitObject, @NotNull Runnable runnable) {
        if (vcsInitObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsInitObject", "com/intellij/openapi/vcs/impl/VcsInitialization", "add"));
        }
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/vcs/impl/VcsInitialization", "add"));
        }
        Object object = this.myLock;
        synchronized (object) {
            if (this.myInitStarted) {
                if (!vcsInitObject.isCanBeLast()) {
                    LOG.info("Registering startup activity AFTER initialization ", new Throwable());
                }
                ApplicationManager.getApplication().invokeLater(runnable);
                return;
            }
            this.myList.add((Pair<VcsInitObject, Runnable>)Pair.create((Object)((Object)vcsInitObject), (Object)runnable));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        List<Pair<VcsInitObject, Runnable>> list;
        Object object = this.myLock;
        synchronized (object) {
            list = this.myList;
            this.myInitStarted = true;
        }
        Collections.sort(list, new Comparator<Pair<VcsInitObject, Runnable>>(){

            @Override
            public int compare(Pair<VcsInitObject, Runnable> o1, Pair<VcsInitObject, Runnable> o2) {
                return ((VcsInitObject)((Object)o1.getFirst())).getOrder() - ((VcsInitObject)((Object)o2.getFirst())).getOrder();
            }
        });
        for (Pair<VcsInitObject, Runnable> pair : list) {
            ((Runnable)pair.getSecond()).run();
        }
    }

    public void waitForInitialized() {
        try {
            this.myFuture.get();
            this.myFuture = null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

